/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.http;

import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;

public class HttpResponse
extends HttpRequest {
    private int status;

    public HttpResponse(String strUrl) {
        super(strUrl);
    }

    public HttpResponse() {
    }

    @Override
    public void setHttpContent(byte[] content, String encoding, FormatType format) {
        this.httpContent = content;
        this.encoding = encoding;
        this.httpContentType = format;
    }

    @Override
    public String getHeaderValue(String name) {
        String value = (String)this.headers.get(name);
        if (null == value) {
            value = (String)this.headers.get(name.toLowerCase());
        }
        return value;
    }

    private static byte[] readContent(InputStream content) throws IOException {
        int read;
        if (content == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((read = content.read(buff)) != -1) {
            outputStream.write(buff, 0, read);
        }
        return outputStream.toByteArray();
    }

    private static void pasrseHttpConn(HttpResponse response, HttpURLConnection httpConn, InputStream content) throws IOException {
        byte[] buff = HttpResponse.readContent(content);
        response.setStatus(httpConn.getResponseCode());
        Map<String, List<String>> headers = httpConn.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (null == key) continue;
            List<String> values = entry.getValue();
            StringBuilder builder = new StringBuilder(values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                builder.append(",");
                builder.append(values.get(i));
            }
            response.putHeaderParameter(key, builder.toString());
        }
        String type = response.getHeaderValue("Content-Type");
        if (null != buff && null != type) {
            response.setEncoding("UTF-8");
            String[] split = type.split(";");
            response.setHttpContentType(FormatType.mapAcceptToFormat(split[0].trim()));
            if (split.length > 1 && split[1].contains("=")) {
                String[] codings = split[1].split("=");
                response.setEncoding(codings[1].trim().toUpperCase());
            }
        }
        response.setStatus(httpConn.getResponseCode());
        response.setHttpContent(buff, response.getEncoding(), response.getHttpContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse getResponse(HttpRequest request) throws IOException {
        OutputStream out = null;
        InputStream content = null;
        HttpResponse response = null;
        HttpURLConnection httpConn = request.buildHttpConnection();
        try {
            httpConn.connect();
            if (null != request.getHttpContent() && request.getHttpContent().length > 0) {
                out = httpConn.getOutputStream();
                out.write(request.getHttpContent());
            }
            content = httpConn.getInputStream();
            response = new HttpResponse(httpConn.getURL().toString());
            HttpResponse.pasrseHttpConn(response, httpConn, content);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (IOException e) {
            content = httpConn.getErrorStream();
            response = new HttpResponse(httpConn.getURL().toString());
            HttpResponse.pasrseHttpConn(response, httpConn, content);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (content != null) {
                content.close();
            }
            httpConn.disconnect();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isSuccess() {
        return 200 <= this.status && 300 > this.status;
    }
}

