/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.endpoint;

import com.aliyuncs.IAcsClient;
import com.aliyuncs.endpoint.ChainedEndpointResolver;
import com.aliyuncs.endpoint.EndpointResolver;
import com.aliyuncs.endpoint.EndpointResolverBase;
import com.aliyuncs.endpoint.EndpointResolverRules;
import com.aliyuncs.endpoint.InternalLocationServiceEndpointResolver;
import com.aliyuncs.endpoint.LocalConfigGlobalEndpointResolver;
import com.aliyuncs.endpoint.LocalConfigRegionalEndpointResolver;
import com.aliyuncs.endpoint.LocationServiceEndpointResolver;
import com.aliyuncs.endpoint.ResolveEndpointRequest;
import com.aliyuncs.endpoint.UserCustomizedEndpointResolver;
import com.aliyuncs.endpoint.UserVpcEndpointResolver;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.ArrayList;

public class DefaultEndpointResolver
implements EndpointResolver {
    public static UserCustomizedEndpointResolver predefinedEndpointResolver = new UserCustomizedEndpointResolver();
    private UserCustomizedEndpointResolver userCustomizedEndpointResolver = new UserCustomizedEndpointResolver();
    private EndpointResolver insideEndpointResolver;

    public DefaultEndpointResolver(IAcsClient client, String userConfig, IClientProfile profile) {
        EndpointResolverRules endpointResolverRules = new EndpointResolverRules();
        ArrayList<EndpointResolverBase> resolverChain = new ArrayList<EndpointResolverBase>();
        resolverChain.add(predefinedEndpointResolver);
        resolverChain.add(this.userCustomizedEndpointResolver);
        if (profile.isUsingVpcEndpoint()) {
            resolverChain.add(new UserVpcEndpointResolver());
        }
        resolverChain.add(endpointResolverRules);
        if (userConfig == null) {
            resolverChain.add(new LocalConfigRegionalEndpointResolver());
            resolverChain.add(new LocalConfigGlobalEndpointResolver());
        } else {
            resolverChain.add(new LocalConfigRegionalEndpointResolver(userConfig));
            resolverChain.add(new LocalConfigGlobalEndpointResolver(userConfig));
        }
        if (profile.isUsingInternalLocationService()) {
            resolverChain.add(new InternalLocationServiceEndpointResolver(client));
        } else {
            resolverChain.add(new LocationServiceEndpointResolver(client));
        }
        this.insideEndpointResolver = new ChainedEndpointResolver(resolverChain);
    }

    public DefaultEndpointResolver(IAcsClient client) {
        this(client, null, DefaultProfile.getProfile(null));
    }

    public DefaultEndpointResolver(IAcsClient client, IClientProfile profile) {
        this(client, null, profile);
    }

    @Override
    public String resolve(ResolveEndpointRequest request) throws ClientException {
        return this.insideEndpointResolver.resolve(request);
    }

    public void putEndpointEntry(String regionId, String productCode, String endpoint) {
        this.userCustomizedEndpointResolver.putEndpointEntry(regionId, productCode, endpoint);
    }
}

