/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.dts.model.v20200101;

import java.util.List;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.dts.transform.v20200101.DescribeSubscriptionMetaResponseUnmarshaller;
import com.aliyuncs.transform.UnmarshallerContext;

/**
 * @author auto create
 * @version 
 */
public class DescribeSubscriptionMetaResponse extends AcsResponse {

	private String errCode;

	private String errMessage;

	private String httpStatusCode;

	private String requestId;

	private String success;

	private List<SubscriptionMetaListItem> subscriptionMetaList;

	public String getErrCode() {
		return this.errCode;
	}

	public void setErrCode(String errCode) {
		this.errCode = errCode;
	}

	public String getErrMessage() {
		return this.errMessage;
	}

	public void setErrMessage(String errMessage) {
		this.errMessage = errMessage;
	}

	public String getHttpStatusCode() {
		return this.httpStatusCode;
	}

	public void setHttpStatusCode(String httpStatusCode) {
		this.httpStatusCode = httpStatusCode;
	}

	public String getRequestId() {
		return this.requestId;
	}

	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	public String getSuccess() {
		return this.success;
	}

	public void setSuccess(String success) {
		this.success = success;
	}

	public List<SubscriptionMetaListItem> getSubscriptionMetaList() {
		return this.subscriptionMetaList;
	}

	public void setSubscriptionMetaList(List<SubscriptionMetaListItem> subscriptionMetaList) {
		this.subscriptionMetaList = subscriptionMetaList;
	}

	public static class SubscriptionMetaListItem {

		private String dProxyUrl;

		private String topic;

		private String sid;

		private Long checkpoint;

		private String dBList;

		public String getDProxyUrl() {
			return this.dProxyUrl;
		}

		public void setDProxyUrl(String dProxyUrl) {
			this.dProxyUrl = dProxyUrl;
		}

		public String getTopic() {
			return this.topic;
		}

		public void setTopic(String topic) {
			this.topic = topic;
		}

		public String getSid() {
			return this.sid;
		}

		public void setSid(String sid) {
			this.sid = sid;
		}

		public Long getCheckpoint() {
			return this.checkpoint;
		}

		public void setCheckpoint(Long checkpoint) {
			this.checkpoint = checkpoint;
		}

		public String getDBList() {
			return this.dBList;
		}

		public void setDBList(String dBList) {
			this.dBList = dBList;
		}
	}

	@Override
	public DescribeSubscriptionMetaResponse getInstance(UnmarshallerContext context) {
		return	DescribeSubscriptionMetaResponseUnmarshaller.unmarshall(this, context);
	}

	@Override
	public boolean checkShowJsonItemName() {
		return false;
	}
}
