/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.spark.DefaultHelper;
import com.mongodb.spark.MongoConnector;
import com.mongodb.spark.MongoConnector$;
import com.mongodb.spark.MongoSpark;
import com.mongodb.spark.MongoSpark$;
import com.mongodb.spark.MongoSpark$$anonfun$save$3$;
import com.mongodb.spark.MongoSpark$$anonfun$save$3$$anonfun$apply$3$;
import com.mongodb.spark.config.MongoCollectionConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.config.ReadConfig$;
import com.mongodb.spark.config.WriteConfig;
import com.mongodb.spark.config.WriteConfig$;
import com.mongodb.spark.package$;
import com.mongodb.spark.rdd.MongoRDD;
import com.mongodb.spark.rdd.api.java.JavaMongoRDD;
import com.mongodb.spark.sql.MapFunctions$;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;

public final class MongoSpark$
implements Serializable {
    public static final MongoSpark$ MODULE$;
    private final String defaultSource;

    static {
        new MongoSpark$();
    }

    public String defaultSource() {
        return this.defaultSource;
    }

    public MongoSpark.Builder builder() {
        return new MongoSpark.Builder();
    }

    public <D> MongoRDD<D> load(SparkContext sc, ClassTag<D> evidence$1, DefaultHelper.DefaultsTo<D, Document> e) {
        return this.load(sc, (ReadConfig)ReadConfig$.MODULE$.apply(sc), evidence$1, e);
    }

    public <D> MongoRDD<D> load(SparkContext sc, ReadConfig readConfig, ClassTag<D> evidence$2, DefaultHelper.DefaultsTo<D, Document> e) {
        return this.builder().sparkContext(sc).readConfig(readConfig).build().toRDD(evidence$2, e);
    }

    public <D extends Product> Dataset<Row> load(SparkSession sparkSession, TypeTags.TypeTag<D> evidence$3) {
        return this.builder().sparkSession(sparkSession).build().toDF(evidence$3);
    }

    public <D extends Product> Dataset<Row> load(SparkSession sparkSession, ReadConfig readConfig, TypeTags.TypeTag<D> evidence$4) {
        return this.builder().sparkSession(sparkSession).readConfig(readConfig).build().toDF(evidence$4);
    }

    public <D> void save(RDD<D> rdd, ClassTag<D> evidence$5) {
        this.save(rdd, (WriteConfig)WriteConfig$.MODULE$.apply(rdd.sparkContext()), evidence$5);
    }

    public <D> void save(RDD<D> rdd, WriteConfig writeConfig, ClassTag<D> evidence$6) {
        MongoConnector mongoConnector = MongoConnector$.MODULE$.apply(writeConfig.asOptions());
        rdd.foreachPartition((Function1)new Serializable(writeConfig, evidence$6, mongoConnector){
            public static final long serialVersionUID = 0L;
            public final WriteConfig writeConfig$2;
            private final ClassTag evidence$6$1;
            private final MongoConnector mongoConnector$1;

            public final void apply(Iterator<D> iter) {
                if (iter.nonEmpty()) {
                    this.mongoConnector$1.withCollectionDo((MongoCollectionConfig)this.writeConfig$2, new Serializable(this, iter){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.save.1 $outer;
                        private final Iterator iter$1;

                        public final void apply(MongoCollection<D> collection) {
                            this.iter$1.grouped(this.$outer.writeConfig$2.maxBatchSize()).foreach((Function1)new Serializable(this, collection){
                                public static final long serialVersionUID = 0L;
                                private final MongoCollection collection$1;

                                public final void apply(Seq<D> batch) {
                                    this.collection$1.insertMany((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)batch.toList()).asJava());
                                }
                                {
                                    this.collection$1 = collection$1;
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.iter$1 = iter$1;
                        }
                    }, this.evidence$6$1);
                }
            }
            {
                this.writeConfig$2 = writeConfig$2;
                this.evidence$6$1 = evidence$6$1;
                this.mongoConnector$1 = mongoConnector$1;
            }
        });
    }

    public <D> void save(Dataset<D> dataset) {
        this.save(dataset, (WriteConfig)WriteConfig$.MODULE$.apply(dataset.sparkSession().sparkContext().getConf()));
    }

    public <D> void save(Dataset<D> dataset, WriteConfig writeConfig) {
        MongoConnector mongoConnector = MongoConnector$.MODULE$.apply(writeConfig.asOptions());
        Dataset dataSet = dataset.toDF();
        Function1<Row, BsonDocument> mapper = MapFunctions$.MODULE$.rowToDocumentMapper(dataSet.schema());
        RDD documentRdd = dataSet.rdd().map((Function1)new Serializable(mapper){
            public static final long serialVersionUID = 0L;
            private final Function1 mapper$1;

            public final BsonDocument apply(Row row) {
                return (BsonDocument)this.mapper$1.apply((Object)row);
            }
            {
                this.mapper$1 = mapper$1;
            }
        }, ClassTag$.MODULE$.apply(BsonDocument.class));
        List fieldNames = Predef$.MODULE$.refArrayOps((Object[])dataset.schema().fieldNames()).toList();
        List queryKeyList = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(BsonDocument.parse((String)((String)writeConfig.shardKey().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "{_id: 1}";
            }
        }))).keySet()).asScala()).toList();
        if (!writeConfig.forceInsert() && queryKeyList.forall((Function1)new Serializable(fieldNames){
            public static final long serialVersionUID = 0L;
            private final List fieldNames$1;

            public final boolean apply(String x$1) {
                return this.fieldNames$1.contains((Object)x$1);
            }
            {
                this.fieldNames$1 = fieldNames$1;
            }
        })) {
            documentRdd.foreachPartition((Function1)new Serializable(writeConfig, mongoConnector, queryKeyList){
                public static final long serialVersionUID = 0L;
                public final WriteConfig writeConfig$1;
                private final MongoConnector mongoConnector$2;
                public final List queryKeyList$1;

                public final void apply(Iterator<BsonDocument> iter) {
                    if (iter.nonEmpty()) {
                        this.mongoConnector$2.withCollectionDo((MongoCollectionConfig)this.writeConfig$1, new Serializable(this, iter){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.save.3 $outer;
                            private final Iterator iter$2;

                            public final void apply(MongoCollection<BsonDocument> collection) {
                                this.iter$2.grouped(this.$outer.writeConfig$1.maxBatchSize()).foreach((Function1)new Serializable(this, collection){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$save$3$$anonfun$apply$3 $outer;
                                    private final MongoCollection collection$2;

                                    public final BulkWriteResult apply(Seq<BsonDocument> batch) {
                                        Seq requests = (Seq)batch.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$save$3$$anonfun$apply$3$$anonfun$apply$4 $outer;

                                            public final WriteModel<BsonDocument> apply(BsonDocument doc) {
                                                InsertOneModel insertOneModel;
                                                if (this.$outer.com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$anonfun$$$outer().com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$$outer().queryKeyList$1.forall((Function1)new Serializable(this, doc){
                                                    public static final long serialVersionUID = 0L;
                                                    private final BsonDocument doc$1;

                                                    public final boolean apply(String x$2) {
                                                        return this.doc$1.containsKey((Object)x$2);
                                                    }
                                                    {
                                                        this.doc$1 = doc$1;
                                                    }
                                                })) {
                                                    BsonDocument queryDocument = new BsonDocument();
                                                    this.$outer.com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$anonfun$$$outer().com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$$outer().queryKeyList$1.foreach((Function1)new Serializable(this, queryDocument, doc){
                                                        public static final long serialVersionUID = 0L;
                                                        private final BsonDocument queryDocument$1;
                                                        private final BsonDocument doc$1;

                                                        public final BsonDocument apply(String key) {
                                                            return this.queryDocument$1.append(key, this.doc$1.get((Object)key));
                                                        }
                                                        {
                                                            this.queryDocument$1 = queryDocument$1;
                                                            this.doc$1 = doc$1;
                                                        }
                                                    });
                                                    if (this.$outer.com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$anonfun$$$outer().com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$$outer().writeConfig$1.replaceDocument()) {
                                                        insertOneModel = new ReplaceOneModel((Bson)queryDocument, (Object)doc, new ReplaceOptions().upsert(true));
                                                    } else {
                                                        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(queryDocument.keySet()).asScala()).foreach((Function1)new Serializable(this, doc){
                                                            public static final long serialVersionUID = 0L;
                                                            private final BsonDocument doc$1;

                                                            public final BsonValue apply(String x$3) {
                                                                return this.doc$1.remove((Object)x$3);
                                                            }
                                                            {
                                                                this.doc$1 = doc$1;
                                                            }
                                                        });
                                                        insertOneModel = new UpdateOneModel((Bson)queryDocument, (Bson)new BsonDocument("$set", (BsonValue)doc), new UpdateOptions().upsert(true));
                                                    }
                                                } else {
                                                    insertOneModel = new InsertOneModel((Object)doc);
                                                }
                                                return insertOneModel;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        }, Seq$.MODULE$.canBuildFrom());
                                        return this.collection$2.bulkWrite((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requests.toList()).asJava());
                                    }

                                    public /* synthetic */ anonfun$save$3$$anonfun$apply$3 com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.collection$2 = collection$2;
                                    }
                                });
                            }

                            public /* synthetic */ anonfun.save.3 com$mongodb$spark$MongoSpark$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.iter$2 = iter$2;
                            }
                        }, ClassTag$.MODULE$.apply(BsonDocument.class));
                    }
                }
                {
                    this.writeConfig$1 = writeConfig$1;
                    this.mongoConnector$2 = mongoConnector$2;
                    this.queryKeyList$1 = queryKeyList$1;
                }
            });
        } else {
            this.save(documentRdd, writeConfig, ClassTag$.MODULE$.apply(BsonDocument.class));
        }
    }

    public void save(DataFrameWriter<?> dataFrameWriter) {
        dataFrameWriter.format(this.defaultSource()).save();
    }

    public void save(DataFrameWriter<?> dataFrameWriter, WriteConfig writeConfig) {
        dataFrameWriter.format(this.defaultSource()).options(writeConfig.asOptions()).save();
    }

    public DataFrameReader read(SparkSession sparkSession) {
        return sparkSession.read().format("com.mongodb.spark.sql");
    }

    public <T> DataFrameWriter<T> write(Dataset<T> dataset) {
        return dataset.write().format("com.mongodb.spark.sql");
    }

    public JavaMongoRDD<Document> load(JavaSparkContext jsc) {
        return this.builder().javaSparkContext(jsc).build().toJavaRDD();
    }

    public JavaMongoRDD<Document> load(JavaSparkContext jsc, ReadConfig readConfig) {
        return this.builder().javaSparkContext(jsc).readConfig(readConfig).build().toJavaRDD();
    }

    public <D> JavaMongoRDD<D> load(JavaSparkContext jsc, ReadConfig readConfig, Class<D> clazz) {
        return this.builder().javaSparkContext(jsc).readConfig(readConfig).build().toJavaRDD(clazz);
    }

    public <D> JavaMongoRDD<D> load(JavaSparkContext jsc, Class<D> clazz) {
        return this.builder().javaSparkContext(jsc).build().toJavaRDD(clazz);
    }

    public Dataset<Row> loadAndInferSchema(SparkSession sparkSession) {
        return this.builder().sparkSession(sparkSession).build().toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
    }

    public Dataset<Row> loadAndInferSchema(SparkSession sparkSession, ReadConfig readConfig) {
        return this.builder().sparkSession(sparkSession).readConfig(readConfig).build().toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
    }

    public <D> Dataset<D> load(SparkSession sparkSession, Class<D> clazz) {
        return this.builder().sparkSession(sparkSession).build().toDS(clazz);
    }

    public <D> Dataset<D> load(SparkSession sparkSession, ReadConfig readConfig, Class<D> clazz) {
        return this.builder().sparkSession(sparkSession).readConfig(readConfig).build().toDS(clazz);
    }

    public void save(JavaRDD<Document> javaRDD) {
        this.save(javaRDD, Document.class);
    }

    public <D> void save(JavaRDD<D> javaRDD, Class<D> clazz) {
        package$.MODULE$.notNull("javaRDD", javaRDD);
        this.save(javaRDD.rdd(), this.ct$1(clazz));
    }

    public void save(JavaRDD<Document> javaRDD, WriteConfig writeConfig) {
        this.save(javaRDD, writeConfig, Document.class);
    }

    public <D> void save(JavaRDD<D> javaRDD, WriteConfig writeConfig, Class<D> clazz) {
        package$.MODULE$.notNull("javaRDD", javaRDD);
        package$.MODULE$.notNull("writeConfig", writeConfig);
        this.save(javaRDD.rdd(), writeConfig, this.ct$2(clazz));
    }

    public <D extends Product> Dataset<Row> load(SQLContext sqlContext, TypeTags.TypeTag<D> evidence$7) {
        return this.load(sqlContext.sparkSession(), evidence$7);
    }

    public <D extends Product> Dataset<Row> load(SQLContext sqlContext, ReadConfig readConfig, TypeTags.TypeTag<D> evidence$8) {
        return this.load(sqlContext.sparkSession(), readConfig, evidence$8);
    }

    public <D> Dataset<Row> load(SQLContext sqlContext, ReadConfig readConfig, Class<D> clazz) {
        return this.builder().sparkSession(sqlContext.sparkSession()).readConfig(readConfig).build().toDF(clazz);
    }

    public DataFrameReader read(SQLContext sqlContext) {
        return this.read(sqlContext.sparkSession());
    }

    public MongoSpark apply(SparkSession sparkSession, MongoConnector connector, ReadConfig readConfig) {
        return new MongoSpark(sparkSession, connector, readConfig);
    }

    public Option<Tuple3<SparkSession, MongoConnector, ReadConfig>> unapply(MongoSpark x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.sparkSession(), (Object)x$0.connector(), (Object)x$0.readConfig()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final ClassTag ct$1(Class clazz$2) {
        return ClassTag$.MODULE$.apply(clazz$2);
    }

    private final ClassTag ct$2(Class clazz$1) {
        return ClassTag$.MODULE$.apply(clazz$1);
    }

    private MongoSpark$() {
        MODULE$ = this;
        this.defaultSource = "com.mongodb.spark.sql.DefaultSource";
    }
}

