/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.rdd.partitioner;

import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import com.mongodb.spark.MongoConnector;
import com.mongodb.spark.annotation.DeveloperApi;
import com.mongodb.spark.config.MongoCollectionConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.rdd.partitioner.MongoPartition;
import org.bson.BsonDocument;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

@DeveloperApi
public final class PartitionerHelper$ {
    public static final PartitionerHelper$ MODULE$;

    static {
        new PartitionerHelper$();
    }

    public BsonDocument createBoundaryQuery(String key, BsonValue lower, BsonValue upper) {
        Predef$.MODULE$.require(Option$.MODULE$.apply((Object)lower).isDefined(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "lower range partition key missing";
            }
        });
        Predef$.MODULE$.require(Option$.MODULE$.apply((Object)upper).isDefined(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "upper range partition key missing";
            }
        });
        BsonDocument queryBoundry = new BsonDocument();
        Object object = lower instanceof BsonMinKey ? BoxedUnit.UNIT : queryBoundry.append("$gte", lower);
        Object object2 = upper instanceof BsonMaxKey ? BoxedUnit.UNIT : queryBoundry.append("$lt", upper);
        return queryBoundry.isEmpty() ? queryBoundry : new BsonDocument(key, (BsonValue)queryBoundry);
    }

    public MongoPartition[] createPartitions(String partitionKey, Seq<BsonValue> splitKeys, Seq<String> locations2, boolean addMinMax) {
        Seq seq;
        Tuple2 minKeyMaxKeys = new Tuple2((Object)new BsonMinKey(), (Object)new BsonMaxKey());
        if (addMinMax) {
            BsonMinKey bsonMinKey = (BsonMinKey)minKeyMaxKeys._1();
            seq = (Seq)((SeqLike)splitKeys.$plus$colon((Object)bsonMinKey, Seq$.MODULE$.canBuildFrom())).$colon$plus(minKeyMaxKeys._2(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = splitKeys;
        }
        Seq minToMaxSplitKeys = seq;
        Seq minToMaxKeysToPartition = minToMaxSplitKeys.length() <= 1 ? minToMaxSplitKeys : (Seq)minToMaxSplitKeys.tail();
        Seq partitionPairs = (Seq)minToMaxSplitKeys.zip((GenIterable)minToMaxKeysToPartition, Seq$.MODULE$.canBuildFrom());
        return partitionPairs.isEmpty() ? (MongoPartition[])((Object[])new MongoPartition[]{new MongoPartition(0, new BsonDocument(), locations2)}) : (MongoPartition[])((TraversableOnce)((TraversableLike)partitionPairs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(partitionKey, locations2){
            public static final long serialVersionUID = 0L;
            private final String partitionKey$1;
            private final Seq locations$1;

            public final MongoPartition apply(Tuple2<Tuple2<BsonValue, BsonValue>, Object> x0$1) {
                Tuple2<Tuple2<BsonValue, BsonValue>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        BsonValue min = (BsonValue)tuple22._1();
                        BsonValue max = (BsonValue)tuple22._2();
                        if (min != null) {
                            BsonValue bsonValue = min;
                            if (max != null) {
                                BsonValue bsonValue2 = max;
                                int n = i;
                                MongoPartition mongoPartition = new MongoPartition(n, PartitionerHelper$.MODULE$.createBoundaryQuery(this.partitionKey$1, bsonValue, bsonValue2), (Seq<String>)this.locations$1);
                                return mongoPartition;
                            }
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.partitionKey$1 = partitionKey$1;
                this.locations$1 = locations$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(MongoPartition.class));
    }

    public Seq<String> createPartitions$default$3() {
        return Nil$.MODULE$;
    }

    public boolean createPartitions$default$4() {
        return true;
    }

    public Seq<String> locations(MongoConnector connector) {
        return (Seq)connector.withMongoClientDo(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Buffer<String> apply(MongoClient mongoClient) {
                return (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mongoClient.getAllAddress()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ServerAddress x$2) {
                        return x$2.getHost();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).distinct();
            }
        });
    }

    public BsonDocument collStats(MongoConnector connector, ReadConfig readConfig) {
        BsonDocument collStatsCommand = new BsonDocument("collStats", (BsonValue)new BsonString(readConfig.collectionName()));
        return (BsonDocument)connector.withDatabaseDo((MongoCollectionConfig)readConfig, new Serializable(readConfig, collStatsCommand){
            public static final long serialVersionUID = 0L;
            private final ReadConfig readConfig$1;
            private final BsonDocument collStatsCommand$1;

            public final BsonDocument apply(MongoDatabase db) {
                return (BsonDocument)db.runCommand((Bson)this.collStatsCommand$1, this.readConfig$1.readPreference(), BsonDocument.class);
            }
            {
                this.readConfig$1 = readConfig$1;
                this.collStatsCommand$1 = collStatsCommand$1;
            }
        });
    }

    public BsonDocument matchQuery(BsonDocument[] pipeline2) {
        Option option;
        block4: {
            BsonDocument bsonDocument;
            block3: {
                BsonDocument defaultQuery;
                block2: {
                    defaultQuery = new BsonDocument();
                    option = Predef$.MODULE$.refArrayOps((Object[])pipeline2).headOption();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    BsonDocument document = (BsonDocument)some.x();
                    bsonDocument = document.getDocument((Object)"$match", defaultQuery);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                bsonDocument = defaultQuery;
            }
            return bsonDocument;
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<BsonValue, BsonValue> getSplitVectorRangeQuery(String partitionKey, BsonDocument[] pipeline2) {
        Option option;
        block4: {
            BsonDocument bsonDocument;
            block3: {
                block2: {
                    Some some;
                    BsonDocument document;
                    option = Predef$.MODULE$.refArrayOps((Object[])pipeline2).headOption();
                    if (!(option instanceof Some) || (document = (BsonDocument)(some = (Some)option).x()) == null) break block2;
                    BsonDocument bsonDocument2 = document;
                    bsonDocument = this.getNestedDocument((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$match", partitionKey}))), bsonDocument2);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                bsonDocument = new BsonDocument();
            }
            BsonDocument filter = bsonDocument;
            return new Tuple2((Object)filter.get((Object)"$gte", (BsonValue)new BsonMinKey()), (Object)filter.get((Object)"$lt", (BsonValue)new BsonMaxKey()));
        }
        throw new MatchError((Object)option);
    }

    public MongoPartition[] setLastBoundaryToLessThanOrEqualTo(String partitionKey, MongoPartition[] partitions2) {
        BoxedUnit boxedUnit;
        if (partitions2.length > 0) {
            MongoPartition lastPartition = (MongoPartition)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitions2).reverse()).head();
            BsonDocument partitionQuery = lastPartition.queryBounds().getDocument((Object)partitionKey);
            boxedUnit = partitionQuery.append("$lte", partitionQuery.remove((Object)"$lt"));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return partitions2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private BsonDocument getNestedDocument(Seq<String> keys, BsonDocument document) {
        BsonDocument bsonDocument;
        while (keys.nonEmpty() && document.containsKey(keys.head())) {
            BsonValue bsonValue = document.get(keys.head());
            if (!bsonValue.isDocument()) {
                bsonDocument = new BsonDocument();
                return bsonDocument;
            }
            BsonDocument subDoc = bsonValue.asDocument();
            if (((SeqLike)keys.tail()).isEmpty()) {
                bsonDocument = subDoc;
                return bsonDocument;
            }
            document = subDoc;
            keys = (Seq)keys.tail();
        }
        bsonDocument = new BsonDocument();
        return bsonDocument;
    }

    private PartitionerHelper$() {
        MODULE$ = this;
    }
}

