/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql;

import java.io.StringWriter;
import java.io.Writer;
import org.bson.BsonBinary;
import org.bson.BsonRegularExpression;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonValueCodec;
import org.bson.codecs.EncoderContext;
import org.bson.internal.Base64;
import org.bson.json.Converter;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;
import org.bson.json.StrictJsonWriter;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class BsonValueToJson$ {
    public static final BsonValueToJson$ MODULE$;
    private final BsonValueCodec codec;

    static {
        new BsonValueToJson$();
    }

    public BsonValueCodec codec() {
        return this.codec;
    }

    public String apply(BsonValue element) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter, JsonWriterSettings.builder().outputMode(JsonMode.EXTENDED).indent(false).dateTimeConverter((Converter)new Converter<Long>(){

            public void convert(Long value, StrictJsonWriter writer) {
                writer.writeStartObject();
                writer.writeNumber("$date", ((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(value))).toString());
                writer.writeEndObject();
            }
        }).int32Converter((Converter)new Converter<Integer>(){

            public void convert(Integer value, StrictJsonWriter writer) {
                writer.writeNumber(value.toString());
            }
        }).regularExpressionConverter((Converter)new Converter<BsonRegularExpression>(){

            public void convert(BsonRegularExpression value, StrictJsonWriter writer) {
                writer.writeStartObject();
                writer.writeString("$regex", value.getPattern());
                writer.writeString("$options", value.getOptions());
                writer.writeEndObject();
            }
        }).binaryConverter((Converter)new Converter<BsonBinary>(){

            public void convert(BsonBinary value, StrictJsonWriter writer) {
                writer.writeStartObject();
                writer.writeString("$binary", Base64.encode((byte[])value.getData()));
                byte arg$macro$1 = value.getType();
                writer.writeString("$type", new StringOps("%02X").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)arg$macro$1)})));
                writer.writeEndObject();
            }
        }).build());
        jsonWriter.writeStartDocument();
        jsonWriter.writeName("k");
        this.codec().encode((BsonWriter)jsonWriter, element, EncoderContext.builder().build());
        return stringWriter.getBuffer().toString().split(":", 2)[1].trim();
    }

    private BsonValueToJson$() {
        MODULE$ = this;
        this.codec = new BsonValueCodec();
    }
}

