/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql;

import com.mongodb.spark.exceptions.MongoTypeConversionException;
import com.mongodb.spark.sql.BsonValueToJson$;
import com.mongodb.spark.sql.MapFunctions$;
import com.mongodb.spark.sql.MapFunctions$$anonfun$com$mongodb$spark$sql$MapFunctions$;
import com.mongodb.spark.sql.MapFunctions$isBsonNumber$;
import com.mongodb.spark.sql.MapFunctions$notNull$;
import com.mongodb.spark.sql.types.BsonCompatibility$Binary$;
import com.mongodb.spark.sql.types.BsonCompatibility$DbPointer$;
import com.mongodb.spark.sql.types.BsonCompatibility$JavaScript$;
import com.mongodb.spark.sql.types.BsonCompatibility$JavaScriptWithScope$;
import com.mongodb.spark.sql.types.BsonCompatibility$MaxKey$;
import com.mongodb.spark.sql.types.BsonCompatibility$MinKey$;
import com.mongodb.spark.sql.types.BsonCompatibility$ObjectId$;
import com.mongodb.spark.sql.types.BsonCompatibility$RegularExpression$;
import com.mongodb.spark.sql.types.BsonCompatibility$Symbol$;
import com.mongodb.spark.sql.types.BsonCompatibility$Timestamp$;
import com.mongodb.spark.sql.types.BsonCompatibility$Undefined$;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonElement;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class MapFunctions$ {
    public static final MapFunctions$ MODULE$;

    static {
        new MapFunctions$();
    }

    public Row documentToRow(BsonDocument bsonDocument, StructType schema2, String[] requiredColumns) {
        boolean bl;
        block4: {
            Tuple2[] tuple2Array;
            block3: {
                Tuple2[] values;
                block2: {
                    values = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).map((Function1)new Serializable(bsonDocument){
                        public static final long serialVersionUID = 0L;
                        private final BsonDocument bsonDocument$1;

                        public final Tuple2<Object, StructField> apply(StructField field) {
                            boolean bl;
                            block4: {
                                Tuple2 tuple2;
                                block3: {
                                    block2: {
                                        bl = this.bsonDocument$1.containsKey((Object)field.name());
                                        if (!bl) break block2;
                                        tuple2 = new Tuple2(MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$convertToDataType(this.bsonDocument$1.get((Object)field.name()), field.dataType()), (Object)field);
                                        break block3;
                                    }
                                    if (bl) break block4;
                                    tuple2 = new Tuple2(null, (Object)field);
                                }
                                return tuple2;
                            }
                            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                        }
                        {
                            this.bsonDocument$1 = bsonDocument$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                    bl = Predef$.MODULE$.refArrayOps((Object[])requiredColumns).nonEmpty();
                    if (!bl) break block2;
                    scala.collection.immutable.Map requiredValueMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])values).collect((PartialFunction)new Serializable(requiredColumns){
                        public static final long serialVersionUID = 0L;
                        private final String[] requiredColumns$1;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Object, StructField>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 != null) {
                                Object rowValue = A1._1();
                                StructField rowField = (StructField)A1._2();
                                if (Predef$.MODULE$.refArrayOps((Object[])this.requiredColumns$1).contains((Object)rowField.name())) {
                                    object = new Tuple2((Object)rowField.name(), (Object)new Tuple2(rowValue, (Object)rowField));
                                    return (B1)object;
                                }
                            }
                            object = function1.apply(x1);
                            return (B1)object;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean isDefinedAt(Tuple2<Object, StructField> x1) {
                            Tuple2<Object, StructField> tuple2 = x1;
                            if (tuple2 == null) return false;
                            StructField rowField = (StructField)tuple2._2();
                            if (!Predef$.MODULE$.refArrayOps((Object[])this.requiredColumns$1).contains((Object)rowField.name())) return false;
                            return true;
                        }
                        {
                            this.requiredColumns$1 = requiredColumns$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
                    tuple2Array = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).collect((PartialFunction)new Serializable(requiredValueMap){
                        public static final long serialVersionUID = 0L;
                        private final scala.collection.immutable.Map requiredValueMap$1;

                        public final <A1 extends String, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            Object object = this.requiredValueMap$1.getOrElse(A1, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Null$ apply() {
                                    return null;
                                }
                            });
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(String x2) {
                            String string = x2;
                            boolean bl = true;
                            return bl;
                        }
                        {
                            this.requiredValueMap$1 = requiredValueMap$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                    break block3;
                }
                if (bl) break block4;
                tuple2Array = values;
            }
            Tuple2[] requiredValues = tuple2Array;
            return new GenericRowWithSchema((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredValues).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Tuple2<Object, StructField> x$1) {
                    return x$1._1();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any())), DataTypes.createStructType((StructField[])((StructField[])Predef$.MODULE$.refArrayOps((Object[])requiredValues).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(Tuple2<Object, StructField> x$2) {
                    return (StructField)x$2._2();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public String[] documentToRow$default$3() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public BsonDocument rowToDocument(Row row) {
        return (BsonDocument)this.rowToDocumentMapper(row.schema()).apply((Object)row);
    }

    public Function1<Row, BsonDocument> rowToDocumentMapper(StructType schema2) {
        Function2[] mappers = (Function2[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function2<Object, BsonDocument, Object> apply(StructField field) {
                Object object;
                DataType dataType = field.dataType();
                NullType$ nullType$ = NullType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(nullType$) : nullType$ != null)) {
                    object = new Serializable(this, field){
                        public static final long serialVersionUID = 0L;
                        private final StructField field$1;

                        public final BsonDocument apply(Object data, BsonDocument document) {
                            return document.append(this.field$1.name(), (BsonValue)new BsonNull());
                        }
                        {
                            this.field$1 = field$1;
                        }
                    };
                } else {
                    Function1<Object, BsonValue> mapper = MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$wrappedDataTypeToBsonValueMapper(field.dataType());
                    object = new Serializable(this, mapper, field){
                        public static final long serialVersionUID = 0L;
                        private final Function1 mapper$1;
                        private final StructField field$1;

                        public final Object apply(Object data, BsonDocument document) {
                            return data == null ? BoxedUnit.UNIT : document.append(this.field$1.name(), (BsonValue)this.mapper$1.apply(data));
                        }
                        {
                            this.mapper$1 = mapper$1;
                            this.field$1 = field$1;
                        }
                    };
                }
                return object;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function2.class)));
        return new Serializable(mappers){
            public static final long serialVersionUID = 0L;
            private final Function2[] mappers$1;

            /*
             * WARNING - void declaration
             */
            public final BsonDocument apply(Row row) {
                void var2_2;
                BsonDocument document = new BsonDocument();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.mappers$1).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, document, row){
                    public static final long serialVersionUID = 0L;
                    private final BsonDocument document$1;
                    private final Row row$1;

                    public final Object apply(Tuple2<Function2<Object, BsonDocument, Object>, Object> x0$1) {
                        Tuple2<Function2<Object, BsonDocument, Object>, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Function2 mapper = (Function2)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            Object value = this.row$1.isNullAt(i) ? null : this.row$1.get(i);
                            Object object = mapper.apply(value, (Object)this.document$1);
                            return object;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.document$1 = document$1;
                        this.row$1 = row$1;
                    }
                });
                return var2_2;
            }
            {
                this.mappers$1 = mappers$1;
            }
        };
    }

    public Function1<Object, BsonValue> com$mongodb$spark$sql$MapFunctions$$wrappedDataTypeToBsonValueMapper(DataType elementType) {
        return new Serializable(elementType){
            public static final long serialVersionUID = 0L;
            public final DataType elementType$1;

            public final BsonValue apply(Object element) {
                boolean bl = false;
                Failure failure = null;
                Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, element){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$com$mongodb$spark$sql$MapFunctions$$wrappedDataTypeToBsonValueMapper$1 $outer;
                    private final Object element$1;

                    public final BsonValue apply() {
                        return (BsonValue)MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$dataTypeToBsonValueMapper(this.$outer.elementType$1).apply(this.element$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.element$1 = element$1;
                    }
                });
                if (try_ instanceof Success) {
                    BsonValue bsonValue;
                    Success success = (Success)try_;
                    BsonValue bsonValue2 = bsonValue = (BsonValue)success.value();
                    return bsonValue2;
                }
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    if (ex instanceof MongoTypeConversionException) {
                        MongoTypeConversionException mongoTypeConversionException = (MongoTypeConversionException)((Object)ex);
                        throw mongoTypeConversionException;
                    }
                }
                if (bl) {
                    throw new MongoTypeConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element, this.elementType$1})));
                }
                throw new MatchError((Object)try_);
            }
            {
                this.elementType$1 = elementType$1;
            }
        };
    }

    public Function1<Object, BsonValue> com$mongodb$spark$sql$MapFunctions$$dataTypeToBsonValueMapper(DataType elementType) {
        Object object;
        DataType dataType = elementType;
        if (BinaryType$.MODULE$.equals(dataType)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BsonBinary apply(Object element) {
                    return new BsonBinary((byte[])element);
                }
            };
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BsonBoolean apply(Object element) {
                    return new BsonBoolean(BoxesRunTime.unboxToBoolean((Object)element));
                }
            };
        } else if (DateType$.MODULE$.equals(dataType)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BsonDateTime apply(Object element) {
                    return new BsonDateTime(((Date)element).getTime());
                }
            };
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BsonDouble apply(Object element) {
                    return new BsonDouble(BoxesRunTime.unboxToDouble((Object)element));
                }
            };
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BsonInt32 apply(Object element) {
                    return new BsonInt32(BoxesRunTime.unboxToInt((Object)element));
                }
            };
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BsonInt64 apply(Object element) {
                    return new BsonInt64(BoxesRunTime.unboxToLong((Object)element));
                }
            };
        } else if (StringType$.MODULE$.equals(dataType)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BsonString apply(Object element) {
                    return new BsonString((String)element);
                }
            };
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BsonDateTime apply(Object element) {
                    return new BsonDateTime(((Timestamp)element).getTime());
                }
            };
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            Function1<Seq<Object>, BsonValue> mapper = this.arrayTypeToBsonValueMapper(arrayType.elementType());
            object = new Serializable(mapper){
                public static final long serialVersionUID = 0L;
                private final Function1 mapper$2;

                public final BsonValue apply(Object element) {
                    return (BsonValue)this.mapper$2.apply((Object)((Seq)element));
                }
                {
                    this.mapper$2 = mapper$2;
                }
            };
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Function1<Row, BsonValue> mapper = this.structTypeToBsonValueMapper(structType);
            object = new Serializable(mapper){
                public static final long serialVersionUID = 0L;
                private final Function1 mapper$3;

                public final BsonValue apply(Object element) {
                    return (BsonValue)this.mapper$3.apply((Object)((Row)element));
                }
                {
                    this.mapper$3 = mapper$3;
                }
            };
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType dataType2 = mapType.keyType();
            Object object2 = StringType$.MODULE$.equals(dataType2) ? new Serializable(mapType){
                public static final long serialVersionUID = 0L;
                private final MapType x12$1;

                public final BsonValue apply(Object element) {
                    return (BsonValue)MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$mapTypeToBsonValueMapper(this.x12$1.valueType()).apply((Object)((scala.collection.immutable.Map)element));
                }
                {
                    this.x12$1 = x12$1;
                }
            } : new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply(Object element) {
                    throw new MongoTypeConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a BsonValue. MapTypes must have keys of StringType for conversion into a BsonDocument"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element})));
                }
            };
            object = object2;
        } else if (elementType.typeName().startsWith("decimal")) {
            Serializable jBigDecimal = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BigDecimal apply(Object element) {
                    BigDecimal bigDecimal;
                    Object object = element;
                    BigDecimal bigDecimal2 = object instanceof BigDecimal ? (bigDecimal = (BigDecimal)object) : ((scala.math.BigDecimal)element).bigDecimal();
                    return bigDecimal2;
                }
            };
            object = new Serializable((Function1)jBigDecimal){
                public static final long serialVersionUID = 0L;
                private final Function1 jBigDecimal$1;

                public final BsonDecimal128 apply(Object element) {
                    return new BsonDecimal128(new Decimal128((BigDecimal)this.jBigDecimal$1.apply(element)));
                }
                {
                    this.jBigDecimal$1 = jBigDecimal$1;
                }
            };
        } else {
            object = new Serializable(elementType){
                public static final long serialVersionUID = 0L;
                private final DataType elementType$2;

                public final Nothing$ apply(Object element) {
                    throw new MongoTypeConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a BsonValue. ", " has no matching BsonValue."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element, this.elementType$2})));
                }
                {
                    this.elementType$2 = elementType$2;
                }
            };
        }
        return object;
    }

    public Function1<scala.collection.immutable.Map<String, Object>, BsonValue> com$mongodb$spark$sql$MapFunctions$$mapTypeToBsonValueMapper(DataType valueType) {
        Object object;
        DataType dataType = valueType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Function1<Row, BsonValue> mapper = this.structTypeToBsonValueMapper(structType);
            object = new Serializable(mapper){
                public static final long serialVersionUID = 0L;
                public final Function1 mapper$4;

                public final Iterable<BsonElement> apply(scala.collection.immutable.Map<String, Object> data) {
                    return (Iterable)data.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.7 $outer;

                        public final BsonElement apply(Tuple2<String, Object> kv) {
                            return new BsonElement((String)kv._1(), (BsonValue)this.$outer.mapper$4.apply((Object)((Row)kv._2())));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Iterable$.MODULE$.canBuildFrom());
                }
                {
                    this.mapper$4 = mapper$4;
                }
            };
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            Function1<Seq<Object>, BsonValue> mapper = this.arrayTypeToBsonValueMapper(arrayType.elementType());
            object = new Serializable(mapper){
                public static final long serialVersionUID = 0L;
                public final Function1 mapper$5;

                public final Iterable<BsonElement> apply(scala.collection.immutable.Map<String, Object> data) {
                    return (Iterable)data.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.8 $outer;

                        public final BsonElement apply(Tuple2<String, Object> kv) {
                            return new BsonElement((String)kv._1(), (BsonValue)this.$outer.mapper$5.apply((Object)((Seq)kv._2())));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Iterable$.MODULE$.canBuildFrom());
                }
                {
                    this.mapper$5 = mapper$5;
                }
            };
        } else {
            Function1<Object, BsonValue> mapper = this.com$mongodb$spark$sql$MapFunctions$$wrappedDataTypeToBsonValueMapper(valueType);
            object = new Serializable(mapper){
                public static final long serialVersionUID = 0L;
                public final Function1 mapper$6;

                public final Iterable<BsonElement> apply(scala.collection.immutable.Map<String, Object> data) {
                    return (Iterable)data.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.9 $outer;

                        public final BsonElement apply(Tuple2<String, Object> kv) {
                            return new BsonElement((String)kv._1(), (BsonValue)this.$outer.mapper$6.apply(kv._2()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Iterable$.MODULE$.canBuildFrom());
                }
                {
                    this.mapper$6 = mapper$6;
                }
            };
        }
        Object internalDataMapper = object;
        return new Serializable((Function1)internalDataMapper){
            public static final long serialVersionUID = 0L;
            private final Function1 internalDataMapper$1;

            public final BsonDocument apply(scala.collection.immutable.Map<String, Object> data) {
                return new BsonDocument((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)this.internalDataMapper$1.apply(data)).toList()).asJava());
            }
            {
                this.internalDataMapper$1 = internalDataMapper$1;
            }
        };
    }

    private Function1<Seq<Object>, BsonValue> arrayTypeToBsonValueMapper(DataType elementType) {
        Object object;
        DataType dataType = elementType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Function1<Row, BsonValue> mapper = this.structTypeToBsonValueMapper(structType);
            object = new Serializable(mapper){
                public static final long serialVersionUID = 0L;
                public final Function1 mapper$7;

                public final List<BsonValue> apply(Seq<Object> data) {
                    return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)data.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.10 $outer;

                        public final BsonValue apply(Object x) {
                            return (BsonValue)this.$outer.mapper$7.apply((Object)((Row)x));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).asJava();
                }
                {
                    this.mapper$7 = mapper$7;
                }
            };
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            Function1<Seq<Object>, BsonValue> mapper = this.arrayTypeToBsonValueMapper(arrayType.elementType());
            object = new Serializable(mapper){
                public static final long serialVersionUID = 0L;
                public final Function1 mapper$8;

                public final List<BsonValue> apply(Seq<Object> data) {
                    return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)data.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.11 $outer;

                        public final BsonValue apply(Object x) {
                            return (BsonValue)this.$outer.mapper$8.apply((Object)((Seq)x));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).asJava();
                }
                {
                    this.mapper$8 = mapper$8;
                }
            };
        } else {
            Function1<Object, BsonValue> mapper = this.com$mongodb$spark$sql$MapFunctions$$wrappedDataTypeToBsonValueMapper(elementType);
            object = new Serializable(mapper){
                public static final long serialVersionUID = 0L;
                public final Function1 mapper$9;

                public final List<BsonValue> apply(Seq<Object> data) {
                    return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)data.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.12 $outer;

                        public final BsonValue apply(Object x) {
                            return (BsonValue)this.$outer.mapper$9.apply(x);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).asJava();
                }
                {
                    this.mapper$9 = mapper$9;
                }
            };
        }
        Object bsonArrayValuesMapper = object;
        return new Serializable((Function1)bsonArrayValuesMapper){
            public static final long serialVersionUID = 0L;
            private final Function1 bsonArrayValuesMapper$1;

            public final BsonArray apply(Seq<Object> data) {
                return new BsonArray((List)this.bsonArrayValuesMapper$1.apply(data));
            }
            {
                this.bsonArrayValuesMapper$1 = bsonArrayValuesMapper$1;
            }
        };
    }

    private Function1<Row, BsonValue> structTypeToBsonValueMapper(StructType dataType) {
        StructType structType = dataType;
        Object object = BsonCompatibility$ObjectId$.MODULE$.unapply(structType) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonObjectId apply(Row row) {
                return (BsonObjectId)BsonCompatibility$ObjectId$.MODULE$.apply(row);
            }
        } : (BsonCompatibility$MinKey$.MODULE$.unapply(structType) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonMinKey apply(Row row) {
                return (BsonMinKey)BsonCompatibility$MinKey$.MODULE$.apply(row);
            }
        } : (BsonCompatibility$MaxKey$.MODULE$.unapply(structType) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonMaxKey apply(Row row) {
                return (BsonMaxKey)BsonCompatibility$MaxKey$.MODULE$.apply(row);
            }
        } : (BsonCompatibility$Timestamp$.MODULE$.unapply(structType) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonTimestamp apply(Row row) {
                return (BsonTimestamp)BsonCompatibility$Timestamp$.MODULE$.apply(row);
            }
        } : (BsonCompatibility$JavaScript$.MODULE$.unapply(structType) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonJavaScript apply(Row row) {
                return (BsonJavaScript)BsonCompatibility$JavaScript$.MODULE$.apply(row);
            }
        } : (BsonCompatibility$JavaScriptWithScope$.MODULE$.unapply(structType) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonJavaScriptWithScope apply(Row row) {
                return (BsonJavaScriptWithScope)BsonCompatibility$JavaScriptWithScope$.MODULE$.apply(row);
            }
        } : (BsonCompatibility$RegularExpression$.MODULE$.unapply(structType) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonRegularExpression apply(Row row) {
                return (BsonRegularExpression)BsonCompatibility$RegularExpression$.MODULE$.apply(row);
            }
        } : (BsonCompatibility$Undefined$.MODULE$.unapply(structType) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonUndefined apply(Row row) {
                return (BsonUndefined)BsonCompatibility$Undefined$.MODULE$.apply(row);
            }
        } : (BsonCompatibility$Binary$.MODULE$.unapply(structType) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonBinary apply(Row row) {
                return (BsonBinary)BsonCompatibility$Binary$.MODULE$.apply(row);
            }
        } : (BsonCompatibility$Symbol$.MODULE$.unapply(structType) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonSymbol apply(Row row) {
                return (BsonSymbol)BsonCompatibility$Symbol$.MODULE$.apply(row);
            }
        } : (BsonCompatibility$DbPointer$.MODULE$.unapply(structType) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonDbPointer apply(Row row) {
                return (BsonDbPointer)BsonCompatibility$DbPointer$.MODULE$.apply(row);
            }
        } : this.rowToDocumentMapper(dataType)))))))))));
        return object;
    }

    public Object com$mongodb$spark$sql$MapFunctions$$convertToDataType(BsonValue element, DataType elementType) {
        block16: {
            Object object;
            block3: {
                block15: {
                    DataType dataType;
                    Tuple2 tuple2;
                    block14: {
                        block13: {
                            BsonType bsonType;
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block6: {
                                                        block5: {
                                                            block4: {
                                                                block2: {
                                                                    tuple2 = new Tuple2((Object)element.getBsonType(), (Object)elementType);
                                                                    if (tuple2 == null) break block2;
                                                                    BsonType bsonType2 = (BsonType)tuple2._1();
                                                                    DataType mapType = (DataType)tuple2._2();
                                                                    if (!BsonType.DOCUMENT.equals(bsonType2) || !(mapType instanceof MapType)) break block2;
                                                                    MapType mapType2 = (MapType)mapType;
                                                                    object = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)element.asDocument()).asScala()).map((Function1)new Serializable(mapType2){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final MapType x31$1;

                                                                        public final Tuple2<String, Object> apply(Tuple2<String, BsonValue> kv) {
                                                                            return new Tuple2(kv._1(), MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$convertToDataType((BsonValue)kv._2(), this.x31$1.valueType()));
                                                                        }
                                                                        {
                                                                            this.x31$1 = x31$1;
                                                                        }
                                                                    }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                                                                    break block3;
                                                                }
                                                                if (tuple2 == null) break block4;
                                                                BsonType bsonType3 = (BsonType)tuple2._1();
                                                                DataType arrayType = (DataType)tuple2._2();
                                                                if (!BsonType.ARRAY.equals(bsonType3) || !(arrayType instanceof ArrayType)) break block4;
                                                                ArrayType arrayType2 = (ArrayType)arrayType;
                                                                object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(element.asArray().getValues()).asScala()).map((Function1)new Serializable(arrayType2){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final ArrayType x33$1;

                                                                    public final Object apply(BsonValue x$3) {
                                                                        return MapFunctions$.MODULE$.com$mongodb$spark$sql$MapFunctions$$convertToDataType(x$3, this.x33$1.elementType());
                                                                    }
                                                                    {
                                                                        this.x33$1 = x33$1;
                                                                    }
                                                                }, Buffer$.MODULE$.canBuildFrom());
                                                                break block3;
                                                            }
                                                            if (tuple2 == null) break block5;
                                                            BsonType bsonType4 = (BsonType)tuple2._1();
                                                            DataType dataType2 = (DataType)tuple2._2();
                                                            if (!BsonType.BINARY.equals(bsonType4) || !BinaryType$.MODULE$.equals(dataType2)) break block5;
                                                            object = element.asBinary().getData();
                                                            break block3;
                                                        }
                                                        if (tuple2 == null) break block6;
                                                        BsonType bsonType5 = (BsonType)tuple2._1();
                                                        DataType dataType3 = (DataType)tuple2._2();
                                                        if (!BsonType.BOOLEAN.equals(bsonType5) || !BooleanType$.MODULE$.equals(dataType3)) break block6;
                                                        object = BoxesRunTime.boxToBoolean((boolean)element.asBoolean().getValue());
                                                        break block3;
                                                    }
                                                    if (tuple2 == null) break block7;
                                                    BsonType bsonType6 = (BsonType)tuple2._1();
                                                    DataType dataType4 = (DataType)tuple2._2();
                                                    if (!BsonType.DATE_TIME.equals(bsonType6) || !DateType$.MODULE$.equals(dataType4)) break block7;
                                                    object = new Date(element.asDateTime().getValue());
                                                    break block3;
                                                }
                                                if (tuple2 == null) break block8;
                                                BsonType bsonType7 = (BsonType)tuple2._1();
                                                DataType dataType5 = (DataType)tuple2._2();
                                                if (!BsonType.DATE_TIME.equals(bsonType7) || !TimestampType$.MODULE$.equals(dataType5)) break block8;
                                                object = new Timestamp(element.asDateTime().getValue());
                                                break block3;
                                            }
                                            if (tuple2 == null) break block9;
                                            BsonType bsonType8 = (BsonType)tuple2._1();
                                            DataType dataType6 = (DataType)tuple2._2();
                                            if (!BsonType.NULL.equals(bsonType8) || !NullType$.MODULE$.equals(dataType6)) break block9;
                                            object = null;
                                            break block3;
                                        }
                                        if (tuple2 == null) break block10;
                                        BsonType bsonType9 = (BsonType)tuple2._1();
                                        DataType dataType7 = (DataType)tuple2._2();
                                        if (!MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType9) || !DoubleType$.MODULE$.equals(dataType7)) break block10;
                                        object = BoxesRunTime.boxToDouble((double)this.toDouble(element));
                                        break block3;
                                    }
                                    if (tuple2 == null) break block11;
                                    BsonType bsonType10 = (BsonType)tuple2._1();
                                    DataType dataType8 = (DataType)tuple2._2();
                                    if (!MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType10) || !IntegerType$.MODULE$.equals(dataType8)) break block11;
                                    object = BoxesRunTime.boxToInteger((int)this.toInt(element));
                                    break block3;
                                }
                                if (tuple2 == null) break block12;
                                BsonType bsonType11 = (BsonType)tuple2._1();
                                DataType dataType9 = (DataType)tuple2._2();
                                if (!MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType11) || !LongType$.MODULE$.equals(dataType9)) break block12;
                                object = BoxesRunTime.boxToLong((long)this.toLong(element));
                                break block3;
                            }
                            if (tuple2 == null || !MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType = (BsonType)tuple2._1()) || !elementType.typeName().startsWith("decimal")) break block13;
                            object = this.toDecimal(element);
                            break block3;
                        }
                        if (tuple2 == null) break block14;
                        BsonType bsonType = (BsonType)tuple2._1();
                        DataType schema2 = (DataType)tuple2._2();
                        if (!MapFunctions$notNull$.MODULE$.unapply(bsonType) || !(schema2 instanceof StructType)) break block14;
                        StructType structType = (StructType)schema2;
                        object = this.castToStructType(element, structType);
                        break block3;
                    }
                    if (tuple2 == null || !StringType$.MODULE$.equals(dataType = (DataType)tuple2._2())) break block15;
                    object = this.bsonValueToString(element);
                    break block3;
                }
                if (!element.isNull()) break block16;
                object = null;
            }
            return object;
        }
        throw new MongoTypeConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a ", " (value: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.getBsonType(), elementType, element})));
    }

    private String bsonValueToString(BsonValue element) {
        BsonType bsonType = element.getBsonType();
        Object object = BsonType.STRING.equals(bsonType) ? element.asString().getValue() : (BsonType.OBJECT_ID.equals(bsonType) ? element.asObjectId().getValue().toHexString() : (BsonType.INT64.equals(bsonType) ? ((Object)BoxesRunTime.boxToLong((long)element.asInt64().getValue())).toString() : (BsonType.INT32.equals(bsonType) ? ((Object)BoxesRunTime.boxToInteger((int)element.asInt32().getValue())).toString() : (BsonType.DOUBLE.equals(bsonType) ? ((Object)BoxesRunTime.boxToDouble((double)element.asDouble().getValue())).toString() : (BsonType.NULL.equals(bsonType) ? null : BsonValueToJson$.MODULE$.apply(element))))));
        return object;
    }

    private Object castToStructType(BsonValue element, StructType elementType) {
        block14: {
            Row row;
            block3: {
                Tuple2 tuple2;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        BsonType bsonType;
                                                        block2: {
                                                            tuple2 = new Tuple2((Object)element.getBsonType(), (Object)elementType);
                                                            if (tuple2 == null) break block2;
                                                            BsonType bsonType2 = (BsonType)tuple2._1();
                                                            StructType structType = (StructType)tuple2._2();
                                                            if (!BsonType.BINARY.equals(bsonType2) || !BsonCompatibility$Binary$.MODULE$.unapply(structType)) break block2;
                                                            row = BsonCompatibility$Binary$.MODULE$.apply((BsonValue)((BsonBinary)element), elementType);
                                                            break block3;
                                                        }
                                                        if (tuple2 == null || !BsonType.DOCUMENT.equals(bsonType = (BsonType)tuple2._1())) break block4;
                                                        row = this.documentToRow((BsonDocument)element, elementType, this.documentToRow$default$3());
                                                        break block3;
                                                    }
                                                    if (tuple2 == null) break block5;
                                                    BsonType bsonType = (BsonType)tuple2._1();
                                                    StructType structType = (StructType)tuple2._2();
                                                    if (!BsonType.DB_POINTER.equals(bsonType) || !BsonCompatibility$DbPointer$.MODULE$.unapply(structType)) break block5;
                                                    row = BsonCompatibility$DbPointer$.MODULE$.apply((BsonValue)((BsonDbPointer)element), elementType);
                                                    break block3;
                                                }
                                                if (tuple2 == null) break block6;
                                                BsonType bsonType = (BsonType)tuple2._1();
                                                StructType structType = (StructType)tuple2._2();
                                                if (!BsonType.JAVASCRIPT.equals(bsonType) || !BsonCompatibility$JavaScript$.MODULE$.unapply(structType)) break block6;
                                                row = BsonCompatibility$JavaScript$.MODULE$.apply((BsonValue)((BsonJavaScript)element), elementType);
                                                break block3;
                                            }
                                            if (tuple2 == null) break block7;
                                            BsonType bsonType = (BsonType)tuple2._1();
                                            StructType structType = (StructType)tuple2._2();
                                            if (!BsonType.JAVASCRIPT_WITH_SCOPE.equals(bsonType) || !BsonCompatibility$JavaScriptWithScope$.MODULE$.unapply(structType)) break block7;
                                            row = BsonCompatibility$JavaScriptWithScope$.MODULE$.apply((BsonValue)((BsonJavaScriptWithScope)element), elementType);
                                            break block3;
                                        }
                                        if (tuple2 == null) break block8;
                                        BsonType bsonType = (BsonType)tuple2._1();
                                        StructType structType = (StructType)tuple2._2();
                                        if (!BsonType.MIN_KEY.equals(bsonType) || !BsonCompatibility$MinKey$.MODULE$.unapply(structType)) break block8;
                                        row = BsonCompatibility$MinKey$.MODULE$.apply((BsonValue)((BsonMinKey)element), elementType);
                                        break block3;
                                    }
                                    if (tuple2 == null) break block9;
                                    BsonType bsonType = (BsonType)tuple2._1();
                                    StructType structType = (StructType)tuple2._2();
                                    if (!BsonType.MAX_KEY.equals(bsonType) || !BsonCompatibility$MaxKey$.MODULE$.unapply(structType)) break block9;
                                    row = BsonCompatibility$MaxKey$.MODULE$.apply((BsonValue)((BsonMaxKey)element), elementType);
                                    break block3;
                                }
                                if (tuple2 == null) break block10;
                                BsonType bsonType = (BsonType)tuple2._1();
                                StructType structType = (StructType)tuple2._2();
                                if (!BsonType.OBJECT_ID.equals(bsonType) || !BsonCompatibility$ObjectId$.MODULE$.unapply(structType)) break block10;
                                row = BsonCompatibility$ObjectId$.MODULE$.apply((BsonValue)((BsonObjectId)element), elementType);
                                break block3;
                            }
                            if (tuple2 == null) break block11;
                            BsonType bsonType = (BsonType)tuple2._1();
                            StructType structType = (StructType)tuple2._2();
                            if (!BsonType.REGULAR_EXPRESSION.equals(bsonType) || !BsonCompatibility$RegularExpression$.MODULE$.unapply(structType)) break block11;
                            row = BsonCompatibility$RegularExpression$.MODULE$.apply((BsonValue)((BsonRegularExpression)element), elementType);
                            break block3;
                        }
                        if (tuple2 == null) break block12;
                        BsonType bsonType = (BsonType)tuple2._1();
                        StructType structType = (StructType)tuple2._2();
                        if (!BsonType.SYMBOL.equals(bsonType) || !BsonCompatibility$Symbol$.MODULE$.unapply(structType)) break block12;
                        row = BsonCompatibility$Symbol$.MODULE$.apply((BsonValue)((BsonSymbol)element), elementType);
                        break block3;
                    }
                    if (tuple2 == null) break block13;
                    BsonType bsonType = (BsonType)tuple2._1();
                    StructType structType = (StructType)tuple2._2();
                    if (!BsonType.TIMESTAMP.equals(bsonType) || !BsonCompatibility$Timestamp$.MODULE$.unapply(structType)) break block13;
                    row = BsonCompatibility$Timestamp$.MODULE$.apply((BsonValue)((BsonTimestamp)element), elementType);
                    break block3;
                }
                if (tuple2 == null) break block14;
                BsonType bsonType = (BsonType)tuple2._1();
                StructType structType = (StructType)tuple2._2();
                if (!BsonType.UNDEFINED.equals(bsonType) || !BsonCompatibility$Undefined$.MODULE$.unapply(structType)) break block14;
                row = BsonCompatibility$Undefined$.MODULE$.apply((BsonValue)((BsonUndefined)element), elementType);
            }
            return row;
        }
        throw new MongoTypeConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a ", " (value: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.getBsonType(), elementType, element})));
    }

    private int toInt(BsonValue bsonValue) {
        block6: {
            int n;
            block3: {
                BsonType bsonType;
                block5: {
                    block4: {
                        block2: {
                            bsonType = bsonValue.getBsonType();
                            if (!BsonType.DECIMAL128.equals(bsonType)) break block2;
                            n = bsonValue.asDecimal128().decimal128Value().bigDecimalValue().intValue();
                            break block3;
                        }
                        if (!BsonType.INT32.equals(bsonType)) break block4;
                        n = bsonValue.asInt32().intValue();
                        break block3;
                    }
                    if (!BsonType.INT64.equals(bsonType)) break block5;
                    n = bsonValue.asInt64().intValue();
                    break block3;
                }
                if (!BsonType.DOUBLE.equals(bsonType)) break block6;
                n = bsonValue.asDouble().intValue();
            }
            return n;
        }
        throw new MongoTypeConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a Int"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bsonValue.getBsonType()})));
    }

    private long toLong(BsonValue bsonValue) {
        block6: {
            long l;
            block3: {
                BsonType bsonType;
                block5: {
                    block4: {
                        block2: {
                            bsonType = bsonValue.getBsonType();
                            if (!BsonType.DECIMAL128.equals(bsonType)) break block2;
                            l = bsonValue.asDecimal128().decimal128Value().bigDecimalValue().longValue();
                            break block3;
                        }
                        if (!BsonType.INT32.equals(bsonType)) break block4;
                        l = bsonValue.asInt32().longValue();
                        break block3;
                    }
                    if (!BsonType.INT64.equals(bsonType)) break block5;
                    l = bsonValue.asInt64().longValue();
                    break block3;
                }
                if (!BsonType.DOUBLE.equals(bsonType)) break block6;
                l = bsonValue.asDouble().longValue();
            }
            return l;
        }
        throw new MongoTypeConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a Long"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bsonValue.getBsonType()})));
    }

    private double toDouble(BsonValue bsonValue) {
        block6: {
            double d;
            block3: {
                BsonType bsonType;
                block5: {
                    block4: {
                        block2: {
                            bsonType = bsonValue.getBsonType();
                            if (!BsonType.DECIMAL128.equals(bsonType)) break block2;
                            d = bsonValue.asDecimal128().decimal128Value().bigDecimalValue().doubleValue();
                            break block3;
                        }
                        if (!BsonType.INT32.equals(bsonType)) break block4;
                        d = bsonValue.asInt32().doubleValue();
                        break block3;
                    }
                    if (!BsonType.INT64.equals(bsonType)) break block5;
                    d = bsonValue.asInt64().doubleValue();
                    break block3;
                }
                if (!BsonType.DOUBLE.equals(bsonType)) break block6;
                d = bsonValue.asDouble().doubleValue();
            }
            return d;
        }
        throw new MongoTypeConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a Double"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bsonValue.getBsonType()})));
    }

    private scala.math.BigDecimal toDecimal(BsonValue bsonValue) {
        block6: {
            scala.math.BigDecimal bigDecimal;
            block3: {
                BsonType bsonType;
                block5: {
                    block4: {
                        block2: {
                            bsonType = bsonValue.getBsonType();
                            if (!BsonType.DECIMAL128.equals(bsonType)) break block2;
                            bigDecimal = BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bsonValue.asDecimal128().decimal128Value().bigDecimalValue());
                            break block3;
                        }
                        if (!BsonType.INT32.equals(bsonType)) break block4;
                        bigDecimal = package$.MODULE$.BigDecimal().apply(bsonValue.asInt32().intValue());
                        break block3;
                    }
                    if (!BsonType.INT64.equals(bsonType)) break block5;
                    bigDecimal = package$.MODULE$.BigDecimal().apply(bsonValue.asInt64().longValue());
                    break block3;
                }
                if (!BsonType.DOUBLE.equals(bsonType)) break block6;
                bigDecimal = package$.MODULE$.BigDecimal().apply(bsonValue.asDouble().doubleValue());
            }
            return bigDecimal;
        }
        throw new MongoTypeConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast ", " into a BigDecimal"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bsonValue.getBsonType()})));
    }

    private MapFunctions$() {
        MODULE$ = this;
    }
}

