/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql;

import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.spark.DefaultHelper$DefaultsTo$;
import com.mongodb.spark.Logging;
import com.mongodb.spark.MongoConnector;
import com.mongodb.spark.MongoSpark$;
import com.mongodb.spark.config.AggregationConfig;
import com.mongodb.spark.config.ReadConcernConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.config.ReadPreferenceConfig;
import com.mongodb.spark.rdd.MongoRDD;
import com.mongodb.spark.rdd.partitioner.MongoSinglePartitioner$;
import com.mongodb.spark.sql.MongoInferSchema$;
import com.mongodb.spark.sql.MongoInferSchemaJava;
import com.mongodb.spark.sql.types.BsonCompatibility$Binary$;
import com.mongodb.spark.sql.types.BsonCompatibility$DbPointer$;
import com.mongodb.spark.sql.types.BsonCompatibility$JavaScript$;
import com.mongodb.spark.sql.types.BsonCompatibility$JavaScriptWithScope$;
import com.mongodb.spark.sql.types.BsonCompatibility$MaxKey$;
import com.mongodb.spark.sql.types.BsonCompatibility$MinKey$;
import com.mongodb.spark.sql.types.BsonCompatibility$ObjectId$;
import com.mongodb.spark.sql.types.BsonCompatibility$RegularExpression$;
import com.mongodb.spark.sql.types.BsonCompatibility$Symbol$;
import com.mongodb.spark.sql.types.BsonCompatibility$Timestamp$;
import com.mongodb.spark.sql.types.BsonCompatibility$Undefined$;
import com.mongodb.spark.sql.types.ConflictType;
import com.mongodb.spark.sql.types.ConflictType$;
import com.mongodb.spark.sql.types.SkipFieldType;
import com.mongodb.spark.sql.types.SkipFieldType$;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.IndexedSeqView$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.runtime.package$;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class MongoInferSchema$
extends Logging {
    public static final MongoInferSchema$ MODULE$;
    private final Seq<NumericType> compatibleDecimalTypes;
    private final DecimalType ByteDecimal;
    private final DecimalType ShortDecimal;
    private final DecimalType IntDecimal;
    private final DecimalType LongDecimal;
    private final DecimalType FloatDecimal;
    private final DecimalType DoubleDecimal;
    private final DecimalType BigIntDecimal;
    private final StructField[] emptyStructFieldArray;
    private final Object structFieldComparator;

    static {
        new MongoInferSchema$();
    }

    public StructType apply(SparkContext sc) {
        return this.apply(MongoSpark$.MODULE$.load(sc, ClassTag$.MODULE$.apply(BsonDocument.class), DefaultHelper$DefaultsTo$.MODULE$.overrideDefault()));
    }

    public StructType apply(MongoRDD<BsonDocument> mongoRDD) {
        Try try_;
        block6: {
            StructType structType;
            Some some;
            DataType st;
            MongoRDD<BsonDocument> mongoRDD2;
            block5: {
                long x$39;
                int x$38;
                boolean x$37;
                int sampleSize;
                int samplePoolSize;
                MongoRDD<BsonDocument> singlePartitionRDD;
                block4: {
                    MongoSinglePartitioner$ x$19 = MongoSinglePartitioner$.MODULE$;
                    String x$20 = mongoRDD.readConfig().copy$default$1();
                    String x$21 = mongoRDD.readConfig().copy$default$2();
                    Option<String> x$22 = mongoRDD.readConfig().copy$default$3();
                    int x$23 = mongoRDD.readConfig().copy$default$4();
                    Map<String, String> x$24 = mongoRDD.readConfig().copy$default$6();
                    int x$25 = mongoRDD.readConfig().copy$default$7();
                    ReadPreferenceConfig x$26 = mongoRDD.readConfig().copy$default$8();
                    ReadConcernConfig x$27 = mongoRDD.readConfig().copy$default$9();
                    AggregationConfig x$28 = mongoRDD.readConfig().copy$default$10();
                    boolean x$29 = mongoRDD.readConfig().copy$default$11();
                    boolean x$30 = mongoRDD.readConfig().copy$default$12();
                    int x$31 = mongoRDD.readConfig().copy$default$13();
                    boolean x$32 = mongoRDD.readConfig().copy$default$14();
                    boolean x$33 = mongoRDD.readConfig().copy$default$15();
                    int x$34 = mongoRDD.readConfig().copy$default$16();
                    ReadConfig x$35 = mongoRDD.readConfig().copy(x$20, x$21, x$22, x$23, x$19, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34);
                    Broadcast<MongoConnector> x$36 = mongoRDD.copy$default$1();
                    singlePartitionRDD = mongoRDD.copy(x$36, x$35);
                    samplePoolSize = singlePartitionRDD.readConfig().samplePoolSize();
                    sampleSize = singlePartitionRDD.readConfig().sampleSize();
                    if (!singlePartitionRDD.hasSampleAggregateOperator()) break block4;
                    Seq appendedPipeline = singlePartitionRDD.readConfig().pipeline().isEmpty() || samplePoolSize < 0 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Aggregates.sample((int)sampleSize)})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Aggregates.limit((int)samplePoolSize), Aggregates.sample((int)sampleSize)}));
                    mongoRDD2 = singlePartitionRDD.appendPipeline(appendedPipeline);
                    break block5;
                }
                MongoRDD<BsonDocument> qual$1 = singlePartitionRDD.appendPipeline((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Aggregates.project((Bson)Projections.include((String[])new String[]{"_id"})), Aggregates.sort((Bson)Sorts.descending((String[])new String[]{"_id"})), Aggregates.limit((int)samplePoolSize)})));
                Seq sampleData = Predef$.MODULE$.refArrayOps((Object[])qual$1.takeSample(x$37 = false, x$38 = sampleSize, x$39 = qual$1.takeSample$default$3())).toSeq();
                try_ = Try$.MODULE$.apply((Function0)new Serializable(sampleData){
                    public static final long serialVersionUID = 0L;
                    private final Seq sampleData$1;

                    public final List<BsonValue> apply() {
                        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.sampleData$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final BsonValue apply(BsonDocument x$1) {
                                return x$1.get((Object)"_id");
                            }
                        }, Seq$.MODULE$.canBuildFrom())).asJava();
                    }
                    {
                        this.sampleData$1 = sampleData$1;
                    }
                });
                if (!(try_ instanceof Success)) break block6;
                Success success = (Success)try_;
                List _ids = (List)success.value();
                MongoRDD<BsonDocument> mongoRDD3 = singlePartitionRDD.appendPipeline((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Aggregates.match((Bson)Filters.in((String)"_id", (java.lang.Iterable)_ids))})));
                mongoRDD2 = mongoRDD3;
            }
            MongoRDD<BsonDocument> sampleData = mongoRDD2;
            RDD qual$2 = sampleData.map((Function1)new Serializable(mongoRDD){
                public static final long serialVersionUID = 0L;
                private final MongoRDD mongoRDD$1;

                public final StructType apply(BsonDocument x$2) {
                    return MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$getSchemaFromDocument(x$2, this.mongoRDD$1.readConfig());
                }
                {
                    this.mongoRDD$1 = mongoRDD$1;
                }
            }, ClassTag$.MODULE$.apply(StructType.class));
            StructType x$40 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
            Serializable x$41 = new Serializable(mongoRDD){
                public static final long serialVersionUID = 0L;
                private final MongoRDD mongoRDD$1;

                public final DataType apply(DataType x$3, StructType x$4) {
                    return MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType(x$3, (DataType)x$4, this.mongoRDD$1.readConfig(), false);
                }
                {
                    this.mongoRDD$1 = mongoRDD$1;
                }
            };
            Serializable x$42 = new Serializable(mongoRDD){
                public static final long serialVersionUID = 0L;
                private final MongoRDD mongoRDD$1;

                public final DataType apply(DataType x$5, DataType x$6) {
                    return MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType(x$5, x$6, this.mongoRDD$1.readConfig(), false);
                }
                {
                    this.mongoRDD$1 = mongoRDD$1;
                }
            };
            int x$43 = qual$2.treeAggregate$default$4((Object)x$40);
            DataType rootType = (DataType)qual$2.treeAggregate((Object)x$40, (Function2)x$41, (Function2)x$42, x$43, ClassTag$.MODULE$.apply(DataType.class));
            Option option = (Option)this.com$mongodb$spark$sql$MongoInferSchema$$canonicalizeType().apply((Object)rootType);
            StructType structType2 = option instanceof Some && (st = (DataType)(some = (Some)option).x()) instanceof StructType ? (structType = (StructType)st) : StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
            return structType2;
        }
        if (try_ instanceof Failure) {
            throw new IllegalArgumentException("The RDD must contain documents that include an '_id' key to infer data when using MongoDB < 3.2");
        }
        throw new MatchError((Object)try_);
    }

    public Function1<DataType, Option<DataType>> com$mongodb$spark$sql$MongoInferSchema$$canonicalizeType() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<DataType> apply(DataType x0$1) {
                Object object;
                DataType dataType = x0$1;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    object = ((Option)MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$canonicalizeType().apply((Object)elementType)).map((Function1)new Serializable(this, arrayType){
                        public static final long serialVersionUID = 0L;
                        private final ArrayType x2$1;

                        public final ArrayType apply(DataType dt) {
                            return this.x2$1.copy(dt, this.x2$1.copy$default$2());
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    });
                } else {
                    StructType structType;
                    StructField[] fields;
                    StructField[] canonicalFields;
                    object = dataType instanceof StructType ? (Predef$.MODULE$.refArrayOps((Object[])(canonicalFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])(fields = (structType = (StructType)dataType).fields())).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final Iterable<StructField> apply(StructField field) {
                            Iterable iterable;
                            block5: {
                                block4: {
                                    if (field.name().isEmpty()) break block4;
                                    DataType dataType = field.dataType();
                                    SkipFieldType$ skipFieldType$ = SkipFieldType$.MODULE$;
                                    if (dataType != null ? !dataType.equals((Object)((Object)skipFieldType$)) : skipFieldType$ != null) break block5;
                                }
                                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                return iterable;
                            }
                            if (MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$fieldContainsConflictType(field.dataType())) {
                                String start = field.dataType() instanceof ArrayType ? "Array Field" : "Field";
                                MongoInferSchema$.MODULE$.logWarning((Function0<String>)new Serializable(this, start, field){
                                    public static final long serialVersionUID = 0L;
                                    private final String start$1;
                                    private final StructField field$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " '", "' contains conflicting types converting to StringType"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.start$1, this.field$1.name()}));
                                    }
                                    {
                                        this.start$1 = start$1;
                                        this.field$1 = field$1;
                                    }
                                });
                            }
                            iterable = Option$.MODULE$.option2Iterable(((Option)MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$canonicalizeType().apply((Object)field.dataType())).map((Function1)new Serializable(this, field){
                                public static final long serialVersionUID = 0L;
                                private final StructField field$1;

                                public final StructField apply(DataType dt) {
                                    DataType x$44 = dt;
                                    String x$45 = this.field$1.copy$default$1();
                                    boolean x$46 = this.field$1.copy$default$3();
                                    Metadata x$47 = this.field$1.copy$default$4();
                                    return this.field$1.copy(x$45, x$44, x$46, x$47);
                                }
                                {
                                    this.field$1 = field$1;
                                }
                            }));
                            return iterable;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).nonEmpty() ? new Some((Object)new StructType(canonicalFields)) : None$.MODULE$) : (dataType instanceof ConflictType ? new Some((Object)StringType$.MODULE$) : new Some((Object)dataType));
                }
                return object;
            }
        };
    }

    public StructType com$mongodb$spark$sql$MongoInferSchema$$getSchemaFromDocument(BsonDocument document, ReadConfig readConfig) {
        ArrayList fields = new ArrayList();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(document.entrySet()).asScala()).foreach((Function1)new Serializable(readConfig, fields){
            public static final long serialVersionUID = 0L;
            private final ReadConfig readConfig$1;
            private final ArrayList fields$1;

            public final boolean apply(Map.Entry<String, BsonValue> kv) {
                return this.fields$1.add(DataTypes.createStructField((String)kv.getKey(), (DataType)MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$getDataType(kv.getValue(), this.readConfig$1), (boolean)true));
            }
            {
                this.readConfig$1 = readConfig$1;
                this.fields$1 = fields$1;
            }
        });
        return DataTypes.createStructType(fields);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataType com$mongodb$spark$sql$MongoInferSchema$$compatibleType(DataType t1, DataType t2, ReadConfig readConfig, boolean nested) {
        DataType dataType = (DataType)((Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)t1, (Object)t2)).getOrElse((Function0)new Serializable(t1, t2, readConfig){
            public static final long serialVersionUID = 0L;
            private final DataType t1$1;
            private final DataType t2$1;
            private final ReadConfig readConfig$2;

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final DataType apply() {
                block19: {
                    block8: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                block12: {
                                                    block11: {
                                                        block10: {
                                                            block9: {
                                                                block7: {
                                                                    block6: {
                                                                        block5: {
                                                                            var1_1 = new Tuple2((Object)this.t1$1, (Object)this.t2$1);
                                                                            if (var1_1 == null || !DoubleType$.MODULE$.equals(var2_2 = (DataType)var1_1._1()) || !(var1_1._2() instanceof DecimalType)) break block5;
                                                                            var3_3 = true;
                                                                            break block6;
                                                                        }
                                                                        if (var1_1 == null) ** GOTO lbl-1000
                                                                        var4_4 = (DataType)var1_1._2();
                                                                        if (var1_1._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var4_4)) {
                                                                            var3_3 = true;
                                                                        } else lbl-1000:
                                                                        // 2 sources

                                                                        {
                                                                            var3_3 = false;
                                                                        }
                                                                    }
                                                                    if (!var3_3) break block7;
                                                                    var5_5 /* !! */  = DoubleType$.MODULE$;
                                                                    break block8;
                                                                }
                                                                if (var1_1 == null) break block9;
                                                                t1 = (DataType)var1_1._1();
                                                                t2 = (DataType)var1_1._2();
                                                                if (!(t1 instanceof DecimalType)) break block9;
                                                                var8_8 = (DecimalType)t1;
                                                                if (!(t2 instanceof DecimalType)) break block9;
                                                                var9_9 = (DecimalType)t2;
                                                                scale = scala.math.package$.MODULE$.max(var8_8.scale(), var9_9.scale());
                                                                range = scala.math.package$.MODULE$.max(var8_8.precision() - var8_8.scale(), var9_9.precision() - var9_9.scale());
                                                                var5_5 /* !! */  = range + scale > 38 ? DoubleType$.MODULE$ : new DecimalType(range + scale, scale);
                                                                break block8;
                                                            }
                                                            if (var1_1 == null) break block10;
                                                            var12_12 = (DataType)var1_1._1();
                                                            var13_13 = (DataType)var1_1._2();
                                                            if (!(var12_12 instanceof StructType)) break block10;
                                                            var14_14 = (StructType)var12_12;
                                                            fields1 = var14_14.fields();
                                                            if (!(var13_13 instanceof StructType)) break block10;
                                                            var16_16 = (StructType)var13_13;
                                                            fields2 = var16_16.fields();
                                                            var5_5 /* !! */  = MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleStructType(fields1, fields2, this.readConfig$2);
                                                            break block8;
                                                        }
                                                        if (var1_1 == null) break block11;
                                                        var18_18 = (DataType)var1_1._1();
                                                        var19_19 = (DataType)var1_1._2();
                                                        if (!(var18_18 instanceof MapType)) break block11;
                                                        var20_20 = (MapType)var18_18;
                                                        keyType1 = var20_20.keyType();
                                                        valueType1 = var20_20.valueType();
                                                        valueContainsNull1 = var20_20.valueContainsNull();
                                                        if (!(var19_19 instanceof MapType)) break block11;
                                                        var24_24 = (MapType)var19_19;
                                                        keyType2 = var24_24.keyType();
                                                        valueType2 = var24_24.valueType();
                                                        valueContainsNull2 = var24_24.valueContainsNull();
                                                        var5_5 /* !! */  = new MapType(MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType(keyType1, keyType2, this.readConfig$2, MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType$default$4()), MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType(valueType1, valueType2, this.readConfig$2, MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType$default$4()), valueContainsNull1 != false || valueContainsNull2 != false);
                                                        break block8;
                                                    }
                                                    if (var1_1 == null) break block12;
                                                    var28_28 = (DataType)var1_1._1();
                                                    mapType = (DataType)var1_1._2();
                                                    if (!(var28_28 instanceof StructType)) break block12;
                                                    var30_30 = (StructType)var28_28;
                                                    fields = var30_30.fields();
                                                    if (!(mapType instanceof MapType)) break block12;
                                                    var32_32 = (MapType)mapType;
                                                    var5_5 /* !! */  = MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$appendStructToMap(fields, var32_32, this.readConfig$2);
                                                    break block8;
                                                }
                                                if (var1_1 == null) break block13;
                                                mapType = (DataType)var1_1._1();
                                                var34_34 = (DataType)var1_1._2();
                                                if (!(mapType instanceof MapType)) break block13;
                                                var35_35 = (MapType)mapType;
                                                if (!(var34_34 instanceof StructType)) break block13;
                                                var36_36 = (StructType)var34_34;
                                                fields = var36_36.fields();
                                                var5_5 /* !! */  = MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$appendStructToMap(fields, var35_35, this.readConfig$2);
                                                break block8;
                                            }
                                            if (var1_1 == null) break block14;
                                            var38_38 = (DataType)var1_1._1();
                                            var39_39 = (DataType)var1_1._2();
                                            if (!(var38_38 instanceof ArrayType)) break block14;
                                            var40_40 = (ArrayType)var38_38;
                                            elementType1 = var40_40.elementType();
                                            containsNull1 = var40_40.containsNull();
                                            if (!(var39_39 instanceof ArrayType)) break block14;
                                            var43_43 = (ArrayType)var39_39;
                                            elementType2 = var43_43.elementType();
                                            containsNull2 = var43_43.containsNull();
                                            var5_5 /* !! */  = new ArrayType(MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType(elementType1, elementType2, this.readConfig$2, MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType$default$4()), containsNull1 != false || containsNull2 != false);
                                            break block8;
                                        }
                                        if (var1_1 == null) break block15;
                                        t1 = (DataType)var1_1._1();
                                        t2 = (DataType)var1_1._2();
                                        if (t1 == null) break block15;
                                        var48_48 = t1;
                                        if (!(t2 instanceof DecimalType)) break block15;
                                        var49_49 = (DecimalType)t2;
                                        if (!MongoInferSchema$.MODULE$.compatibleDecimalTypes().contains((Object)var48_48)) break block15;
                                        var5_5 /* !! */  = MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType((DataType)MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$forType(var48_48), (DataType)var49_49, this.readConfig$2, MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType$default$4());
                                        break block8;
                                    }
                                    if (var1_1 == null) break block16;
                                    t1 = (DataType)var1_1._1();
                                    t2 = (DataType)var1_1._2();
                                    if (!(t1 instanceof DecimalType)) break block16;
                                    var52_52 = (DecimalType)t1;
                                    if (t2 == null) break block16;
                                    var53_53 = t2;
                                    if (!MongoInferSchema$.MODULE$.compatibleDecimalTypes().contains((Object)var53_53)) break block16;
                                    var5_5 /* !! */  = MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType((DataType)var52_52, (DataType)MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$forType(var53_53), this.readConfig$2, MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType$default$4());
                                    break block8;
                                }
                                if (var1_1 == null) break block17;
                                s = (DataType)var1_1._1();
                                dataType = (DataType)var1_1._2();
                                if (!(s instanceof SkipFieldType) || dataType == null) break block17;
                                var56_56 = dataType;
                                var5_5 /* !! */  = var56_56;
                                break block8;
                            }
                            if (var1_1 == null) break block18;
                            dataType = (DataType)var1_1._1();
                            s = (DataType)var1_1._2();
                            if (dataType == null) break block18;
                            var59_59 = dataType;
                            if (!(s instanceof SkipFieldType)) break block18;
                            var5_5 /* !! */  = var59_59;
                            break block8;
                        }
                        if (var1_1 == null) break block19;
                        var5_5 /* !! */  = ConflictType$.MODULE$;
                    }
                    return var5_5 /* !! */ ;
                }
                throw new MatchError((Object)var1_1);
            }
            {
                this.t1$1 = t1$1;
                this.t2$1 = t2$1;
                this.readConfig$2 = readConfig$2;
            }
        });
        DataType dataType2 = dataType;
        if (!(dataType2 instanceof StructType)) return dataType;
        StructType structType = (StructType)dataType2;
        if (!nested) return dataType;
        return this.structTypeToMapType(structType, readConfig);
    }

    public boolean com$mongodb$spark$sql$MongoInferSchema$$compatibleType$default$4() {
        return true;
    }

    public DataType com$mongodb$spark$sql$MongoInferSchema$$compatibleStructType(StructField[] fields1, StructField[] fields2, ReadConfig readConfig) {
        scala.collection.immutable.Iterable newFields = (scala.collection.immutable.Iterable)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fields1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])fields2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField field) {
                return field.name();
            }
        }).map((Function1)new Serializable(readConfig){
            public static final long serialVersionUID = 0L;
            public final ReadConfig readConfig$3;

            public final StructField apply(Tuple2<String, StructField[]> x0$2) {
                Tuple2<String, StructField[]> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    StructField[] fieldTypes = (StructField[])tuple2._2();
                    DataType dataType = (DataType)((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])fieldTypes).view().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DataType apply(StructField x$7) {
                            return x$7.dataType();
                        }
                    }, IndexedSeqView$.MODULE$.arrCanBuildFrom())).reduce((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.8 $outer;

                        public final DataType apply(DataType x$8, DataType x$9) {
                            return MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType(x$8, x$9, this.$outer.readConfig$3, MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType$default$4());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    StructField structField = new StructField(name, dataType, true, StructField$.MODULE$.apply$default$4());
                    return structField;
                }
                throw new MatchError(tuple2);
            }
            {
                this.readConfig$3 = readConfig$3;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply((Seq)newFields.toSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$10) {
                return x$10.name();
            }
        }, (Ordering)Ordering.String$.MODULE$));
    }

    private DataType structTypeToMapType(StructType structType, ReadConfig readConfig) {
        StructType structType2;
        if (readConfig.inferSchemaMapTypesEnabled() && structType.fields().length >= readConfig.inferSchemaMapTypesMinimumKeys()) {
            StructType structType3;
            DataType dataType = (DataType)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])structType.fields()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DataType apply(StructField x$11) {
                    return x$11.dataType();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))).reduce((Function2)new Serializable(readConfig){
                public static final long serialVersionUID = 0L;
                private final ReadConfig readConfig$5;

                public final DataType apply(DataType x$12, DataType x$13) {
                    return MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType(x$12, x$13, this.readConfig$5, MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType$default$4());
                }
                {
                    this.readConfig$5 = readConfig$5;
                }
            });
            if (ConflictType$.MODULE$.equals(dataType)) {
                structType3 = structType;
            } else if (((Object)((Object)SkipFieldType$.MODULE$)).equals(dataType)) {
                structType3 = structType;
            } else if (dataType != null) {
                DataType dataType2 = dataType;
                structType3 = DataTypes.createMapType((DataType)StringType$.MODULE$, (DataType)dataType2, (boolean)true);
            } else {
                structType3 = structType;
            }
            structType2 = structType3;
        } else {
            structType2 = structType;
        }
        return structType2;
    }

    public MapType com$mongodb$spark$sql$MongoInferSchema$$appendStructToMap(StructField[] fields, MapType mapType, ReadConfig readConfig) {
        DataType dataType = mapType.valueType();
        DataType valueType = (DataType)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(StructField x$14) {
                return x$14.dataType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))).$plus$colon((Object)dataType, ClassTag$.MODULE$.apply(DataType.class))).reduce((Function2)new Serializable(readConfig){
            public static final long serialVersionUID = 0L;
            private final ReadConfig readConfig$4;

            public final DataType apply(DataType x$16, DataType x$17) {
                return MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType(x$16, x$17, this.readConfig$4, MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType$default$4());
            }
            {
                this.readConfig$4 = readConfig$4;
            }
        });
        return DataTypes.createMapType((DataType)mapType.keyType(), (DataType)valueType, (boolean)mapType.valueContainsNull());
    }

    public Seq<NumericType> compatibleDecimalTypes() {
        return this.compatibleDecimalTypes;
    }

    private DecimalType ByteDecimal() {
        return this.ByteDecimal;
    }

    private DecimalType ShortDecimal() {
        return this.ShortDecimal;
    }

    private DecimalType IntDecimal() {
        return this.IntDecimal;
    }

    private DecimalType LongDecimal() {
        return this.LongDecimal;
    }

    private DecimalType FloatDecimal() {
        return this.FloatDecimal;
    }

    private DecimalType DoubleDecimal() {
        return this.DoubleDecimal;
    }

    private DecimalType BigIntDecimal() {
        return this.BigIntDecimal;
    }

    public DecimalType com$mongodb$spark$sql$MongoInferSchema$$forType(DataType dataType) {
        DataType dataType2;
        block8: {
            DecimalType decimalType;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    dataType2 = dataType;
                                    if (!ByteType$.MODULE$.equals(dataType2)) break block2;
                                    decimalType = this.ByteDecimal();
                                    break block3;
                                }
                                if (!ShortType$.MODULE$.equals(dataType2)) break block4;
                                decimalType = this.ShortDecimal();
                                break block3;
                            }
                            if (!IntegerType$.MODULE$.equals(dataType2)) break block5;
                            decimalType = this.IntDecimal();
                            break block3;
                        }
                        if (!LongType$.MODULE$.equals(dataType2)) break block6;
                        decimalType = this.LongDecimal();
                        break block3;
                    }
                    if (!FloatType$.MODULE$.equals(dataType2)) break block7;
                    decimalType = this.FloatDecimal();
                    break block3;
                }
                if (!DoubleType$.MODULE$.equals(dataType2)) break block8;
                decimalType = this.DoubleDecimal();
            }
            return decimalType;
        }
        throw new MatchError((Object)dataType2);
    }

    private StructField[] emptyStructFieldArray() {
        return this.emptyStructFieldArray;
    }

    private Object structFieldComparator() {
        return this.structFieldComparator;
    }

    private boolean isSorted(StructField[] arr) {
        for (int i = 0; i < arr.length - 1; ++i) {
            if (this.structFieldComparator().compare(arr[i], arr[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public DataType com$mongodb$spark$sql$MongoInferSchema$$getDataType(BsonValue bsonValue, ReadConfig readConfig) {
        DataType dataType;
        BsonType bsonType = bsonValue.getBsonType();
        if (BsonType.NULL.equals(bsonType)) {
            dataType = DataTypes.NullType;
        } else if (BsonType.ARRAY.equals(bsonType)) {
            dataType = this.getSchemaFromArray((Seq<BsonValue>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)bsonValue.asArray()).asScala()), readConfig);
        } else if (BsonType.BINARY.equals(bsonType)) {
            dataType = BsonCompatibility$Binary$.MODULE$.getDataType(bsonValue.asBinary());
        } else if (BsonType.BOOLEAN.equals(bsonType)) {
            dataType = DataTypes.BooleanType;
        } else if (BsonType.DATE_TIME.equals(bsonType)) {
            dataType = DataTypes.TimestampType;
        } else if (BsonType.DOCUMENT.equals(bsonType)) {
            dataType = this.com$mongodb$spark$sql$MongoInferSchema$$getSchemaFromDocument(bsonValue.asDocument(), readConfig);
        } else if (BsonType.DOUBLE.equals(bsonType)) {
            dataType = DataTypes.DoubleType;
        } else if (BsonType.INT32.equals(bsonType)) {
            dataType = DataTypes.IntegerType;
        } else if (BsonType.INT64.equals(bsonType)) {
            dataType = DataTypes.LongType;
        } else if (BsonType.STRING.equals(bsonType)) {
            dataType = DataTypes.StringType;
        } else if (BsonType.OBJECT_ID.equals(bsonType)) {
            dataType = BsonCompatibility$ObjectId$.MODULE$.structType();
        } else if (BsonType.TIMESTAMP.equals(bsonType)) {
            dataType = BsonCompatibility$Timestamp$.MODULE$.structType();
        } else if (BsonType.MIN_KEY.equals(bsonType)) {
            dataType = BsonCompatibility$MinKey$.MODULE$.structType();
        } else if (BsonType.MAX_KEY.equals(bsonType)) {
            dataType = BsonCompatibility$MaxKey$.MODULE$.structType();
        } else if (BsonType.JAVASCRIPT.equals(bsonType)) {
            dataType = BsonCompatibility$JavaScript$.MODULE$.structType();
        } else if (BsonType.JAVASCRIPT_WITH_SCOPE.equals(bsonType)) {
            dataType = BsonCompatibility$JavaScriptWithScope$.MODULE$.structType();
        } else if (BsonType.REGULAR_EXPRESSION.equals(bsonType)) {
            dataType = BsonCompatibility$RegularExpression$.MODULE$.structType();
        } else if (BsonType.UNDEFINED.equals(bsonType)) {
            dataType = BsonCompatibility$Undefined$.MODULE$.structType();
        } else if (BsonType.SYMBOL.equals(bsonType)) {
            dataType = BsonCompatibility$Symbol$.MODULE$.structType();
        } else if (BsonType.DB_POINTER.equals(bsonType)) {
            dataType = BsonCompatibility$DbPointer$.MODULE$.structType();
        } else if (BsonType.DECIMAL128.equals(bsonType)) {
            BigDecimal bigDecimalValue = bsonValue.asDecimal128().decimal128Value().bigDecimalValue();
            int precision = Integer.max(bigDecimalValue.precision(), bigDecimalValue.scale());
            dataType = DataTypes.createDecimalType((int)precision, (int)bigDecimalValue.scale());
        } else {
            dataType = ConflictType$.MODULE$;
        }
        return dataType;
    }

    private DataType getSchemaFromArray(Seq<BsonValue> bsonArray, ReadConfig readConfig) {
        SkipFieldType$ skipFieldType$;
        Seq arrayTypes = (Seq)((SeqLike)bsonArray.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BsonType apply(BsonValue x$18) {
                return x$18.getBsonType();
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        int n = arrayTypes.length();
        switch (n) {
            default: {
                skipFieldType$ = this.getCompatibleArraySchema(bsonArray, readConfig);
                break;
            }
            case 1: {
                if (((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonType[]{BsonType.ARRAY, BsonType.DOCUMENT}))).contains(arrayTypes.head())) {
                    skipFieldType$ = this.getCompatibleArraySchema(bsonArray, readConfig);
                    break;
                }
                skipFieldType$ = DataTypes.createArrayType((DataType)this.com$mongodb$spark$sql$MongoInferSchema$$getDataType((BsonValue)bsonArray.head(), readConfig), (boolean)true);
                break;
            }
            case 0: {
                skipFieldType$ = SkipFieldType$.MODULE$;
            }
        }
        return skipFieldType$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean com$mongodb$spark$sql$MongoInferSchema$$fieldContainsConflictType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof ArrayType) {
            DataType elementType;
            ArrayType arrayType = (ArrayType)dataType2;
            DataType dataType3 = elementType = arrayType.elementType();
            ConflictType$ conflictType$ = ConflictType$.MODULE$;
            if (dataType3 == null) {
                if (conflictType$ == null) return true;
            } else if (dataType3.equals(conflictType$)) {
                return true;
            }
        }
        if (!ConflictType$.MODULE$.equals(dataType2)) return false;
        return true;
    }

    public DataType getCompatibleArraySchema(Seq<BsonValue> bsonArray, ReadConfig readConfig) {
        ObjectRef arrayType = ObjectRef.create((Object)new Some((Object)SkipFieldType$.MODULE$));
        bsonArray.takeWhile((Function1)new Serializable(readConfig, arrayType){
            public static final long serialVersionUID = 0L;
            private final ReadConfig readConfig$6;
            private final ObjectRef arrayType$1;

            public final boolean apply(BsonValue x0$3) {
                BsonValue bsonValue;
                block7: {
                    boolean bl;
                    block6: {
                        block5: {
                            bsonValue = x0$3;
                            if (!(bsonValue instanceof BsonNull)) break block5;
                            bl = true;
                            break block6;
                        }
                        if (bsonValue == null) break block7;
                        BsonValue bsonValue2 = bsonValue;
                        Option previous = (Option)this.arrayType$1.elem;
                        this.arrayType$1.elem = new Some((Object)MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$getDataType(bsonValue2, this.readConfig$6));
                        if (previous.nonEmpty()) {
                            Option option = (Option)this.arrayType$1.elem;
                            Option option2 = previous;
                            if (option == null ? option2 != null : !option.equals(option2)) {
                                this.arrayType$1.elem = new Some((Object)MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType((DataType)((Option)this.arrayType$1.elem).get(), (DataType)previous.get(), this.readConfig$6, MongoInferSchema$.MODULE$.com$mongodb$spark$sql$MongoInferSchema$$compatibleType$default$4()));
                            }
                        }
                        bl = !((Option)this.arrayType$1.elem).contains((Object)ConflictType$.MODULE$);
                    }
                    return bl;
                }
                throw new MatchError((Object)bsonValue);
            }
            {
                this.readConfig$6 = readConfig$6;
                this.arrayType$1 = arrayType$1;
            }
        });
        DataType dataType = (DataType)((Option)arrayType.elem).get();
        SkipFieldType$ skipFieldType$ = ((Object)((Object)SkipFieldType$.MODULE$)).equals(dataType) ? SkipFieldType$.MODULE$ : DataTypes.createArrayType((DataType)dataType, (boolean)true);
        return skipFieldType$;
    }

    public <T extends Product> Option<StructType> reflectSchema(TypeTags.TypeTag<T> evidence$1) {
        Types.TypeApi typeApi;
        Types.TypeApi typeApi2 = typeApi = ((TypeTags)package$.MODULE$.universe()).typeOf(evidence$1);
        Types.TypeApi typeApi3 = ((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)package$.MODULE$.universe()).TypeTag().Nothing());
        Object object = !(typeApi2 != null ? !typeApi2.equals(typeApi3) : typeApi3 != null) ? None$.MODULE$ : new Some((Object)((StructType)ScalaReflection$.MODULE$.schemaFor(evidence$1).dataType()));
        return object;
    }

    public <T> StructType reflectSchema(Class<T> beanClass) {
        return MongoInferSchemaJava.reflectSchema(beanClass);
    }

    private MongoInferSchema$() {
        MODULE$ = this;
        this.compatibleDecimalTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$}));
        this.ByteDecimal = new DecimalType(3, 0);
        this.ShortDecimal = new DecimalType(5, 0);
        this.IntDecimal = new DecimalType(10, 0);
        this.LongDecimal = new DecimalType(20, 0);
        this.FloatDecimal = new DecimalType(14, 7);
        this.DoubleDecimal = new DecimalType(30, 15);
        this.BigIntDecimal = new DecimalType(38, 0);
        this.emptyStructFieldArray = (StructField[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StructField.class));
        this.structFieldComparator = new Comparator<StructField>(){

            public int compare(StructField o1, StructField o2) {
                return new StringOps(Predef$.MODULE$.augmentString(o1.name())).compare(o2.name());
            }
        };
    }
}

