/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.fieldTypes.api.java;

import com.mongodb.spark.sql.fieldTypes.api.java.Assertions;
import org.bson.types.ObjectId;

public final class DbPointer {
    private String ref;
    private String oid;

    public DbPointer() {
    }

    public DbPointer(String ref, ObjectId oid) {
        this(ref, Assertions.notNull("oid", oid).toHexString());
    }

    public DbPointer(String ref, String oid) {
        this.ref = Assertions.notNull("ref", ref);
        this.oid = Assertions.notNull("oid", oid);
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = Assertions.notNull("ref", ref);
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = Assertions.notNull("oid", oid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbPointer that = (DbPointer)o;
        if (this.ref != null ? !this.ref.equals(that.ref) : that.ref != null) {
            return false;
        }
        return this.oid != null ? this.oid.equals(that.oid) : that.oid == null;
    }

    public int hashCode() {
        int result = this.ref != null ? this.ref.hashCode() : 0;
        result = 31 * result + (this.oid != null ? this.oid.hashCode() : 0);
        return result;
    }
}

