/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.aliyun.openservices.tablestore.hadoop.RowDeleteChangeWritable;
import com.aliyun.openservices.tablestore.hadoop.RowPutChangeWritable;
import com.aliyun.openservices.tablestore.hadoop.RowUpdateChangeWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;

public class BatchWriteWritable
implements Writable,
Externalizable {
    private List<RowChange> changes = new ArrayList<RowChange>();

    public void addRowChange(RowChange row) {
        Preconditions.checkNotNull((Object)row, (Object)"row must be nonnull.");
        this.changes.add(row);
    }

    public List<RowChange> getRowChanges() {
        return this.changes;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(86);
        out.writeInt(this.changes.size());
        for (int i = 0; i < this.changes.size(); ++i) {
            RowChange rowChange = this.changes.get(i);
            if (rowChange instanceof RowPutChange) {
                out.writeByte(89);
                new RowPutChangeWritable((RowPutChange)rowChange).write(out);
                continue;
            }
            if (rowChange instanceof RowDeleteChange) {
                out.writeByte(90);
                new RowDeleteChangeWritable((RowDeleteChange)rowChange).write(out);
                continue;
            }
            if (rowChange instanceof RowUpdateChange) {
                out.writeByte(92);
                new RowUpdateChangeWritable((RowUpdateChange)rowChange).write(out);
                continue;
            }
            throw new AssertionError((Object)("unsupported RowChange type: " + rowChange.getClass().getName()));
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte tagBatchWrite = in.readByte();
        if (tagBatchWrite != 86) {
            throw new IOException("broken input stream");
        }
        ArrayList<RowChange> changes = new ArrayList<RowChange>();
        int rowSz = in.readInt();
        for (int i = 0; i < rowSz; ++i) {
            byte tagRow = in.readByte();
            if (tagRow == 89) {
                changes.add((RowChange)RowPutChangeWritable.read(in).getRowPutChange());
                continue;
            }
            if (tagRow == 90) {
                changes.add((RowChange)RowDeleteChangeWritable.read(in).getRowDeleteChange());
                continue;
            }
            if (tagRow == 92) {
                changes.add((RowChange)RowUpdateChangeWritable.read(in).getRowUpdateChange());
                continue;
            }
            throw new IOException("broken input stream");
        }
        this.changes = changes;
    }

    public static BatchWriteWritable read(DataInput in) throws IOException {
        BatchWriteWritable w = new BatchWriteWritable();
        w.readFields(in);
        return w;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFields(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }
}

