/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Condition;
import com.alicloud.openservices.tablestore.model.RowExistenceExpectation;
import com.alicloud.openservices.tablestore.model.condition.ColumnCondition;
import com.alicloud.openservices.tablestore.model.condition.CompositeColumnValueCondition;
import com.alicloud.openservices.tablestore.model.condition.SingleColumnValueCondition;
import com.alicloud.openservices.tablestore.model.filter.CompositeColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import com.alicloud.openservices.tablestore.model.filter.SingleColumnValueFilter;
import com.aliyun.openservices.tablestore.hadoop.FilterWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.hadoop.io.Writable;

public class ConditionWritable
implements Writable,
Externalizable {
    private Condition condition;

    public ConditionWritable() {
    }

    public ConditionWritable(Condition condition) {
        Preconditions.checkNotNull((Object)condition, (Object)"condition must be nonnull.");
        this.condition = condition;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(101);
        switch (this.condition.getRowExistenceExpectation()) {
            case IGNORE: {
                out.writeByte(102);
                break;
            }
            case EXPECT_EXIST: {
                out.writeByte(105);
                break;
            }
            case EXPECT_NOT_EXIST: {
                out.writeByte(106);
            }
        }
        ColumnCondition cc = this.condition.getColumnCondition();
        if (cc == null) {
            out.writeByte(108);
        } else {
            out.writeByte(111);
            switch (cc.getConditionType()) {
                case COMPOSITE_COLUMN_VALUE_CONDITION: {
                    new FilterWritable((Filter)((CompositeColumnValueCondition)cc).toFilter()).write(out);
                    break;
                }
                case SINGLE_COLUMN_VALUE_CONDITION: {
                    new FilterWritable((Filter)((SingleColumnValueCondition)cc).toFilter()).write(out);
                }
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte tagCondition = in.readByte();
        if (tagCondition != 101) {
            throw new IOException("broken input stream");
        }
        Condition condition = new Condition();
        byte tagRowCondition = in.readByte();
        if (tagRowCondition == 102) {
            condition.setRowExistenceExpectation(RowExistenceExpectation.IGNORE);
        } else if (tagRowCondition == 105) {
            condition.setRowExistenceExpectation(RowExistenceExpectation.EXPECT_EXIST);
        } else if (tagRowCondition == 106) {
            condition.setRowExistenceExpectation(RowExistenceExpectation.EXPECT_NOT_EXIST);
        } else {
            throw new IOException("broken input stream");
        }
        byte tagColCondition = in.readByte();
        if (tagColCondition != 108) {
            Filter filter = FilterWritable.read(in).getFilter();
            condition.setColumnCondition(this.filterToColumnCondition(filter));
        }
        this.condition = condition;
    }

    public static ConditionWritable read(DataInput in) throws IOException {
        ConditionWritable w = new ConditionWritable();
        w.readFields(in);
        return w;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFields(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }

    private ColumnCondition filterToColumnCondition(Filter filter) {
        if (filter instanceof SingleColumnValueFilter) {
            return ((SingleColumnValueFilter)filter).toCondition();
        }
        if (filter instanceof CompositeColumnValueFilter) {
            return ((CompositeColumnValueFilter)filter).toCondition();
        }
        throw new AssertionError((Object)"unknown filter type");
    }
}

