/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.hadoop.io.WritableComparable;

public class PrimaryKeyWritable
implements WritableComparable<PrimaryKeyWritable>,
Externalizable {
    private PrimaryKey primaryKey = null;

    public PrimaryKeyWritable() {
    }

    public PrimaryKeyWritable(PrimaryKey pkey) {
        Preconditions.checkNotNull((Object)pkey, (Object)"The primary key should not be null.");
        this.primaryKey = pkey;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey pkey) {
        Preconditions.checkNotNull((Object)pkey, (Object)"The primary key should not be null.");
        this.primaryKey = pkey;
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkNotNull((Object)this.primaryKey, (Object)"primaryKey should not be null.");
        PrimaryKeyColumn[] cs = this.primaryKey.getPrimaryKeyColumns();
        out.writeByte(17);
        out.writeInt(cs.length);
        for (int i = 0; i < cs.length; ++i) {
            PrimaryKeyColumn c = cs[i];
            out.writeByte(18);
            out.writeUTF(c.getName());
            PrimaryKeyValue v = c.getValue();
            if (v.isInfMin()) {
                out.writeByte(3);
                continue;
            }
            if (v.isInfMax()) {
                out.writeByte(5);
                continue;
            }
            if (v.getType() == PrimaryKeyType.INTEGER) {
                out.writeByte(9);
                out.writeLong(v.asLong());
                continue;
            }
            if (v.getType() == PrimaryKeyType.STRING) {
                out.writeByte(6);
                out.writeUTF(v.asString());
                continue;
            }
            if (v.getType() == PrimaryKeyType.BINARY) {
                out.writeByte(10);
                byte[] bs = v.asBinary();
                out.writeInt(bs.length);
                out.write(bs);
                continue;
            }
            throw new AssertionError((Object)"");
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte pkeyTag = in.readByte();
        if (pkeyTag != 17) {
            throw new IOException("broken input stream");
        }
        int sz = in.readInt();
        PrimaryKeyColumn[] cs = new PrimaryKeyColumn[sz];
        for (int i = 0; i < sz; ++i) {
            PrimaryKeyColumn c;
            byte tag = in.readByte();
            if (tag != 18) {
                throw new IOException("broken input stream");
            }
            String name = in.readUTF();
            tag = in.readByte();
            if (tag == 3) {
                PrimaryKeyColumn c2;
                cs[i] = c2 = new PrimaryKeyColumn(name, PrimaryKeyValue.INF_MIN);
                continue;
            }
            if (tag == 5) {
                PrimaryKeyColumn c3;
                cs[i] = c3 = new PrimaryKeyColumn(name, PrimaryKeyValue.INF_MAX);
                continue;
            }
            if (tag == 9) {
                long v = in.readLong();
                cs[i] = c = new PrimaryKeyColumn(name, PrimaryKeyValue.fromLong((long)v));
                continue;
            }
            if (tag == 6) {
                PrimaryKeyColumn c4;
                String v = in.readUTF();
                cs[i] = c4 = new PrimaryKeyColumn(name, PrimaryKeyValue.fromString((String)v));
                continue;
            }
            if (tag == 10) {
                int l = in.readInt();
                byte[] v = new byte[l];
                in.readFully(v);
                cs[i] = c = new PrimaryKeyColumn(name, PrimaryKeyValue.fromBinary((byte[])v));
                continue;
            }
            throw new IOException("broken input stream");
        }
        this.primaryKey = new PrimaryKey(cs);
    }

    public static PrimaryKeyWritable read(DataInput in) throws IOException {
        PrimaryKeyWritable w = new PrimaryKeyWritable();
        w.readFields(in);
        return w;
    }

    public int compareTo(PrimaryKeyWritable o) {
        Preconditions.checkNotNull((Object)this.primaryKey, (Object)"The primary key should not be null.");
        Preconditions.checkNotNull((Object)o.primaryKey, (Object)"The primary key should not be null.");
        return this.primaryKey.compareTo(o.primaryKey);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFields(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }
}

