/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Direction;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.TimeRange;
import com.aliyun.openservices.tablestore.hadoop.FilterWritable;
import com.aliyun.openservices.tablestore.hadoop.PrimaryKeyWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.io.Writable;

public class RangeRowQueryCriteriaWritable
implements Writable {
    private RangeRowQueryCriteria criteria = null;

    public RangeRowQueryCriteriaWritable() {
    }

    public RangeRowQueryCriteriaWritable(RangeRowQueryCriteria criteria) {
        Preconditions.checkNotNull((Object)criteria, (Object)"criteria should not be null.");
        this.criteria = criteria;
    }

    public RangeRowQueryCriteria getRangeRowQueryCriteria() {
        return this.criteria;
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkNotNull((Object)this.criteria, (Object)"criteria should not be null.");
        Preconditions.checkNotNull((Object)this.criteria.getTableName(), (Object)"criteria must have table name");
        out.writeByte(29);
        out.writeUTF(this.criteria.getTableName());
        if (this.criteria.numColumnsToGet() > 0) {
            Set cols = this.criteria.getColumnsToGet();
            out.writeByte(33);
            out.writeInt(cols.size());
            for (String c : cols) {
                out.writeUTF(c);
            }
        }
        if (this.criteria.hasSetMaxVersions()) {
            out.writeByte(34);
            out.writeInt(this.criteria.getMaxVersions());
        }
        if (this.criteria.hasSetTimeRange()) {
            TimeRange tm = this.criteria.getTimeRange();
            out.writeByte(36);
            out.writeLong(tm.getStart());
            out.writeLong(tm.getEnd());
        }
        if (this.criteria.hasSetCacheBlock()) {
            out.writeByte(39);
            out.writeBoolean(this.criteria.getCacheBlocks());
        }
        if (this.criteria.hasSetStartColumn()) {
            out.writeByte(40);
            out.writeUTF(this.criteria.getStartColumn());
        }
        if (this.criteria.hasSetEndColumn()) {
            out.writeByte(43);
            out.writeUTF(this.criteria.getEndColumn());
        }
        if (this.criteria.getLimit() != -1) {
            out.writeByte(45);
            out.writeInt(this.criteria.getLimit());
        }
        if (this.criteria.getDirection() != Direction.FORWARD) {
            Preconditions.checkArgument((this.criteria.getDirection() == Direction.BACKWARD ? 1 : 0) != 0, (Object)"direction must be either FORWARD or BACKWORD");
            out.writeByte(46);
        }
        if (this.criteria.getInclusiveStartPrimaryKey() != null) {
            out.writeByte(48);
            new PrimaryKeyWritable(this.criteria.getInclusiveStartPrimaryKey()).write(out);
        }
        if (this.criteria.getExclusiveEndPrimaryKey() != null) {
            out.writeByte(51);
            new PrimaryKeyWritable(this.criteria.getExclusiveEndPrimaryKey()).write(out);
        }
        if (this.criteria.hasSetFilter()) {
            new FilterWritable(this.criteria.getFilter()).write(out);
        }
        out.writeByte(113);
    }

    public void readFields(DataInput in) throws IOException {
        byte tag;
        byte tagCriteria = in.readByte();
        if (tagCriteria != 29) {
            throw new IOException("broken input stream");
        }
        String tblName = in.readUTF();
        this.criteria = new RangeRowQueryCriteria(tblName);
        block0: while (true) {
            if ((tag = in.readByte()) == 33) {
                int sz = in.readInt();
                int i = 0;
                while (true) {
                    if (i >= sz) continue block0;
                    String c = in.readUTF();
                    this.criteria.addColumnsToGet(c);
                    ++i;
                }
            }
            if (tag == 34) {
                this.criteria.setMaxVersions(in.readInt());
                continue;
            }
            if (tag == 36) {
                long start = in.readLong();
                long end = in.readLong();
                this.criteria.setTimeRange(new TimeRange(start, end));
                continue;
            }
            if (tag == 39) {
                this.criteria.setCacheBlocks(in.readBoolean());
                continue;
            }
            if (tag == 40) {
                this.criteria.setStartColumn(in.readUTF());
                continue;
            }
            if (tag == 43) {
                this.criteria.setEndColumn(in.readUTF());
                continue;
            }
            if (tag == 45) {
                this.criteria.setLimit(in.readInt());
                continue;
            }
            if (tag == 46) {
                this.criteria.setDirection(Direction.BACKWARD);
                continue;
            }
            if (tag == 48) {
                PrimaryKeyWritable pkey = PrimaryKeyWritable.read(in);
                this.criteria.setInclusiveStartPrimaryKey(pkey.getPrimaryKey());
                continue;
            }
            if (tag == 51) {
                PrimaryKeyWritable pkey = PrimaryKeyWritable.read(in);
                this.criteria.setExclusiveEndPrimaryKey(pkey.getPrimaryKey());
                continue;
            }
            if (tag != 60) break;
            this.criteria.setFilter(FilterWritable.readFilter(in));
        }
        if (tag != 113) {
            throw new IOException("broken input stream");
        }
    }

    public static RangeRowQueryCriteriaWritable read(DataInput in) throws IOException {
        RangeRowQueryCriteriaWritable w = new RangeRowQueryCriteriaWritable();
        w.readFields(in);
        return w;
    }
}

