/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.aliyun.openservices.tablestore.hadoop.ConditionWritable;
import com.aliyun.openservices.tablestore.hadoop.PrimaryKeyWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.hadoop.io.Writable;

public class RowDeleteChangeWritable
implements Writable,
Externalizable {
    private RowDeleteChange delRow;

    public RowDeleteChangeWritable() {
    }

    public RowDeleteChangeWritable(RowDeleteChange delRow) {
        Preconditions.checkNotNull((Object)delRow, (Object)"delRow must be nonnull.");
        this.delRow = delRow;
    }

    public RowDeleteChange getRowDeleteChange() {
        return this.delRow;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.delRow.getTableName());
        new PrimaryKeyWritable(this.delRow.getPrimaryKey()).write(out);
        new ConditionWritable(this.delRow.getCondition()).write(out);
    }

    public void readFields(DataInput in) throws IOException {
        String tableName = in.readUTF();
        PrimaryKey pkey = PrimaryKeyWritable.read(in).getPrimaryKey();
        RowDeleteChange delRow = new RowDeleteChange(tableName, pkey);
        delRow.setCondition(ConditionWritable.read(in).getCondition());
        this.delRow = delRow;
    }

    public static RowDeleteChangeWritable read(DataInput in) throws IOException {
        RowDeleteChangeWritable w = new RowDeleteChangeWritable();
        w.readFields(in);
        return w;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFields(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }
}

