/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.Row;
import com.aliyun.openservices.tablestore.hadoop.ColumnWritable;
import com.aliyun.openservices.tablestore.hadoop.PrimaryKeyWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.hadoop.io.Writable;

public class RowWritable
implements Writable,
Externalizable {
    private Row row = null;

    public RowWritable() {
    }

    public RowWritable(Row row) {
        Preconditions.checkNotNull((Object)row, (Object)"row should not be null.");
        this.row = row;
    }

    public Row getRow() {
        return this.row;
    }

    public void setRow(Row row) {
        Preconditions.checkNotNull((Object)row, (Object)"row should not be null.");
        this.row = row;
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkNotNull((Object)this.row, (Object)"column should not be null.");
        out.writeByte(27);
        new PrimaryKeyWritable(this.row.getPrimaryKey()).write(out);
        Column[] cols = this.row.getColumns();
        out.writeInt(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            new ColumnWritable(cols[i]).write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte tagRow = in.readByte();
        if (tagRow != 27) {
            throw new IOException("broken input stream");
        }
        PrimaryKey pkey = PrimaryKeyWritable.read(in).getPrimaryKey();
        int sz = in.readInt();
        Column[] cols = new Column[sz];
        for (int i = 0; i < sz; ++i) {
            cols[i] = ColumnWritable.read(in).getColumn();
        }
        this.row = new Row(pkey, cols);
    }

    public static RowWritable read(DataInput in) throws IOException {
        RowWritable w = new RowWritable();
        w.readFields(in);
        return w;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFields(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }
}

