/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.provider.RefreshResult;
import com.aliyun.tea.utils.Validate;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RefreshCachedSupplier<T>
implements AutoCloseable {
    private static final long REFRESH_BLOCKING_MAX_WAIT = 5000L;
    private final Lock refreshLock = new ReentrantLock();
    private final AtomicBoolean asyncRefreshing = new AtomicBoolean(false);
    private final ExecutorService executor = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Executors.defaultThreadFactory());
    private volatile RefreshResult<T> cachedValue = RefreshResult.builder(null).staleTime(0L).build();
    private final Callable<RefreshResult<T>> refreshCallable;
    private final boolean asyncUpdateEnabled;

    private RefreshCachedSupplier(Builder<T> builder) {
        this.refreshCallable = (Callable)Validate.notNull((Object)((Builder)builder).refreshCallable, (String)"Refresh Callable is null.", (Object[])new Object[0]);
        this.asyncUpdateEnabled = ((Builder)builder).asyncUpdateEnabled;
    }

    public static <T> Builder<T> builder(Callable<RefreshResult<T>> refreshCallable) {
        return new Builder(refreshCallable);
    }

    public T get() {
        if (this.cacheIsStale()) {
            if (this.asyncUpdateEnabled) {
                this.asyncRefresh();
            } else {
                this.blockingRefresh();
            }
        }
        return null != this.cachedValue ? (T)this.cachedValue.value() : null;
    }

    private void refreshCache() {
        try {
            this.cachedValue = this.refreshCallable.call();
        }
        catch (CredentialException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new CredentialException("Failed to refresh credentials.", e);
        }
    }

    private void blockingRefresh() {
        block7: {
            try {
                if (!this.refreshLock.tryLock(5000L, TimeUnit.MILLISECONDS)) break block7;
                try {
                    if (this.cacheIsStale()) {
                        this.refreshCache();
                    }
                }
                finally {
                    this.refreshLock.unlock();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted waiting to refresh the value.", ex);
            }
            catch (Exception ex) {
                throw ex;
            }
        }
    }

    private void asyncRefresh() {
        if (this.asyncRefreshing.compareAndSet(false, true)) {
            try {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RefreshCachedSupplier.this.refreshCache();
                        }
                        finally {
                            RefreshCachedSupplier.this.asyncRefreshing.set(false);
                        }
                    }
                });
            }
            catch (RuntimeException ex) {
                this.asyncRefreshing.set(false);
                throw ex;
            }
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    private boolean cacheIsStale() {
        return this.cachedValue == null || new Date().getTime() >= this.cachedValue.staleTime();
    }

    public static final class Builder<T> {
        private final Callable<RefreshResult<T>> refreshCallable;
        private boolean asyncUpdateEnabled;

        private Builder(Callable<RefreshResult<T>> refreshCallable) {
            this.refreshCallable = refreshCallable;
        }

        public Builder<T> asyncUpdateEnabled(Boolean asyncUpdateEnabled) {
            this.asyncUpdateEnabled = asyncUpdateEnabled;
            return this;
        }

        public RefreshCachedSupplier<T> build() {
            return new RefreshCachedSupplier(this);
        }
    }
}

