/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.Configuration;
import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.http.CompatibleUrlConnClient;
import com.aliyun.credentials.models.Config;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.ECSMetadataServiceCredentialsFetcher;
import com.aliyun.credentials.provider.RefreshResult;
import com.aliyun.credentials.provider.SessionCredentialsProvider;
import com.aliyun.credentials.utils.AuthUtils;
import com.aliyun.credentials.utils.StringUtils;

public class EcsRamRoleCredentialProvider
extends SessionCredentialsProvider {
    private ECSMetadataServiceCredentialsFetcher fetcher;

    @Deprecated
    public EcsRamRoleCredentialProvider(String roleName) {
        super(new BuilderImpl());
        if (StringUtils.isEmpty(roleName)) {
            try (CompatibleUrlConnClient client = new CompatibleUrlConnClient();){
                roleName = new ECSMetadataServiceCredentialsFetcher("").fetchRoleName(client);
            }
        }
        this.fetcher = new ECSMetadataServiceCredentialsFetcher(roleName);
    }

    @Deprecated
    public EcsRamRoleCredentialProvider(Configuration config) {
        super(new BuilderImpl());
        if (StringUtils.isEmpty(config.getRoleName())) {
            try (CompatibleUrlConnClient client = new CompatibleUrlConnClient();){
                String roleName = new ECSMetadataServiceCredentialsFetcher("").fetchRoleName(client);
                config.setRoleName(roleName);
            }
        }
        this.fetcher = new ECSMetadataServiceCredentialsFetcher(config.getRoleName(), config.getConnectTimeout(), config.getReadTimeout());
    }

    @Deprecated
    public EcsRamRoleCredentialProvider(Config config) {
        super(new BuilderImpl());
        String roleName = config.roleName;
        if (StringUtils.isEmpty(roleName)) {
            try (CompatibleUrlConnClient client = new CompatibleUrlConnClient();){
                roleName = new ECSMetadataServiceCredentialsFetcher("", config.disableIMDSv1, config.connectTimeout, config.timeout).fetchRoleName(client);
            }
        }
        this.fetcher = new ECSMetadataServiceCredentialsFetcher(roleName, config.disableIMDSv1, config.connectTimeout, config.timeout);
    }

    private EcsRamRoleCredentialProvider(BuilderImpl builder) {
        super(builder);
        if (AuthUtils.isDisableECSMetaData()) {
            throw new CredentialException("IMDS credentials is disabled.");
        }
        String roleName = builder.roleName == null ? AuthUtils.getEnvironmentECSMetaData() : builder.roleName;
        boolean disableIMDSv1 = builder.disableIMDSv1 == null ? AuthUtils.getDisableECSIMDSv1() : builder.disableIMDSv1;
        this.fetcher = new ECSMetadataServiceCredentialsFetcher(roleName, disableIMDSv1, builder.connectionTimeout, builder.readTimeout);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public RefreshResult<CredentialModel> refreshCredentials() {
        try (CompatibleUrlConnClient client = new CompatibleUrlConnClient();){
            RefreshResult<CredentialModel> refreshResult = this.fetcher.fetch(client);
            return refreshResult;
        }
    }

    public ECSMetadataServiceCredentialsFetcher getFetcher() {
        return this.fetcher;
    }

    public void setFetcher(ECSMetadataServiceCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public String getProviderName() {
        return "ecs_ram_role";
    }

    @Override
    public void close() {
    }

    private static final class BuilderImpl
    extends SessionCredentialsProvider.BuilderImpl<EcsRamRoleCredentialProvider, Builder>
    implements Builder {
        private String roleName;
        private Boolean disableIMDSv1;
        private boolean enableIMDSv2;
        private int metadataTokenDuration;
        private Integer connectionTimeout;
        private Integer readTimeout;

        private BuilderImpl() {
        }

        @Override
        public Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        @Override
        public Builder disableIMDSv1(Boolean disableIMDSv1) {
            this.disableIMDSv1 = disableIMDSv1;
            return this;
        }

        @Override
        public Builder enableIMDSv2(boolean enableIMDSv2) {
            this.enableIMDSv2 = enableIMDSv2;
            return this;
        }

        @Override
        public Builder metadataTokenDuration(int metadataTokenDuration) {
            if (metadataTokenDuration > 0) {
                this.metadataTokenDuration = metadataTokenDuration;
            }
            return this;
        }

        @Override
        public Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Override
        public Builder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public EcsRamRoleCredentialProvider build() {
            return new EcsRamRoleCredentialProvider(this);
        }
    }

    public static interface Builder
    extends SessionCredentialsProvider.Builder<EcsRamRoleCredentialProvider, Builder> {
        public Builder roleName(String var1);

        public Builder disableIMDSv1(Boolean var1);

        @Deprecated
        public Builder enableIMDSv2(boolean var1);

        @Deprecated
        public Builder metadataTokenDuration(int var1);

        public Builder connectionTimeout(Integer var1);

        public Builder readTimeout(Integer var1);

        @Override
        public EcsRamRoleCredentialProvider build();
    }
}

