/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.provider.RefreshCachedSupplier;
import com.aliyun.credentials.provider.RefreshResult;
import java.util.Date;
import java.util.concurrent.Callable;

public abstract class SessionCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private final boolean asyncCredentialUpdateEnabled;
    private RefreshCachedSupplier<CredentialModel> credentialsCache;
    private final Callable<RefreshResult<CredentialModel>> refreshCallable = new Callable<RefreshResult<CredentialModel>>(){

        @Override
        public RefreshResult<CredentialModel> call() throws Exception {
            return SessionCredentialsProvider.this.refreshCredentials();
        }
    };

    public abstract RefreshResult<CredentialModel> refreshCredentials();

    protected SessionCredentialsProvider(BuilderImpl<?, ?> builder) {
        this.asyncCredentialUpdateEnabled = ((BuilderImpl)builder).asyncCredentialUpdateEnabled;
        this.credentialsCache = RefreshCachedSupplier.builder(this.refreshCallable).asyncUpdateEnabled(this.asyncCredentialUpdateEnabled).build();
    }

    public long getStaleTime(long expiration) {
        return expiration <= 0L ? new Date().getTime() + 3600000L : expiration - 180000L;
    }

    @Override
    public CredentialModel getCredentials() {
        return this.credentialsCache.get();
    }

    public boolean isAsyncCredentialUpdateEnabled() {
        return this.asyncCredentialUpdateEnabled;
    }

    public void close() {
        if (null != this.credentialsCache) {
            this.credentialsCache.close();
        }
    }

    protected static abstract class BuilderImpl<ProviderT extends SessionCredentialsProvider, BuilderT extends Builder>
    implements Builder<ProviderT, BuilderT> {
        private boolean asyncCredentialUpdateEnabled = false;

        protected BuilderImpl() {
        }

        @Override
        public BuilderT asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return (BuilderT)this;
        }
    }

    public static interface Builder<ProviderT extends SessionCredentialsProvider, BuilderT extends Builder> {
        public BuilderT asyncCredentialUpdateEnabled(Boolean var1);

        public ProviderT build();
    }
}

