/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.policy;

import com.aliyun.credentials.policy.PrefetchStrategy;
import com.aliyun.tea.logging.ClientLogger;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class NonBlocking
implements PrefetchStrategy {
    private static final ClientLogger logger = new ClientLogger(NonBlocking.class);
    static final int MAX_CONCURRENT_REFRESHES = 100;
    private static final Semaphore CONCURRENT_REFRESH_LEASES = new Semaphore(100);
    private final AtomicBoolean currentlyRefreshing = new AtomicBoolean(false);
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setName("non-blocking-refresh");
            t.setDaemon(true);
            return t;
        }
    });

    @Override
    public void prefetch(Runnable valueUpdater) {
        if (this.currentlyRefreshing.compareAndSet(false, true)) {
            if (!CONCURRENT_REFRESH_LEASES.tryAcquire()) {
                logger.warning("Skipping a background refresh task because there are too many other tasks running.");
                this.currentlyRefreshing.set(false);
                return;
            }
            try {
                executor.submit(() -> {
                    try {
                        valueUpdater.run();
                    }
                    catch (Throwable t) {
                        logger.logThrowableAsWarning(t);
                    }
                    finally {
                        CONCURRENT_REFRESH_LEASES.release();
                        this.currentlyRefreshing.set(false);
                    }
                });
            }
            catch (Throwable t) {
                logger.logThrowableAsWarning(t);
                CONCURRENT_REFRESH_LEASES.release();
                this.currentlyRefreshing.set(false);
            }
        }
    }

    @Override
    public void close() {
    }
}

