package darabonba.core.policy.retry.conditions;

import com.aliyun.core.utils.Validate;
import darabonba.core.policy.retry.RetryPolicyContext;

public final class MaxRetriesCondition implements RetryCondition {

    private final int maxNumberOfRetries;

    private MaxRetriesCondition(int maxNumberOfRetries) {
        this.maxNumberOfRetries = Validate.isNotNegative(maxNumberOfRetries, "maxNumberOfRetries");
    }

    public static MaxRetriesCondition create(int maxNumberOfRetries) {
        return new MaxRetriesCondition(maxNumberOfRetries);
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return context.retriesAttempted() < maxNumberOfRetries;
    }
}
