/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub;

import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.auth.AliyunAccount;
import com.aliyun.datahub.common.data.RecordSchema;
import com.aliyun.datahub.common.data.RecordType;
import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.KeyRangeUtils;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.AppendDataConnectorFieldRequest;
import com.aliyun.datahub.model.AppendDataConnectorFieldResult;
import com.aliyun.datahub.model.AppendFieldRequest;
import com.aliyun.datahub.model.AppendFieldResult;
import com.aliyun.datahub.model.BlobRecordEntry;
import com.aliyun.datahub.model.CommitOffsetRequest;
import com.aliyun.datahub.model.CommitOffsetResult;
import com.aliyun.datahub.model.ConnectorConfig;
import com.aliyun.datahub.model.ConnectorType;
import com.aliyun.datahub.model.CreateDataConnectorRequest;
import com.aliyun.datahub.model.CreateDataConnectorResult;
import com.aliyun.datahub.model.CreateProjectRequest;
import com.aliyun.datahub.model.CreateTopicRequest;
import com.aliyun.datahub.model.DeleteDataConnectorRequest;
import com.aliyun.datahub.model.DeleteDataConnectorResult;
import com.aliyun.datahub.model.DeleteProjectRequest;
import com.aliyun.datahub.model.DeleteTopicRequest;
import com.aliyun.datahub.model.GetBlobRecordsRequest;
import com.aliyun.datahub.model.GetBlobRecordsResult;
import com.aliyun.datahub.model.GetCursorRequest;
import com.aliyun.datahub.model.GetCursorResult;
import com.aliyun.datahub.model.GetDataConnectorDoneTimeRequest;
import com.aliyun.datahub.model.GetDataConnectorDoneTimeResult;
import com.aliyun.datahub.model.GetDataConnectorRequest;
import com.aliyun.datahub.model.GetDataConnectorResult;
import com.aliyun.datahub.model.GetDataConnectorShardStatusRequest;
import com.aliyun.datahub.model.GetDataConnectorShardStatusResult;
import com.aliyun.datahub.model.GetMeteringInfoRequest;
import com.aliyun.datahub.model.GetMeteringInfoResult;
import com.aliyun.datahub.model.GetOffsetRequest;
import com.aliyun.datahub.model.GetOffsetResult;
import com.aliyun.datahub.model.GetProjectRequest;
import com.aliyun.datahub.model.GetProjectResult;
import com.aliyun.datahub.model.GetRecordsRequest;
import com.aliyun.datahub.model.GetRecordsResult;
import com.aliyun.datahub.model.GetTopicRequest;
import com.aliyun.datahub.model.GetTopicResult;
import com.aliyun.datahub.model.InitOffsetContextRequest;
import com.aliyun.datahub.model.InitOffsetContextResult;
import com.aliyun.datahub.model.ListDataConnectorRequest;
import com.aliyun.datahub.model.ListDataConnectorResult;
import com.aliyun.datahub.model.ListProjectRequest;
import com.aliyun.datahub.model.ListProjectResult;
import com.aliyun.datahub.model.ListShardRequest;
import com.aliyun.datahub.model.ListShardResult;
import com.aliyun.datahub.model.ListTopicRequest;
import com.aliyun.datahub.model.ListTopicResult;
import com.aliyun.datahub.model.MergeShardRequest;
import com.aliyun.datahub.model.MergeShardResult;
import com.aliyun.datahub.model.OffsetContext;
import com.aliyun.datahub.model.PutBlobRecordsRequest;
import com.aliyun.datahub.model.PutBlobRecordsResult;
import com.aliyun.datahub.model.PutRecordsRequest;
import com.aliyun.datahub.model.PutRecordsResult;
import com.aliyun.datahub.model.RecordEntry;
import com.aliyun.datahub.model.ReloadDataConnectorRequest;
import com.aliyun.datahub.model.ReloadDataConnectorResult;
import com.aliyun.datahub.model.ShardEntry;
import com.aliyun.datahub.model.ShardState;
import com.aliyun.datahub.model.SplitShardRequest;
import com.aliyun.datahub.model.SplitShardResult;
import com.aliyun.datahub.model.UpdateTopicRequest;
import com.aliyun.datahub.model.UpdateTopicResult;
import com.aliyun.datahub.model.serialize.JsonSerializerFactory;
import com.aliyun.datahub.model.serialize.SerializerFactory;
import com.aliyun.datahub.rest.RestClient;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DatahubClient {
    private DatahubConfiguration conf;
    protected SerializerFactory factory;
    protected RestClient restClient;
    private final Long MAX_WAITING_MILLISECOND = 120000L;

    public DatahubClient(DatahubConfiguration conf) {
        this.conf = conf;
        this.factory = JsonSerializerFactory.getInstance();
        this.restClient = conf.newRestClient();
    }

    public DatahubClient(DatahubConfiguration conf, SerializerFactory factory) {
        this.conf = conf;
        this.factory = factory;
        this.restClient = conf.newRestClient();
    }

    public void setAccount(AliyunAccount account) {
        this.restClient.setAccount(account);
    }

    public String getSourceIpForConsole() {
        return this.restClient.getSourceIp();
    }

    public void setSourceIpForConsole(String sourceIp) {
        this.restClient.setSourceIp(sourceIp);
    }

    public boolean getSecureTransportForConsole() {
        return this.restClient.getSecureTransport();
    }

    public void setSecureTransportForConsole(boolean secureTransport) {
        this.restClient.setSecureTransport(secureTransport);
    }

    public GetProjectResult getProject(String projectName) {
        return this.getProject(new GetProjectRequest(projectName));
    }

    public GetProjectResult getProject(GetProjectRequest request) {
        DefaultRequest req = this.factory.getGetProjectRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getGetProjectResultDeser().deserialize(request, response);
    }

    public ListProjectResult listProject() {
        return this.listProject(new ListProjectRequest());
    }

    public ListProjectResult listProject(ListProjectRequest request) {
        DefaultRequest req = this.factory.getListProjectRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getListProjectResultDeser().deserialize(request, response);
    }

    public void waitForShardReady(String projectName, String topicName) {
        this.waitForShardReady(projectName, topicName, 30000L);
    }

    public void waitForShardReady(String projectName, String topicName, long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("invalid timeout value: " + timeout);
        }
        timeout = timeout < this.MAX_WAITING_MILLISECOND ? timeout : this.MAX_WAITING_MILLISECOND;
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while (now < end) {
            try {
                if (this.isShardLoadCompleted(projectName, topicName)) {
                    return;
                }
                Thread.sleep(1000L);
                now = System.currentTimeMillis();
            }
            catch (Exception e) {
                throw new DatahubClientException("sleep");
            }
        }
        if (!this.isShardLoadCompleted(projectName, topicName)) {
            throw new DatahubClientException("wait load shard timeout");
        }
    }

    public void createTopic(String projectName, String topicName, int shardCount, int lifeCycle, RecordType recordType, RecordSchema recordSchema, String desc) {
        this.createTopic(new CreateTopicRequest(projectName, topicName, shardCount, lifeCycle, recordType, recordSchema, desc));
    }

    public void createTopic(String projectName, String topicName, int shardCount, int lifeCycle, RecordType recordType, String desc) {
        this.createTopic(new CreateTopicRequest(projectName, topicName, shardCount, lifeCycle, recordType, null, desc));
    }

    public void createTopic(CreateTopicRequest request) {
        DefaultRequest req = this.factory.getCreateTopicRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        this.factory.getCreateTopicResultDeser().deserialize(request, response);
    }

    public void deleteTopic(String projectName, String topicName) {
        this.deleteTopic(new DeleteTopicRequest(projectName, topicName));
    }

    public void deleteTopic(DeleteTopicRequest request) {
        DefaultRequest req = this.factory.getDeleteTopicRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        this.factory.getDeleteTopicResultDeser().deserialize(request, response);
    }

    public UpdateTopicResult updateTopic(String projectName, String topicName, int lifeCycle, String desc) {
        return this.updateTopic(new UpdateTopicRequest(projectName, topicName, lifeCycle, desc));
    }

    public UpdateTopicResult updateTopic(UpdateTopicRequest request) {
        DefaultRequest req = this.factory.getUpdateTopicRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getUpdateTopicResultDeser().deserialize(request, response);
    }

    public GetTopicResult getTopic(String projectName, String topicName) {
        return this.getTopic(new GetTopicRequest(projectName, topicName));
    }

    public GetTopicResult getTopic(GetTopicRequest request) {
        DefaultRequest req = this.factory.getGetTopicRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getGetTopicResultDeser().deserialize(request, response);
    }

    public ListTopicResult listTopic(String projectName) {
        return this.listTopic(new ListTopicRequest(projectName));
    }

    public ListTopicResult listTopic(ListTopicRequest request) {
        DefaultRequest req = this.factory.getListTopicRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getListTopicResultDeser().deserialize(request, response);
    }

    public ListShardResult listShard(String projectName, String topicName) {
        return this.listShard(new ListShardRequest(projectName, topicName));
    }

    public ListShardResult listShard(ListShardRequest request) {
        DefaultRequest req = this.factory.getListShardRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getListShardResultDeser().deserialize(request, response);
    }

    public SplitShardResult splitShard(String projectName, String topicName, String shardId) {
        String splitKey = null;
        ListShardResult resp = this.listShard(projectName, topicName);
        for (ShardEntry entry : resp.getShards()) {
            if (!shardId.equals(entry.getShardId())) continue;
            splitKey = KeyRangeUtils.trivialSplit(entry.getBeginHashKey(), entry.getEndHashKey());
            break;
        }
        if (splitKey == null) {
            throw new DatahubClientException("Shard Not Exists.");
        }
        return this.splitShard(new SplitShardRequest(projectName, topicName, shardId, splitKey));
    }

    public SplitShardResult splitShard(String projectName, String topicName, String shardId, String splitKey) {
        return this.splitShard(new SplitShardRequest(projectName, topicName, shardId, splitKey));
    }

    public SplitShardResult splitShard(SplitShardRequest request) {
        DefaultRequest req = this.factory.getSplitShardRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getSplitShardResultDeser().deserialize(request, response);
    }

    public MergeShardResult mergeShard(String projectName, String topicName, String shardId, String adjacentShardId) {
        return this.mergeShard(new MergeShardRequest(projectName, topicName, shardId, adjacentShardId));
    }

    public MergeShardResult mergeShard(MergeShardRequest request) {
        DefaultRequest req = this.factory.getMergeShardRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getMergeShardResultDeser().deserialize(request, response);
    }

    public GetCursorResult getCursor(GetCursorRequest request) {
        DefaultRequest req = this.factory.getGetCursorRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getGetCursorResultDeser().deserialize(request, response);
    }

    public GetCursorResult getCursor(String projectName, String topicName, String shardId, long timestamp) {
        GetCursorRequest request = new GetCursorRequest(projectName, topicName, shardId, timestamp);
        return this.getCursor(request);
    }

    public GetCursorResult getCursor(String projectName, String topicName, String shardId, GetCursorRequest.CursorType type) {
        GetCursorRequest request = new GetCursorRequest(projectName, topicName, shardId, type);
        return this.getCursor(request);
    }

    public GetCursorResult getCursor(String projectName, String topicName, String shardId, GetCursorRequest.CursorType type, long param) {
        GetCursorRequest request = new GetCursorRequest(projectName, topicName, shardId, type, param);
        return this.getCursor(request);
    }

    public GetCursorResult getNextOffsetCursor(OffsetContext offsetCtx) {
        GetCursorRequest request = new GetCursorRequest(offsetCtx.getProject(), offsetCtx.getTopic(), offsetCtx.getShardId(), GetCursorRequest.CursorType.SEQUENCE, offsetCtx.getOffset().getSequence() + 1L);
        return this.getCursor(request);
    }

    public GetCursorResult getCurrentOffsetCursor(OffsetContext offsetCtx) {
        GetCursorRequest request = new GetCursorRequest(offsetCtx.getProject(), offsetCtx.getTopic(), offsetCtx.getShardId(), GetCursorRequest.CursorType.SEQUENCE, offsetCtx.getOffset().getSequence());
        return this.getCursor(request);
    }

    public GetRecordsResult getRecords(GetRecordsRequest request) {
        DefaultRequest req = this.factory.getGetRecordsRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getGetRecordsResultDeser().deserialize(request, response);
    }

    public GetRecordsResult getRecords(String projectName, String topicName, String shardId, String cursor, int limit, RecordSchema schema) {
        GetRecordsRequest request = new GetRecordsRequest(projectName, topicName, shardId, cursor, limit);
        request.setSchema(schema);
        return this.getRecords(request);
    }

    public GetBlobRecordsResult getBlobRecords(String projectName, String topicName, String shardId, String cursor, int limit) {
        GetBlobRecordsRequest request = new GetBlobRecordsRequest(projectName, topicName, shardId, cursor, limit);
        return this.getBlobRecords(request);
    }

    public GetBlobRecordsResult getBlobRecords(GetBlobRecordsRequest request) {
        DefaultRequest req = this.factory.getGetBlobRecordsRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getGetBlobRecordsResultDeser().deserialize(request, response);
    }

    public PutRecordsResult putRecords(String projectName, String topicName, List<RecordEntry> entries, int retries) {
        PutRecordsResult result = this.putRecords(projectName, topicName, entries);
        for (int i = 0; i < retries; ++i) {
            if (result.getFailedRecordCount() == 0) {
                return result;
            }
            result = this.putRecords(projectName, topicName, result.getFailedRecords());
        }
        return result;
    }

    public PutRecordsResult putRecords(String projectName, String topicName, List<RecordEntry> entries) {
        return this.putRecords(new PutRecordsRequest(projectName, topicName, entries));
    }

    public PutRecordsResult putRecords(PutRecordsRequest request) {
        DefaultRequest req = this.factory.getPutRecordsRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        PutRecordsResult rs = this.factory.getPutRecordsResultDeser().deserialize(request, response);
        List<RecordEntry> records = request.getRecords();
        for (int i : rs.getFailedRecordIndex()) {
            rs.addFailedRecord(records.get(i));
        }
        return rs;
    }

    public PutBlobRecordsResult putBlobRecords(String projectName, String topicName, List<BlobRecordEntry> entries, int retries) {
        PutBlobRecordsResult result = this.putBlobRecords(projectName, topicName, entries);
        for (int i = 0; i < retries; ++i) {
            if (result.getFailedRecordCount() == 0) {
                return result;
            }
            result = this.putBlobRecords(projectName, topicName, result.getFailedRecords());
        }
        return result;
    }

    public PutBlobRecordsResult putBlobRecords(String projectName, String topicName, List<BlobRecordEntry> entries) {
        return this.putBlobRecords(new PutBlobRecordsRequest(projectName, topicName, entries));
    }

    public PutBlobRecordsResult putBlobRecords(PutBlobRecordsRequest request) {
        DefaultRequest req = this.factory.getPutBlobRecordsRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        PutBlobRecordsResult rs = this.factory.getPutBlobRecordsResultDeser().deserialize(request, response);
        List<BlobRecordEntry> records = request.getRecords();
        for (int i : rs.getFailedRecordIndex()) {
            rs.addFailedRecord(records.get(i));
        }
        return rs;
    }

    public void createProject(String projectName, String desc) {
        this.createProject(new CreateProjectRequest(projectName, desc));
    }

    public void createProject(CreateProjectRequest request) {
        DefaultRequest req = this.factory.getCreateProjectRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        this.factory.getCreateProjectResultDeser().deserialize(request, response);
    }

    public void deleteProject(String projectName) {
        this.deleteProject(new DeleteProjectRequest(projectName));
    }

    public void deleteProject(DeleteProjectRequest request) {
        DefaultRequest req = this.factory.getDeleteProjectRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        this.factory.getDeleteProjectResultDeser().deserialize(request, response);
    }

    public AppendFieldResult appendField(AppendFieldRequest request) {
        DefaultRequest req = this.factory.getAppendFieldRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getAppendFieldResultDeser().deserialize(request, response);
    }

    public GetMeteringInfoResult getMeteringInfo(GetMeteringInfoRequest request) {
        DefaultRequest req = this.factory.getGetMeteringInfoRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getGetMeteringInfoResultDeser().deserialize(request, response);
    }

    public ListDataConnectorResult listDataConnector(String projectName, String topicName) {
        return this.listDataConnector(new ListDataConnectorRequest(projectName, topicName));
    }

    public ListDataConnectorResult listDataConnector(ListDataConnectorRequest request) {
        DefaultRequest req = this.factory.getListDataConnectorRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getListDataConnectorResultDeser().deserialize(request, response);
    }

    public CreateDataConnectorResult createDataConnector(String projectName, String topicName, ConnectorType connectorType, List<String> columnFields, ConnectorConfig config) {
        return this.createDataConnector(new CreateDataConnectorRequest(projectName, topicName, connectorType, columnFields, config));
    }

    public CreateDataConnectorResult createDataConnector(String projectName, String topicName, ConnectorType connectorType, ConnectorConfig config) {
        return this.createDataConnector(new CreateDataConnectorRequest(projectName, topicName, connectorType, config));
    }

    public CreateDataConnectorResult createDataConnector(CreateDataConnectorRequest request) {
        DefaultRequest req = this.factory.getCreateDataConnectorRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getCreateDataConnectorResultDeser().deserialize(request, response);
    }

    public GetDataConnectorResult getDataConnector(String projectName, String topicName, ConnectorType connectorType) {
        return this.getDataConnector(new GetDataConnectorRequest(projectName, topicName, connectorType));
    }

    public GetDataConnectorResult getDataConnector(GetDataConnectorRequest request) {
        DefaultRequest req = this.factory.getGetDataConnectorRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getGetDataConnectorResultDeser().deserialize(request, response);
    }

    public GetDataConnectorDoneTimeResult getDataConnectorDoneTime(GetDataConnectorDoneTimeRequest request) {
        DefaultRequest req = this.factory.getGetDataConnectorDoneTimeRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getGetDataConnectorDoneTimeResultDeser().deserialize(request, response);
    }

    public DeleteDataConnectorResult deleteDataConnector(String projectName, String topicName, ConnectorType connectorType) {
        return this.deleteDataConnector(new DeleteDataConnectorRequest(projectName, topicName, connectorType));
    }

    public DeleteDataConnectorResult deleteDataConnector(DeleteDataConnectorRequest request) {
        DefaultRequest req = this.factory.getDeleteDataConnectorRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getDeleteDataConnectorResultDeser().deserialize(request, response);
    }

    public ReloadDataConnectorResult reloadDataConnector(ReloadDataConnectorRequest request) {
        DefaultRequest req = this.factory.getReloadDataConnectorRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getReloadDataConnectorResultDeser().deserialize(request, response);
    }

    public ReloadDataConnectorResult reloadDataConnector(String projectName, String topicName, ConnectorType connectorType, String shardId) {
        return this.reloadDataConnector(new ReloadDataConnectorRequest(projectName, topicName, connectorType, shardId));
    }

    public ReloadDataConnectorResult reloadDataConnector(String projectName, String topicName, ConnectorType connectorType) {
        return this.reloadDataConnector(new ReloadDataConnectorRequest(projectName, topicName, connectorType));
    }

    public GetDataConnectorShardStatusResult getDataConnectorShardStatus(String projectName, String topicName, ConnectorType connectorType, String shardId) {
        return this.getDataConnectorShardStatus(new GetDataConnectorShardStatusRequest(projectName, topicName, connectorType, shardId));
    }

    public GetDataConnectorShardStatusResult getDataConnectorShardStatus(GetDataConnectorShardStatusRequest request) {
        DefaultRequest req = this.factory.getGetDataConnectorShardStatusRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getGetDataConnectorShardStatusResultDeser().deserialize(request, response);
    }

    public AppendDataConnectorFieldResult appendDataConnectorField(AppendDataConnectorFieldRequest request) {
        DefaultRequest req = this.factory.getAppendDataConnectorFieldRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getAppendDataConnectorFieldResultDeser().deserialize(request, response);
    }

    public InitOffsetContextResult initOffsetContext(String project, String topic, String subId, Set<String> shardIds) {
        return this.initOffsetContext(new InitOffsetContextRequest(project, topic, subId, shardIds));
    }

    public OffsetContext initOffsetContext(String project, String topic, String subId, String shardId) {
        HashSet<String> shardIds = new HashSet<String>();
        shardIds.add(shardId);
        InitOffsetContextResult result = this.initOffsetContext(new InitOffsetContextRequest(project, topic, subId, shardIds));
        return result.getOffsets().get(shardId);
    }

    public InitOffsetContextResult initOffsetContext(InitOffsetContextRequest request) {
        DefaultRequest req = this.factory.getInitOffsetContextRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getInitOffsetContextResultDerser().deserialize(request, response);
    }

    public void updateOffsetContext(OffsetContext offsetCtx) {
        HashSet<String> shardIds = new HashSet<String>();
        shardIds.add(offsetCtx.getShardId());
        GetOffsetRequest request = new GetOffsetRequest(offsetCtx.getProject(), offsetCtx.getTopic(), offsetCtx.getSubId(), shardIds);
        DefaultRequest req = this.factory.getGetOffsetRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        GetOffsetResult result = this.factory.getGetOffsetResultDeser().deserialize(request, response);
        offsetCtx.setOffset(result.getOffsets().get(offsetCtx.getShardId()));
        offsetCtx.setVersion(result.getVersions().get(offsetCtx.getShardId()));
    }

    public CommitOffsetResult commitOffset(OffsetContext offsetCtx) {
        HashMap<String, OffsetContext> offsetCtxMap = new HashMap<String, OffsetContext>();
        offsetCtxMap.put(offsetCtx.getShardId(), offsetCtx);
        return this.commitOffset(new CommitOffsetRequest(offsetCtxMap));
    }

    public CommitOffsetResult commitOffset(Map<String, OffsetContext> offsetCtxMap) {
        return this.commitOffset(new CommitOffsetRequest(offsetCtxMap));
    }

    public CommitOffsetResult commitOffset(CommitOffsetRequest request) {
        DefaultRequest req = this.factory.getCommitOffsetRequestSer().serialize(request);
        Response response = this.restClient.requestWithNoRetry(req);
        return this.factory.getCommitOffsetResultDeser().deserialize(request, response);
    }

    public void close() {
        this.restClient.close();
    }

    private boolean isShardLoadCompleted(String projectName, String topicName) {
        try {
            ListShardResult result = this.listShard(projectName, topicName);
            List<ShardEntry> shards = result.getShards();
            for (ShardEntry shard : shards) {
                if (shard.getState() == ShardState.ACTIVE || shard.getState() == ShardState.CLOSED) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

