/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.common.transport;

import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.common.transport.Connection;
import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.DefaultResponse;
import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.transport.Transport;
import com.aliyun.datahub.exception.DatahubClientException;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;

public class JerseyTransport
implements Transport {
    private static final Logger log = Logger.getLogger(JerseyTransport.class.getName());
    private JerseyClient jerseyClient;
    private DatahubConfiguration conf;

    public JerseyTransport(DatahubConfiguration conf) {
        this.conf = conf;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        clientConfig.property("jersey.config.client.readTimeout", (Object)(conf.getSocketTimeout() * 1000));
        clientConfig.property("jersey.config.client.connectTimeout", (Object)(conf.getSocketConnectTimeout() * 1000));
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(conf.getTotalConnections());
        connectionManager.setDefaultMaxPerRoute(conf.getConnectionsPerEndpoint());
        clientConfig.property("jersey.config.apache.client.connectionManager", (Object)connectionManager);
        clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        this.jerseyClient = JerseyClientBuilder.createClient((Configuration)clientConfig);
    }

    @Override
    public Response request(DefaultRequest req, String endpoint) throws IOException {
        String dhEndpoint = this.conf.getEndpoint();
        if (endpoint != null && !endpoint.isEmpty()) {
            dhEndpoint = endpoint;
        }
        String url = dhEndpoint + req.getResource();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Connectiong to " + url);
        }
        JerseyInvocation.Builder builder = this.jerseyClient.target(url).request();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Request headers: " + req.getHeaders().toString());
        }
        for (Map.Entry<String, String> entry : req.getHeaders().entrySet()) {
            if (entry.getKey().equals("Content-Length")) continue;
            builder.header(entry.getKey(), (Object)entry.getValue());
        }
        javax.ws.rs.core.Response resp = null;
        switch (req.getHttpMethod()) {
            case POST: {
                resp = builder.post(Entity.entity((Object)req.getBody(), (Variant)new Variant(MediaType.APPLICATION_JSON_TYPE, (String)null, req.getHeaders().get("Content-Encoding"))));
                break;
            }
            case PUT: {
                resp = builder.put(Entity.entity((Object)req.getBody(), (Variant)new Variant(MediaType.APPLICATION_JSON_TYPE, (String)null, req.getHeaders().get("Content-Encoding"))));
                break;
            }
            case GET: {
                resp = builder.get();
                break;
            }
            case DELETE: {
                resp = builder.delete();
                break;
            }
            case HEAD: {
                resp = builder.head();
            }
        }
        if (resp == null) {
            throw new IOException("request to server failed");
        }
        DefaultResponse response = new DefaultResponse();
        response.setStatus(resp.getStatus());
        for (String key : resp.getHeaders().keySet()) {
            response.setHeader(key, resp.getHeaderString(key));
        }
        response.setBody((byte[])resp.readEntity(byte[].class));
        resp.close();
        return response;
    }

    @Override
    public Response request(DefaultRequest req) throws IOException {
        return this.request(req, null);
    }

    @Override
    public Connection connect(DefaultRequest req) throws IOException {
        throw new DatahubClientException("not implemented");
    }

    @Override
    public void close() {
        this.jerseyClient.close();
    }
}

