/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model;

import com.aliyun.datahub.common.util.JacksonParser;
import java.security.InvalidParameterException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class OffsetContext {
    private String project;
    private String topic;
    private String subId;
    private String shardId;
    private Offset offset;
    private long version;
    private String sessionId;

    public OffsetContext(String project, String topic, String subId, String shardId, Offset offset, long version, String sessionId) {
        if (project == null) {
            throw new InvalidParameterException("project name is null");
        }
        if (topic == null) {
            throw new InvalidParameterException("topic name is null");
        }
        if (subId == null) {
            throw new InvalidParameterException("sub id is null");
        }
        if (shardId == null) {
            throw new InvalidParameterException("shard id is null");
        }
        if (sessionId == null) {
            throw new InvalidParameterException("session id is null");
        }
        this.project = project;
        this.topic = topic;
        this.subId = subId;
        this.shardId = shardId;
        this.offset = offset;
        this.version = version;
        this.sessionId = sessionId;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public String getProject() {
        return this.project;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSubId() {
        return this.subId;
    }

    public String getShardId() {
        return this.shardId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean hasOffset() {
        return this.offset == null ? false : (this.offset.sequence < 0L ? false : this.offset.sequence != 0L || this.offset.timestamp != 0L);
    }

    public ObjectNode toObjectNode() {
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("Project", this.project);
        node.put("Topic", this.topic);
        node.put("SubId", this.subId);
        node.put("ShardId", this.shardId);
        node.put("Sequence", this.offset.sequence);
        node.put("Timestamp", this.offset.timestamp);
        node.put("Version", this.version);
        node.put("SessionId", this.sessionId);
        return node;
    }

    public static class Offset {
        private long sequence;
        private long timestamp;

        public Offset(long seq, long ts) {
            this.sequence = seq;
            this.timestamp = ts;
        }

        public long getSequence() {
            return this.sequence;
        }

        public void setSequence(long sequence) {
            this.sequence = sequence;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

