/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.ConnectorConfig;
import com.aliyun.datahub.model.ConnectorType;
import com.aliyun.datahub.model.DatabaseDesc;
import com.aliyun.datahub.model.DatahubDesc;
import com.aliyun.datahub.model.ElasticSearchDesc;
import com.aliyun.datahub.model.FcDesc;
import com.aliyun.datahub.model.GetDataConnectorRequest;
import com.aliyun.datahub.model.GetDataConnectorResult;
import com.aliyun.datahub.model.OdpsDesc;
import com.aliyun.datahub.model.OssDesc;
import com.aliyun.datahub.model.OtsDesc;
import com.aliyun.datahub.model.ShardContext;
import com.aliyun.datahub.model.serialize.Deserializer;
import com.aliyun.datahub.model.serialize.JsonErrorParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class GetDataConnectorResultJsonDeser
implements Deserializer<GetDataConnectorResult, GetDataConnectorRequest, Response> {
    private static GetDataConnectorResultJsonDeser instance;

    @Override
    public GetDataConnectorResult deserialize(GetDataConnectorRequest request, Response response) throws DatahubServiceException {
        ConnectorConfig config;
        if (!response.isOK()) {
            throw JsonErrorParser.getInstance().parse(response);
        }
        GetDataConnectorResult rs = new GetDataConnectorResult();
        ByteArrayInputStream is = new ByteArrayInputStream(response.getBody());
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        JsonNode tree = null;
        try {
            tree = mapper.readTree((InputStream)is);
        }
        catch (IOException e) {
            throw new DatahubServiceException("JsonParseError", "Parse body failed:" + response.getBody(), response);
        }
        ArrayList<String> columnFields = new ArrayList<String>();
        JsonNode node = tree.get("ColumnFields");
        if (node != null && !node.isNull() && node.isArray()) {
            Iterator it = node.getElements();
            while (it.hasNext()) {
                JsonNode field = (JsonNode)it.next();
                columnFields.add(field.asText());
            }
        }
        rs.setColumnFields(columnFields);
        node = tree.get("Type");
        if (node != null && !node.isNull()) {
            rs.setType(node.asText());
        }
        if ((node = tree.get("State")) != null && !node.isNull()) {
            rs.setState(node.asText());
        }
        if ((node = tree.get("Creator")) != null && !node.isNull()) {
            rs.setCreator(node.asText());
        }
        if ((node = tree.get("Owner")) != null && !node.isNull()) {
            rs.setOwner(node.asText());
        }
        node = tree.get("Config");
        if (rs.getType() == ConnectorType.SINK_ODPS) {
            config = new OdpsDesc();
            config.ParseFromJsonNode(node);
        } else if (rs.getType() == ConnectorType.SINK_ES) {
            config = new ElasticSearchDesc();
            config.ParseFromJsonNode(node);
        } else if (rs.getType() == ConnectorType.SINK_DATAHUB) {
            config = new DatahubDesc();
            config.ParseFromJsonNode(node);
        } else if (rs.getType() == ConnectorType.SINK_OSS) {
            config = new OssDesc();
            config.ParseFromJsonNode(node);
        } else if (rs.getType() == ConnectorType.SINK_ADS || rs.getType() == ConnectorType.SINK_MYSQL) {
            config = new DatabaseDesc();
            config.ParseFromJsonNode(node);
        } else if (rs.getType() == ConnectorType.SINK_FC) {
            config = new FcDesc();
            config.ParseFromJsonNode(node);
        } else if (rs.getType() == ConnectorType.SINK_OTS) {
            config = new OtsDesc();
            config.ParseFromJsonNode(node);
        } else {
            throw new DatahubClientException("Invalid response, missing 'config'");
        }
        rs.setConnectorConfig(config);
        ArrayList<ShardContext> shardContexts = new ArrayList<ShardContext>();
        node = tree.get("ShardContexts");
        if (node != null && !node.isNull() && node.isArray()) {
            Iterator it = node.getElements();
            while (it.hasNext()) {
                ShardContext shardContext = new ShardContext();
                JsonNode jsonNode = (JsonNode)it.next();
                JsonNode context = jsonNode.get("ShardId");
                if (context != null && !context.isNull()) {
                    shardContext.setShardId(context.asText());
                }
                if ((context = jsonNode.get("StartSequence")) != null && !context.isNull()) {
                    shardContext.setStartSequence(context.asLong());
                }
                if ((context = jsonNode.get("EndSequence")) != null && !context.isNull()) {
                    shardContext.setEndSequence(context.asLong());
                }
                if ((context = jsonNode.get("CurrentSequence")) != null && !context.isNull()) {
                    shardContext.setCurSequence(context.asLong());
                }
                shardContexts.add(shardContext);
            }
            rs.setShardContext(shardContexts);
        }
        return rs;
    }

    private GetDataConnectorResultJsonDeser() {
    }

    public static GetDataConnectorResultJsonDeser getInstance() {
        if (instance == null) {
            instance = new GetDataConnectorResultJsonDeser();
        }
        return instance;
    }
}

