/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.UpdateSubscriptionRequest;
import com.aliyun.datahub.model.serialize.Serializer;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class UpdateSubscriptionRequestJsonSer
implements Serializer<DefaultRequest, UpdateSubscriptionRequest> {
    private static UpdateSubscriptionRequestJsonSer instance;

    @Override
    public DefaultRequest serialize(UpdateSubscriptionRequest request) throws DatahubClientException {
        DefaultRequest req = new DefaultRequest();
        req.setHttpMethod(HttpMethod.PUT);
        req.setResource("/projects/" + request.getProjectName() + "/topics/" + request.getTopicName() + "/subscriptions/" + request.getSubId());
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        try {
            ObjectNode node = mapper.createObjectNode();
            node.put("Comment", request.getComment());
            req.setBody(mapper.writeValueAsString((Object)node));
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return req;
    }

    private UpdateSubscriptionRequestJsonSer() {
    }

    public static UpdateSubscriptionRequestJsonSer getInstance() {
        if (instance == null) {
            instance = new UpdateSubscriptionRequestJsonSer();
        }
        return instance;
    }
}

