/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.impl;

import com.aliyun.drc.client.DataFilter;
import com.aliyun.drc.client.impl.Checkpoint;
import com.aliyun.drc.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DRCConfig {
    private final Map<String, String> configures = new HashMap<String, String>();
    private final Map<String, String> userDefinedParams = new HashMap<String, String>();
    private final Set<String> persists;
    private Checkpoint checkpoint;
    private DataFilter filter;
    private String blackList;
    private int recordsPerBatch = 0;
    private int maxRetryTimes = 100;
    private int socketTimeout = 120;
    private int connectionTimeout = 120;
    private boolean useBinaryFormat = false;
    private boolean txnMark = true;
    private boolean requireCompleteTxn = false;
    private int maxRecordsCached = 10240;
    private int maxRecordsBatched = 1024;
    private int maxTxnsBatched = 10240;
    private long maxTimeoutBatched = 500L;
    private boolean drcMarkWorking = false;
    private boolean usePublicIp = false;
    private String guid;
    private boolean useCaseSensitive = false;
    private boolean trimLongType = false;
    private static final String DRC_VERSION = "version";
    private static final String DRC_MANAGERHOST = "manager.host";
    private static final String HTTPS_USE = "client.https";
    private static final String DRC_BINLOGLOGNAME = "DRCClient.Binlog";
    private static final String DRC_CHECKPOINT_POLLPERIOD = "checkpoint.period";
    private static final String SERVER_MAX_RETRIES = "server.maxRetriedTimes";
    private static final String SERVER_MESSAGE_TYPE = "server.messageType";
    private static final String CLIENT_SO_TIMEOUT = "client.socketTimeout";
    private static final String CLIENT_CONN_TIMEOUT = "client.connectionTimeout";
    private static final String CLIENT_REQ_COMP_TXN = "client.requireCompleteTxn";
    private static final String CLIENT_MAX_RECS_CACHE = "client.maxNumOfRecordsCached";
    private static final String CLIENT_MAX_RECS_BATCH = "client.maxNumOfRecordsPerMessage";
    private static final String CLIENT_MAX_TXNS_BATCH = "client.maxNumOfTxnsPerMessage";
    private static final String CLIENT_MAX_TIMEOUT_BATCH = "client.maxTimeoutPerMessage";
    private static final String USER_FILTERCONDITIONS = "condition";
    private static final String USER_CHECKPOINT = "checkpoint";
    private static final String USER_DBNAME = "dbname";
    private static final String USER_GROUPNAME = "groupname";
    private static final String USER_IDENTIFICATION = "password";
    private static final String USER_GROUP = "group";
    private static final String USER_SUBGROUP = "subgroup";
    private static final String USER_MYSQL = "instance";
    private static final String DRC_MARK = "drcMark";
    private static final String DRC_GUID = "guid";
    private static final String DEFAULT_DRC_MARK = "drc.t*x_begin4unit_mark_[0-9]*";
    private static final String IPMAPS = "ipmaps";
    @Deprecated
    private static final String USER_FILTERSTRICT = "strict";
    @Deprecated
    private static final String USER_FILTERWHERE = "where";
    public static final String POSITION_INFO = "Global_position_info:";
    private static Map<String, String> ipportMaps;

    private DRCConfig() {
        this.userDefinedParams.put(DRC_MARK, DEFAULT_DRC_MARK);
        this.persists = new HashSet<String>();
        this.configures.put(DRC_VERSION, "2.0.0");
        this.configures.put(DRC_CHECKPOINT_POLLPERIOD, "500");
        this.configures.put(CLIENT_SO_TIMEOUT, "120");
        this.configures.put(CLIENT_CONN_TIMEOUT, "120");
        this.checkpoint = new Checkpoint();
        ipportMaps = new HashMap<String, String>();
    }

    public DRCConfig(Reader reader) throws IOException {
        this();
        Properties properties = new Properties();
        properties.load(reader);
        this.loadProperties(properties);
    }

    public DRCConfig(String propertiesFile) throws IOException {
        this();
        InputStream drcProperties = this.getClass().getClassLoader().getResourceAsStream(propertiesFile);
        Properties properties = new Properties();
        properties.load(drcProperties);
        this.loadProperties(properties);
    }

    public DRCConfig(Properties properties) {
        this();
        this.loadProperties(properties);
    }

    private void loadProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey().equals(SERVER_MAX_RETRIES)) {
                this.maxRetryTimes = Integer.parseInt((String)entry.getValue());
            } else if (entry.getKey().equals(CLIENT_SO_TIMEOUT)) {
                this.socketTimeout = Integer.parseInt((String)entry.getValue());
            } else if (entry.getKey().equals(CLIENT_CONN_TIMEOUT)) {
                this.connectionTimeout = Integer.parseInt((String)entry.getValue());
            } else if (entry.getKey().equals(SERVER_MESSAGE_TYPE)) {
                this.useBinaryFormat = ((String)entry.getValue()).equals("binary");
            } else if (entry.getKey().equals(CLIENT_REQ_COMP_TXN)) {
                this.requireCompleteTxn = ((String)entry.getValue()).equals("true");
            } else if (entry.getKey().equals(CLIENT_MAX_RECS_BATCH)) {
                this.maxRecordsBatched = Integer.parseInt((String)entry.getValue());
            } else if (entry.getKey().equals(CLIENT_MAX_TIMEOUT_BATCH)) {
                this.maxTimeoutBatched = Long.parseLong((String)entry.getValue());
            } else if (entry.getKey().equals(CLIENT_MAX_TXNS_BATCH)) {
                this.maxTxnsBatched = Integer.parseInt((String)entry.getValue());
            } else if (entry.getKey().equals(CLIENT_MAX_RECS_CACHE)) {
                this.maxRecordsCached = Integer.parseInt((String)entry.getValue());
            } else if (entry.getKey().equals(IPMAPS)) {
                String[] ipmaps;
                for (String ippair : ipmaps = StringUtils.split((String)entry.getValue(), '|')) {
                    String[] ips = StringUtils.split(ippair, '-');
                    if (ips.length != 2) continue;
                    ipportMaps.put(ips[0], ips[1]);
                }
            } else if (entry.getKey().equals(DRC_GUID)) {
                this.guid = (String)entry.getValue();
            }
            this.configures.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setDataFilter(DataFilter filter) {
        this.filter = filter;
    }

    public DataFilter getDataFilter() {
        return this.filter;
    }

    public Checkpoint getCheckpoint() {
        return this.checkpoint;
    }

    public int getMaxRetriedTimes() {
        return this.maxRetryTimes;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getGuid() {
        return this.guid;
    }

    final String getGroupName() {
        return this.userDefinedParams.get(USER_GROUPNAME);
    }

    final void setGroupName(String groupName) {
        this.userDefinedParams.put(USER_GROUPNAME, groupName);
    }

    final String getGroup() {
        String group = this.userDefinedParams.get(USER_GROUP);
        if (group == null || group.isEmpty()) {
            return this.getGroupName();
        }
        return group;
    }

    final void setGroup(String group) {
        this.userDefinedParams.put(USER_GROUP, group);
    }

    final void setDbname(String dbname) {
        this.userDefinedParams.put(USER_DBNAME, dbname);
    }

    final void setSubGroup(String subgroup) {
        this.userDefinedParams.put(USER_SUBGROUP, subgroup);
    }

    final String getSubGroup() {
        String subgroup = this.userDefinedParams.get(USER_SUBGROUP);
        if (subgroup == null || subgroup.isEmpty()) {
            return this.getDbname();
        }
        return subgroup;
    }

    final String getDbname() {
        return this.userDefinedParams.get(USER_DBNAME);
    }

    final void setIdentification(String id) {
        this.userDefinedParams.put(USER_IDENTIFICATION, id);
    }

    final void setBinlogFilename(String filename) {
        this.configures.put(DRC_BINLOGLOGNAME, filename);
    }

    final String getIdentification() {
        return this.userDefinedParams.get(USER_IDENTIFICATION);
    }

    final String getBinlogFilename() {
        return this.configures.get(DRC_BINLOGLOGNAME);
    }

    final int getCheckpointPeriod() {
        return Integer.parseInt(this.configures.get(DRC_CHECKPOINT_POLLPERIOD));
    }

    final void setCheckpoint(Checkpoint checkpoint) {
        this.checkpoint = checkpoint;
    }

    final void setCheckpoint(String checkpoint) {
        this.checkpoint.setPosition(checkpoint);
    }

    final void setGmtModified(String timestamp) {
        this.checkpoint.setTimestamp(timestamp);
    }

    final void setStartingPoint(String startingPoint) {
        if (startingPoint.contains("@")) {
            this.setCheckpoint(startingPoint);
        } else {
            if (startingPoint.length() == 13) {
                throw new IllegalArgumentException("Error the unit of the starting time is second, but " + startingPoint + " is in ms");
            }
            this.setGmtModified(startingPoint);
        }
    }

    final String getVersion() {
        return this.configures.get(DRC_VERSION);
    }

    final String getClusterManagerAddresses() {
        return this.configures.get(DRC_MANAGERHOST);
    }

    final void setInstance(String mysql) {
        this.userDefinedParams.put(USER_MYSQL, mysql);
        this.checkpoint.setServerId(mysql);
    }

    final String getInstance() {
        return this.userDefinedParams.get(USER_MYSQL);
    }

    final void addParam(String key, String value) {
        this.userDefinedParams.put(key, value);
    }

    final String getParam(String key) {
        return this.userDefinedParams.get(key);
    }

    final Map<String, String> getParams() {
        return this.userDefinedParams;
    }

    final void addConfigure(String key, String value) {
        this.configures.put(key, value);
    }

    final String getConfigure(String key) {
        return this.configures.get(key);
    }

    final Map<String, String> getConfigures() {
        return this.configures;
    }

    final Set<String> getPersists() {
        return this.persists;
    }

    final void addPersists(List<String> p) {
        this.persists.addAll(p);
    }

    final void setRequiredTablesAndColumns(String conditions) {
        this.userDefinedParams.put(USER_FILTERCONDITIONS, conditions);
    }

    final void setWhereFilters(String where) {
        this.userDefinedParams.put(USER_FILTERWHERE, where);
    }

    final void setFilterUnchangedRecords() {
        this.userDefinedParams.put(USER_FILTERSTRICT, "true");
    }

    public void setDRCMark(String mark) {
        this.userDefinedParams.put(DRC_MARK, mark);
    }

    public String getDRCMark() {
        return this.userDefinedParams.get(DRC_MARK);
    }

    final boolean isDrcClientConfigReady() {
        boolean ready = true;
        if (this.configures.get(DRC_MANAGERHOST) == null) {
            System.err.println("Configure server address not ready");
            ready = false;
        }
        return ready;
    }

    final void requireTxnMark(boolean need) {
        this.txnMark = need;
    }

    final boolean isTxnMarkRequired() {
        return this.txnMark;
    }

    final boolean isBinaryFormat() {
        return this.useBinaryFormat;
    }

    public void setNumOfRecordsPerBatch(int threshold) {
        this.recordsPerBatch = threshold;
    }

    public int getNumOfRecordsPerBatch() {
        return this.recordsPerBatch;
    }

    public boolean isTxnRequiredCompleted() {
        return this.requireCompleteTxn;
    }

    public int getMaxRecordsPerTxn() {
        return this.maxRecordsCached;
    }

    public int getMaxRecordsBatched() {
        return this.maxRecordsBatched;
    }

    public long getMaxTimeoutBatched() {
        return this.maxTimeoutBatched;
    }

    public int getMaxTxnsBatched() {
        return this.maxTxnsBatched;
    }

    public final String getMappedIpPort(String ip) {
        return ipportMaps.get(ip);
    }

    public void useDrcMark() {
        this.drcMarkWorking = true;
    }

    public boolean isDrcMarkWorking() {
        return this.drcMarkWorking;
    }

    public String getBlackList() {
        return this.blackList;
    }

    public void setBlackList(String blackList) {
        this.blackList = blackList;
    }

    public boolean getUseHTTPS() {
        String use = this.configures.get(HTTPS_USE);
        return use != null && !use.equals("false");
    }

    public void usePublicIp() {
        this.usePublicIp = true;
    }

    public boolean isUsePublicIp() {
        return this.usePublicIp;
    }

    public void useCaseSensitive() {
        this.useCaseSensitive = true;
    }

    public boolean isUseCaseSensitive() {
        return this.useCaseSensitive;
    }

    public void trimLongType() {
        this.trimLongType = true;
    }

    public boolean isTrimLongType() {
        return this.trimLongType;
    }
}

