/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.impl;

import com.aliyun.drc.client.DRCClientException;
import com.aliyun.drc.client.HttpBadResponseException;
import com.aliyun.drc.client.impl.Checkpoint;
import com.aliyun.drc.client.impl.DRCConfig;
import com.aliyun.drc.client.impl.HttpHandler;
import com.aliyun.drc.client.impl.StoreResp;
import com.aliyun.drc.client.impl.TokenResp;
import com.aliyun.drc.client.impl.TopicsResp;
import com.aliyun.drc.client.impl.TypeResp;
import com.aliyun.drc.client.message.Message;
import com.aliyun.drc.utils.NetUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

class ServerProxy {
    private String url;
    private HttpHandler handler;
    private final Queue<Message> priorMessages;

    ServerProxy(String url, DRCConfig drcConfig) {
        this.url = url;
        this.handler = new HttpHandler(this.url, drcConfig.getUseHTTPS());
        this.priorMessages = new LinkedList<Message>();
    }

    void setSocketTimeout(int timeout) {
        this.handler.setSocketTimeout(timeout);
    }

    void setConnectionTimeout(int timeout) {
        this.handler.setConnectionTimeout(timeout);
    }

    final void addParam(String key, String value) {
        this.handler.addFormParam(key, value);
    }

    final void addParams(Map<String, String> props) {
        for (Map.Entry<String, String> kv : props.entrySet()) {
            this.addParam(kv.getKey(), kv.getValue());
        }
    }

    final boolean hasRequired(String parameterName) {
        boolean found = false;
        for (NameValuePair param : this.handler.getFormParams()) {
            if (!param.getName().equalsIgnoreCase(parameterName)) continue;
            found = true;
        }
        return found;
    }

    final String getUrl() {
        return this.url;
    }

    final void sendRequest(boolean decorated) throws HttpBadResponseException, IOException {
        try {
            if (decorated) {
                this.handler.sendEncodedRequest();
            } else {
                this.handler.sendPlainRequest();
            }
        }
        catch (HttpBadResponseException he) {
            throw he;
        }
        catch (IOException e) {
            throw e;
        }
    }

    final Message getResponse(boolean usebinary) throws IOException, DRCClientException {
        Message priorMessage = this.priorMessages.poll();
        if (priorMessage != null) {
            return priorMessage;
        }
        priorMessage = usebinary ? this.handler.recvDRCPBinaryResponse() : this.handler.recvDRCPResponse();
        if (priorMessage == null) {
            throw new DRCClientException("Get null message, server may shutdown.");
        }
        return priorMessage;
    }

    final boolean setResponse(Message message) {
        return this.priorMessages.offer(message);
    }

    public static final boolean askIfCm(String url, DRCConfig drcConfig) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/status.taobao";
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        try {
            CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
            BufferedReader reader = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));
            String line = reader.readLine();
            client.close();
            if (line.equals("success & ok")) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static final TokenResp askToken(String url, String consumer, String password, DRCConfig drcConfig) throws ClientProtocolException, IOException, HttpBadResponseException, DRCClientException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/auth?consumer=" + consumer + "&password=" + password;
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
        ObjectMapper mapper = new ObjectMapper();
        TokenResp response = (TokenResp)mapper.readValue(resp.getEntity().getContent(), TokenResp.class);
        client.close();
        if (!response.getIsSuccess().booleanValue()) {
            throw new DRCClientException(response.getErrCode() + ":" + response.getErrMsg());
        }
        return response;
    }

    public static final TopicsResp askTopics(String url, String db, String token, DRCConfig drcConfig) throws ClientProtocolException, IOException, HttpBadResponseException, DRCClientException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/list/" + db + "?token=" + token;
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
        ObjectMapper mapper = new ObjectMapper();
        TopicsResp response = (TopicsResp)mapper.readValue(resp.getEntity().getContent(), TopicsResp.class);
        client.close();
        if (!response.getIsSuccess().booleanValue()) {
            throw new DRCClientException(response.getErrCode() + ":" + response.getErrMsg());
        }
        if (response.getTopics().size() > 1) {
            throw new DRCClientException(db + " matches subtopics more than 1: " + response.getTopics());
        }
        return response;
    }

    public static final TypeResp askTopicType(String url, String topic, DRCConfig drcConfig) throws ClientProtocolException, IOException, DRCClientException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/topic/query" + "?topic=" + topic;
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        CloseableHttpResponse resp = client.execute((HttpUriRequest)method);
        ObjectMapper mapper = new ObjectMapper();
        TypeResp response = (TypeResp)mapper.readValue(resp.getEntity().getContent(), TypeResp.class);
        client.close();
        if (!response.getIsSuccess().booleanValue()) {
            throw new DRCClientException(response.getErrCode() + ":" + response.getErrMsg());
        }
        return response;
    }

    public static final StoreResp askStore(String url, String subTopic, String token, DRCConfig drcConfig) throws IOException, HttpBadResponseException, DRCClientException {
        Checkpoint checkpoint = new Checkpoint(drcConfig.getCheckpoint());
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url + "/storehost/" + subTopic);
        httpPost.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("token", token));
        String cpStr = checkpoint.toString();
        String[] cpArray = cpStr.split(":", -1);
        String ip = cpArray[0];
        if (!StringUtils.isEmpty((CharSequence)ip) && ip.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+")) {
            long l = NetUtils.ipToLong(ip);
            cpStr = l + ":" + cpArray[1] + ":" + cpArray[2] + ":" + cpArray[3] + ":" + cpArray[4] + ":" + cpArray[5];
        }
        nvps.add(new BasicNameValuePair("checkpoint", cpStr));
        nvps.add(new BasicNameValuePair("filter", URLEncoder.encode(drcConfig.getDataFilter().toString(), "ISO-8859-1").toString()));
        if (drcConfig.isUsePublicIp()) {
            nvps.add(new BasicNameValuePair("publicIp", "true"));
        }
        if (drcConfig.getGuid() != null) {
            nvps.add(new BasicNameValuePair("guid", drcConfig.getGuid()));
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF8"));
        CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
        ObjectMapper mapper = new ObjectMapper();
        StoreResp response = (StoreResp)mapper.readValue(resp.getEntity().getContent(), StoreResp.class);
        client.close();
        if (!response.getIsSuccess().booleanValue()) {
            throw new HttpBadResponseException(response.getErrCode(), response.getErrMsg());
        }
        return response;
    }

    final void close() {
        this.handler.close();
    }
}

