/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message;

import com.aliyun.drc.client.enums.DBType;
import com.aliyun.drc.client.message.ByteString;
import com.aliyun.drc.client.message.Message;
import com.aliyun.drc.client.message.drcmessage.BinlogRecord;
import com.aliyun.drc.utils.StringUtils;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataMessage
extends Message {
    public static final String UTF8MB4_ENCODING = "utf8mb4";
    private final List<Record> records;

    public DataMessage() {
        this.type = 100;
        this.records = new ArrayList<Record>();
    }

    public int getRecordCount() {
        return this.records.size();
    }

    public List<Record> getRecordList() {
        return this.records;
    }

    @Override
    public void mergeFrom(DataInputStream reader) throws IOException {
        while (true) {
            Record record = new Record();
            record.mergeFrom(reader);
            if (record.isEnding()) break;
            this.records.add(record);
        }
    }

    public void mergeFromBinary(DataInputStream reader) throws IOException {
        BinlogRecord record = new BinlogRecord();
        ((Record)record).mergeFrom(reader);
        this.records.add(record);
    }

    @Override
    public void clear() {
        super.clear();
        this.records.clear();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        for (Record record : this.records) {
            builder.append(record.toString());
        }
        builder.append(System.getProperty("line.separator"));
        return builder.toString();
    }

    public void addRecord(Record r) {
        this.records.add(r);
    }

    public static class Record {
        private Type type;
        private Map<String, String> attributes = new HashMap<String, String>();
        protected List<Field> fields = new ArrayList<Field>();
        protected String timestamp;
        protected String txBeginTimestamp;
        protected static String gloalTxBeginTimestamp;
        protected static boolean txEnd;
        private boolean ending = false;

        boolean isEnding() {
            return this.ending;
        }

        public void mergeFrom(DataInputStream reader) throws IOException {
            block19: {
                String[] encodings;
                block20: {
                    String line;
                    boolean first = true;
                    while (!(line = reader.readLine()).isEmpty()) {
                        String[] kv = StringUtils.split(line, ':');
                        if (kv.length != 2) continue;
                        this.addAttribute(kv[0], kv[1]);
                        first = false;
                    }
                    if (first) {
                        this.ending = true;
                        return;
                    }
                    String textPKs = this.getPrimaryKeys();
                    List<Object> pkList = Collections.emptyList();
                    if (textPKs != null && !textPKs.isEmpty()) {
                        pkList = Arrays.asList(textPKs.split(","));
                    }
                    String stype = this.getAttribute("record_type");
                    this.type = Type.valueOf(stype.toUpperCase());
                    if (this.type == null) {
                        this.type = Type.UNKNOWN;
                    }
                    this.timestamp = this.getAttribute("timestamp");
                    if (this.type == Type.BEGIN) {
                        gloalTxBeginTimestamp = this.timestamp;
                        txEnd = false;
                    }
                    if (txEnd) {
                        gloalTxBeginTimestamp = this.timestamp;
                    }
                    if (this.type == Type.COMMIT || this.type == Type.ROLLBACK) {
                        txEnd = true;
                    }
                    this.txBeginTimestamp = new String(gloalTxBeginTimestamp);
                    while (true) {
                        Field field = new Field();
                        field.mergeFrom(reader, this.getAttribute("record_encoding"));
                        if (field.name == null) break;
                        if (textPKs != null && !textPKs.isEmpty() && pkList.contains(field.name)) {
                            field.primaryKey = true;
                        }
                        this.fields.add(field);
                    }
                    String fieldsEncodings = this.getAttribute("fields_enc");
                    if (fieldsEncodings == null || fieldsEncodings.isEmpty()) break block19;
                    encodings = fieldsEncodings.split(",", -1);
                    if (encodings.length != this.fields.size()) break block20;
                    for (int i = 0; i < encodings.length; ++i) {
                        String enc = encodings[i];
                        Field field = this.fields.get(i);
                        if (enc.isEmpty()) {
                            if (field.getType() == Field.Type.STRING) {
                                field.encoding = "binary";
                                continue;
                            }
                            if (field.getType() == Field.Type.JSON) {
                                field.encoding = DataMessage.UTF8MB4_ENCODING;
                                continue;
                            }
                            field.encoding = "";
                            continue;
                        }
                        if (field.getType() == Field.Type.BLOB) {
                            field.type = 15;
                        }
                        field.encoding = enc;
                    }
                    break block19;
                }
                if (encodings.length * 2 != this.fields.size()) break block19;
                for (int i = 0; i < encodings.length; ++i) {
                    String enc = encodings[i];
                    Field field1 = this.fields.get(i * 2);
                    Field field2 = this.fields.get(i * 2 + 1);
                    if (enc.isEmpty()) {
                        if (field1.getType() == Field.Type.STRING) {
                            field1.encoding = "binary";
                            field2.encoding = "binary";
                            continue;
                        }
                        if (field1.getType() == Field.Type.JSON) {
                            field1.encoding = DataMessage.UTF8MB4_ENCODING;
                            field2.encoding = DataMessage.UTF8MB4_ENCODING;
                            continue;
                        }
                        field1.encoding = "";
                        field2.encoding = "";
                        continue;
                    }
                    if (field1.getType() == Field.Type.BLOB) {
                        field1.type = 15;
                        field2.type = 15;
                    }
                    field1.encoding = enc;
                    field2.encoding = enc;
                }
            }
        }

        public Type getOpt() {
            return this.type;
        }

        public String getId() {
            return this.getAttribute("record_id");
        }

        public String getDbname() {
            return this.getAttribute("db");
        }

        public String getTablename() {
            return this.getAttribute("table_name");
        }

        public String getCheckpoint() {
            return this.getAttribute("checkpoint");
        }

        @Deprecated
        public String getMetadataVersion() {
            return this.getAttribute("meta");
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getTxBeginTimestamp() {
            return this.txBeginTimestamp;
        }

        public String getServerId() {
            return this.getAttribute("instance");
        }

        public String getPrimaryKeys() {
            return this.getAttribute("primary");
        }

        public String getTraceInfo() {
            return "";
        }

        public String getUniqueColNames() {
            return this.getAttribute("unique");
        }

        public DBType getDbType() {
            String type = this.getAttribute("source_type");
            if (type.equalsIgnoreCase("mysql")) {
                return DBType.MYSQL;
            }
            if (type.equalsIgnoreCase("oceanbase")) {
                return DBType.OCEANBASE;
            }
            return DBType.UNKNOWN;
        }

        public boolean isQueryBack() {
            String cate = this.getAttribute("source_category");
            return !cate.equalsIgnoreCase("full_recorded") && !cate.equalsIgnoreCase("part_recorded") && !cate.equalsIgnoreCase("full_faked");
        }

        public boolean isFirstInLogevent() {
            String isFirstLogevent = this.getAttribute("logevent");
            return isFirstLogevent != null && isFirstLogevent.equals("1");
        }

        public String getAttribute(String key) {
            return this.attributes.get(key);
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public int getFieldCount() {
            return this.fields.size();
        }

        public List<Field> getFieldList() {
            return this.fields;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void addAttribute(String key, String value) {
            this.attributes.put(key, value);
        }

        public byte[] getRawData() {
            return null;
        }

        public String getThreadId() throws IOException {
            return this.getAttribute("threadid");
        }

        public String getTraceId() throws IOException {
            return this.getAttribute("traceid");
        }

        public void parse(byte[] data) throws IOException {
            throw new IOException(Record.class.getName() + " not support parse from raw data");
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                builder.append(entry.getKey() + ":" + entry.getValue());
                builder.append(System.getProperty("line.separator"));
            }
            builder.append(System.getProperty("line.separator"));
            for (Field field : this.fields) {
                builder.append(field.toString());
            }
            builder.append(System.getProperty("line.separator"));
            return builder.toString();
        }

        static {
            txEnd = true;
        }

        public static enum Type {
            INSERT(0),
            UPDATE(1),
            DELETE(2),
            REPLACE(3),
            HEARTBEAT(4),
            CONSISTENCY_TEST(5),
            BEGIN(6),
            COMMIT(7),
            DDL(8),
            ROLLBACK(9),
            DML(10),
            UNKNOWN(11);

            final int _value;

            private Type(int value) {
                this._value = value;
            }

            public int value() {
                return this._value;
            }

            public static Type valueOf(int value) {
                for (Type type : Type.values()) {
                    if (type.value() != value) continue;
                    return type;
                }
                return UNKNOWN;
            }
        }

        public static class Field {
            public long length;
            public boolean primaryKey;
            public String name;
            public int type;
            public String encoding;
            public ByteString value;
            public boolean changeValue = true;
            public static Type[] MYSQL_TYPES = new Type[256];

            public Field() {
                Field.MYSQL_TYPES[0] = Type.DECIMAL;
                Field.MYSQL_TYPES[1] = Type.INT8;
                Field.MYSQL_TYPES[2] = Type.INT16;
                Field.MYSQL_TYPES[3] = Type.INT32;
                Field.MYSQL_TYPES[4] = Type.FLOAT;
                Field.MYSQL_TYPES[5] = Type.DOUBLE;
                Field.MYSQL_TYPES[6] = Type.NULL;
                Field.MYSQL_TYPES[7] = Type.TIMESTAMP;
                Field.MYSQL_TYPES[8] = Type.INT64;
                Field.MYSQL_TYPES[9] = Type.INT24;
                Field.MYSQL_TYPES[10] = Type.DATE;
                Field.MYSQL_TYPES[11] = Type.TIME;
                Field.MYSQL_TYPES[12] = Type.DATETIME;
                Field.MYSQL_TYPES[13] = Type.YEAR;
                Field.MYSQL_TYPES[14] = Type.DATETIME;
                Field.MYSQL_TYPES[15] = Type.STRING;
                Field.MYSQL_TYPES[16] = Type.BIT;
                Field.MYSQL_TYPES[255] = Type.GEOMETRY;
                Field.MYSQL_TYPES[254] = Type.STRING;
                Field.MYSQL_TYPES[253] = Type.STRING;
                Field.MYSQL_TYPES[252] = Type.BLOB;
                Field.MYSQL_TYPES[251] = Type.BLOB;
                Field.MYSQL_TYPES[250] = Type.BLOB;
                Field.MYSQL_TYPES[249] = Type.BLOB;
                Field.MYSQL_TYPES[248] = Type.SET;
                Field.MYSQL_TYPES[247] = Type.ENUM;
                Field.MYSQL_TYPES[246] = Type.DECIMAL;
                Field.MYSQL_TYPES[245] = Type.JSON;
                this.name = null;
                this.type = 17;
                this.length = 0L;
                this.value = null;
                this.primaryKey = false;
            }

            public Field(String name, int type, String encoding, ByteString value, boolean pk) {
                Field.MYSQL_TYPES[0] = Type.DECIMAL;
                Field.MYSQL_TYPES[1] = Type.INT8;
                Field.MYSQL_TYPES[2] = Type.INT16;
                Field.MYSQL_TYPES[3] = Type.INT32;
                Field.MYSQL_TYPES[4] = Type.FLOAT;
                Field.MYSQL_TYPES[5] = Type.DOUBLE;
                Field.MYSQL_TYPES[6] = Type.NULL;
                Field.MYSQL_TYPES[7] = Type.TIMESTAMP;
                Field.MYSQL_TYPES[8] = Type.INT64;
                Field.MYSQL_TYPES[9] = Type.INT24;
                Field.MYSQL_TYPES[10] = Type.DATE;
                Field.MYSQL_TYPES[11] = Type.TIME;
                Field.MYSQL_TYPES[12] = Type.DATETIME;
                Field.MYSQL_TYPES[13] = Type.YEAR;
                Field.MYSQL_TYPES[14] = Type.DATETIME;
                Field.MYSQL_TYPES[15] = Type.STRING;
                Field.MYSQL_TYPES[16] = Type.BIT;
                Field.MYSQL_TYPES[255] = Type.GEOMETRY;
                Field.MYSQL_TYPES[254] = Type.STRING;
                Field.MYSQL_TYPES[253] = Type.STRING;
                Field.MYSQL_TYPES[252] = Type.BLOB;
                Field.MYSQL_TYPES[251] = Type.BLOB;
                Field.MYSQL_TYPES[250] = Type.BLOB;
                Field.MYSQL_TYPES[249] = Type.BLOB;
                Field.MYSQL_TYPES[248] = Type.SET;
                Field.MYSQL_TYPES[247] = Type.ENUM;
                Field.MYSQL_TYPES[246] = Type.DECIMAL;
                Field.MYSQL_TYPES[245] = Type.JSON;
                this.name = name;
                this.type = type;
                this.encoding = encoding;
                if (this.getType() == Type.STRING && this.encoding.isEmpty()) {
                    this.encoding = "binary";
                }
                this.value = value;
                this.length = value == null ? -1L : (long)value.getBytes().length;
                this.primaryKey = pk;
            }

            public final boolean isPrimary() {
                return this.primaryKey;
            }

            public void setPrimary(boolean primary) {
                this.primaryKey = primary;
            }

            public final String getFieldname() {
                return this.name;
            }

            public final String getEncoding() {
                if (this.encoding.equalsIgnoreCase(DataMessage.UTF8MB4_ENCODING)) {
                    return "utf8";
                }
                return this.encoding;
            }

            public final Type getType() {
                if (this.type > 16 && this.type < 245) {
                    return Type.UNKOWN;
                }
                return MYSQL_TYPES[this.type];
            }

            public boolean isChangeValue() {
                return this.changeValue;
            }

            public final ByteString getValue() {
                return this.value;
            }

            public void mergeFrom(DataInputStream reader, String recordEncoding) throws IOException, EOFException {
                this.name = reader.readLine();
                if (this.name.isEmpty()) {
                    this.clear();
                    return;
                }
                this.type = Integer.parseInt(reader.readLine());
                this.length = Long.parseLong(reader.readLine());
                this.encoding = recordEncoding;
                if (this.length != -1L) {
                    byte[] valueBytes = new byte[(int)this.length];
                    reader.readFully(valueBytes);
                    this.value = new ByteString(valueBytes, (int)this.length);
                } else {
                    this.value = null;
                }
                if (reader.readByte() == 13) {
                    reader.readByte();
                }
            }

            public void clear() {
                this.type = 17;
                this.name = null;
                this.length = 0L;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("Field name: " + this.name + System.getProperty("line.separator"));
                builder.append("Field type: " + this.type + System.getProperty("line.separator"));
                builder.append("Field length: " + this.length + System.getProperty("line.separator"));
                try {
                    if (this.value != null) {
                        if (this.encoding.equalsIgnoreCase("binary")) {
                            builder.append("Field value(binary): " + this.value.getBytes() + System.getProperty("line.separator"));
                        } else {
                            builder.append("Field value: " + this.value.toString(this.encoding) + System.getProperty("line.separator"));
                        }
                    } else {
                        builder.append("Field value: null" + System.getProperty("line.separator"));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    builder.append(System.getProperty("line.separator"));
                }
                return builder.toString();
            }

            public static enum Type {
                INT8,
                INT16,
                INT24,
                INT32,
                INT64,
                DECIMAL,
                FLOAT,
                DOUBLE,
                NULL,
                TIMESTAMP,
                DATE,
                TIME,
                DATETIME,
                YEAR,
                BIT,
                ENUM,
                SET,
                BLOB,
                GEOMETRY,
                STRING,
                JSON,
                UNKOWN;

            }
        }
    }
}

