/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message;

import com.aliyun.drc.utils.StringUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Message {
    protected int type;
    protected long id;
    protected Map<String, String> attributes = new HashMap<String, String>();

    public long getMid() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void addAttributes(Map<String, String> attrs) {
        this.attributes.putAll(attrs);
    }

    void mergeFrom(DataInputStream reader) throws IOException {
        String line;
        while (!(line = reader.readLine()).isEmpty()) {
            String[] kv = StringUtils.split(line, ':');
            if (kv.length != 2) {
                throw new IOException("Parse message attribute " + line + " error");
            }
            this.addAttribute(kv[0], kv[1]);
        }
    }

    public void clear() {
        this.type = 0;
        this.id = -1L;
        this.attributes.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            builder.append(entry.getKey() + ":" + entry.getValue());
            builder.append(System.getProperty("line.separator"));
        }
        builder.append(System.getProperty("line.separator"));
        return builder.toString();
    }
}

