/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message;

import com.aliyun.drc.client.message.Message;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RedirectMessage
extends Message {
    private String url;
    private int delayed = 0;
    private String version = new String("2.0");
    private final List<String> persistent = new ArrayList<String>();
    private final List<String> requires = new ArrayList<String>();
    private final List<String> optional = new ArrayList<String>();
    private final Map<String, String> userParameters = new HashMap<String, String>();
    private static final String delimiter = " ";

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setDelayed(int delayed) {
        this.delayed = delayed;
    }

    public int getDelayed() {
        String delay = this.userParameters.get("delay");
        if (delay != null && !delay.isEmpty()) {
            this.delayed = Integer.parseInt(delay);
        }
        return this.delayed;
    }

    public void addRequire(String require) {
        this.requires.add(require);
    }

    public List<String> getPersists() {
        return this.persistent;
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public void addOptional(String optionalParameter) {
        this.optional.add(optionalParameter);
    }

    public List<String> getOptional() {
        return this.optional;
    }

    public void addUserParameters(String name, String value) {
        this.userParameters.put(name, value);
    }

    public Map<String, String> getUserParameters() {
        return this.userParameters;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public void mergeFrom(DataInputStream in) throws IOException {
        String line = in.readLine();
        String[] params = line.split(delimiter);
        if (params.length < 1) {
            throw new IOException("Parse monitor message " + line + " error");
        }
        this.url = params[0];
        for (int i = 1; i < params.length; ++i) {
            this.handleRedirecMessageItem(params[i]);
        }
    }

    @Override
    public String toString() {
        String value;
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(this.url + delimiter);
        for (String req : this.requires) {
            builder.append(req + ":");
            value = this.userParameters.get(req);
            if (value != null) {
                builder.append(value);
            }
            builder.append(",required ");
        }
        for (String opt : this.optional) {
            builder.append(opt + ":");
            value = this.userParameters.get(opt);
            if (value != null) {
                builder.append(value);
            }
            builder.append(",optional ");
        }
        builder.append(System.getProperty("line.separator"));
        return builder.toString();
    }

    private void handleRedirecMessageItem(String item) {
        String[] pair = item.split(":", -1);
        String name = pair[0];
        String params = pair[1];
        if (params.isEmpty()) {
            this.optional.add(name);
            return;
        }
        String[] attrs = params.split(",", -1);
        String value = attrs[0];
        if (!value.isEmpty()) {
            this.userParameters.put(name, value);
        }
        if (attrs.length <= 1) {
            return;
        }
        String require = attrs[1];
        if (require.equals("persistent")) {
            this.persistent.add(name);
        } else if (require.equals("required")) {
            this.requires.add(name);
        } else if (require.equals("optional")) {
            this.optional.add(name);
        }
    }
}

