/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message.drcmessage;

import com.aliyun.drc.client.enums.DBType;
import com.aliyun.drc.client.message.ByteString;
import com.aliyun.drc.client.message.DataMessage;
import com.aliyun.drc.client.message.drcmessage.CIOUtil;
import com.aliyun.drc.client.message.drcmessage.VarAreaMessage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BinlogRecord
extends DataMessage.Record {
    private static final String DEFAULT_ENCODING = "ASCII";
    private static final String SEP = System.getProperty("line.separator");
    private static final int OLD_VERSION_2_HEADER_LEN = 88;
    private static final int NEW_VERSION_2_HEADER_LEN = 96;
    private static final int VERSION_3_HEADER_LEN = 104;
    private int m_brVersion = -1;
    private int m_srcType = -1;
    private int m_op = -1;
    private int m_lastInLogevent = -1;
    private long m_srcCategory = -1L;
    private long m_id = -1L;
    private long m_timestamp = -1L;
    private long m_encoding = -1L;
    private long m_instanceOffset = -1L;
    private long m_timemarkOffset = -1L;
    private long m_dbNameOffset = -1L;
    private long m_tbNameOffset = -1L;
    private long m_colNamesOffset = -1L;
    private long m_colTypesOffset = -1L;
    private long m_fileNameOffset = -1L;
    private long m_fileOffset = -1L;
    private long m_oldColsOffset = -1L;
    private long m_newColsOffset = -1L;
    private long m_pkValOffset = -1L;
    private long m_pkKeysOffset = -1L;
    private long m_ukColsOffset = -1L;
    private long m_filterRuleValOffset = -1L;
    private long m_tailOffset = -1L;
    private long m_colsEncsOffset = -1L;
    private VarAreaMessage message = new VarAreaMessage();
    private static final long MAX_LONG = -1L;

    public BinlogRecord() {
        this.fields = new ArrayList();
    }

    @Override
    public byte[] getRawData() {
        return this.message.getRawData();
    }

    @Override
    public void parse(byte[] data) throws IOException {
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        this.parse(is);
    }

    public void parse(DataInputStream is) throws IOException {
        boolean idOldVersion2;
        this.message.parse(is);
        List bytes = this.message.getArray(0);
        byte[] bytesArray = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            bytesArray[i] = ((Integer)bytes.get(i)).byteValue();
        }
        switch (bytes.size()) {
            case 88: {
                idOldVersion2 = true;
                break;
            }
            case 96: 
            case 104: {
                idOldVersion2 = false;
                break;
            }
            default: {
                throw new IOException("Parsed bytes header size not recogonized: " + bytes.size());
            }
        }
        DataInputStream hs = new DataInputStream(new ByteArrayInputStream(bytesArray));
        this.m_brVersion = hs.readUnsignedByte();
        this.m_srcType = hs.readUnsignedByte();
        this.m_op = hs.readUnsignedByte();
        this.m_lastInLogevent = hs.readUnsignedByte();
        this.m_srcCategory = CIOUtil.readUnsignedInt(hs);
        this.m_id = CIOUtil.readLong(hs);
        this.m_timestamp = CIOUtil.readLong(hs);
        this.m_encoding = CIOUtil.readUnsignedInt(hs);
        this.m_instanceOffset = CIOUtil.readUnsignedInt(hs);
        this.m_timemarkOffset = CIOUtil.readUnsignedInt(hs);
        this.m_dbNameOffset = CIOUtil.readUnsignedInt(hs);
        this.m_tbNameOffset = CIOUtil.readUnsignedInt(hs);
        this.m_colNamesOffset = CIOUtil.readUnsignedInt(hs);
        this.m_colTypesOffset = CIOUtil.readUnsignedInt(hs);
        if (!idOldVersion2) {
            this.m_pkValOffset = CIOUtil.readUnsignedInt(hs);
            this.m_fileNameOffset = CIOUtil.readLong(hs);
            this.m_fileOffset = CIOUtil.readLong(hs);
            if (this.m_fileNameOffset < -1L || this.m_fileOffset < -1L) {
                throw new IOException("f: " + this.m_fileNameOffset + " and o: " + this.m_fileOffset + " should both be signed integer");
            }
            this.m_oldColsOffset = CIOUtil.readUnsignedInt(hs);
            this.m_newColsOffset = CIOUtil.readUnsignedInt(hs);
        } else {
            this.m_fileNameOffset = CIOUtil.readUnsignedInt(hs);
            this.m_fileOffset = CIOUtil.readUnsignedInt(hs);
            this.m_oldColsOffset = CIOUtil.readUnsignedInt(hs);
            this.m_newColsOffset = CIOUtil.readUnsignedInt(hs);
            this.m_pkValOffset = CIOUtil.readUnsignedInt(hs);
        }
        this.m_pkKeysOffset = CIOUtil.readUnsignedInt(hs);
        this.m_ukColsOffset = CIOUtil.readUnsignedInt(hs);
        if (this.m_brVersion > 1) {
            this.m_colsEncsOffset = CIOUtil.readLong(hs);
        }
        if (this.m_brVersion == 3) {
            this.m_filterRuleValOffset = CIOUtil.readUnsignedInt(hs);
            this.m_tailOffset = CIOUtil.readUnsignedInt(hs);
        }
        this.timestamp = Long.toString(this.m_timestamp);
        DataMessage.Record.Type type = DataMessage.Record.Type.valueOf(this.m_op);
        if (type == DataMessage.Record.Type.BEGIN) {
            gloalTxBeginTimestamp = this.timestamp;
            txEnd = false;
        }
        if (txEnd) {
            gloalTxBeginTimestamp = this.timestamp;
        }
        this.txBeginTimestamp = new String(gloalTxBeginTimestamp);
        if (type == DataMessage.Record.Type.COMMIT || type == DataMessage.Record.Type.ROLLBACK) {
            txEnd = true;
        }
    }

    public int getVersion() {
        return this.m_brVersion;
    }

    @Override
    public DBType getDbType() {
        switch (this.m_srcType) {
            case 0: {
                return DBType.MYSQL;
            }
            case 1: {
                return DBType.OCEANBASE;
            }
        }
        return DBType.UNKNOWN;
    }

    @Override
    public boolean isQueryBack() {
        switch ((int)this.m_srcCategory) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isFirstInLogevent() {
        return this.m_lastInLogevent == 1;
    }

    @Override
    public void mergeFrom(DataInputStream is) throws IOException {
        this.parse(is);
    }

    @Override
    public DataMessage.Record.Type getOpt() {
        return DataMessage.Record.Type.valueOf(this.m_op);
    }

    @Override
    public String getId() {
        return Long.toString(this.m_id);
    }

    @Override
    public String getDbname() {
        try {
            if ((int)this.m_dbNameOffset < 0) {
                return null;
            }
            return this.message.getString((int)this.m_dbNameOffset, DEFAULT_ENCODING);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final String getTablename() {
        try {
            if ((int)this.m_tbNameOffset < 0) {
                return null;
            }
            return this.message.getString((int)this.m_tbNameOffset, DEFAULT_ENCODING);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getCheckpoint() {
        return this.m_fileOffset + "@" + this.m_fileNameOffset;
    }

    @Override
    @Deprecated
    public String getMetadataVersion() {
        return "0";
    }

    @Override
    public String getServerId() {
        try {
            if ((int)this.m_instanceOffset < 0) {
                return null;
            }
            return this.message.getString((int)this.m_instanceOffset, DEFAULT_ENCODING);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ByteString> getFirstPKValue() {
        try {
            if ((int)this.m_pkValOffset < 0) {
                return null;
            }
            return this.message.getByteStringList((int)this.m_pkValOffset);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getPrimaryKeys() {
        try {
            if ((int)this.m_pkKeysOffset < 0) {
                return "";
            }
            List pks = this.message.getArray((int)this.m_pkKeysOffset);
            List<ByteString> names = this.message.getByteStringList(this.m_colNamesOffset);
            StringBuilder pkKeyName = new StringBuilder();
            if (pks != null) {
                Iterator iterator = pks.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    if (pkKeyName.length() != 0) {
                        pkKeyName.append(",");
                    }
                    pkKeyName.append(names.get(idx).toString(DEFAULT_ENCODING));
                }
            }
            return pkKeyName.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getUniqueColNames() {
        try {
            if ((int)this.m_ukColsOffset < 0) {
                return "";
            }
            List uks = this.message.getArray((int)this.m_ukColsOffset);
            List<ByteString> names = this.message.getByteStringList(this.m_colNamesOffset);
            StringBuilder ukKeyName = new StringBuilder();
            if (uks != null) {
                Iterator iterator = uks.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    if (ukKeyName.length() != 0) {
                        ukKeyName.append(",");
                    }
                    ukKeyName.append(names.get(idx).toString(DEFAULT_ENCODING));
                }
            }
            return ukKeyName.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public int getFieldCount() {
        return this.getFieldList().size();
    }

    @Override
    public List<DataMessage.Record.Field> getFieldList() {
        if (!this.fields.isEmpty()) {
            return this.fields;
        }
        if (this.m_colNamesOffset < 0L || this.m_colTypesOffset < 0L || this.m_oldColsOffset < 0L || this.m_newColsOffset < 0L) {
            return this.fields;
        }
        try {
            List<ByteString> names = this.message.getByteStringList(this.m_colNamesOffset);
            List types = this.message.getArray((int)this.m_colTypesOffset);
            List<ByteString> oldValues = this.message.getByteStringList(this.m_oldColsOffset);
            List<ByteString> newValues = this.message.getByteStringList(this.m_newColsOffset);
            String encoding = this.message.getString((int)this.m_encoding, DEFAULT_ENCODING);
            List<ByteString> colEncs = this.message.getByteStringList(this.m_colsEncsOffset);
            List pks = null;
            if ((int)this.m_pkKeysOffset > 0) {
                pks = this.message.getArray((int)this.m_pkKeysOffset);
            }
            this.fields = new ArrayList();
            int size = names.size();
            for (int i = 0; i < size; ++i) {
                boolean ispk = false;
                int type = (Integer)types.get(i);
                if (pks != null) {
                    ispk = pks.contains(i);
                }
                String realEncoding = encoding;
                if (colEncs != null && (realEncoding = colEncs.get(i).toString(DEFAULT_ENCODING)).isEmpty()) {
                    realEncoding = (type == 253 || type == 254) && DataMessage.Record.Field.MYSQL_TYPES[type] == DataMessage.Record.Field.Type.STRING ? "binary" : (DataMessage.Record.Field.MYSQL_TYPES[type] == DataMessage.Record.Field.Type.BLOB ? "" : (type == 245 ? "utf8mb4" : DEFAULT_ENCODING));
                }
                if (!realEncoding.isEmpty() && DataMessage.Record.Field.MYSQL_TYPES[type] == DataMessage.Record.Field.Type.BLOB) {
                    type = 15;
                }
                if (oldValues != null) {
                    this.fields.add(new DataMessage.Record.Field(names.get(i).toString(DEFAULT_ENCODING), type, realEncoding, oldValues.get(i), ispk));
                }
                if (newValues == null) continue;
                this.fields.add(new DataMessage.Record.Field(names.get(i).toString(DEFAULT_ENCODING), type, realEncoding, newValues.get(i), ispk));
            }
            return this.fields;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Long> getTimemarks() throws IOException {
        return this.message.getArray((int)this.m_timemarkOffset);
    }

    @Override
    public String getTraceId() throws IOException {
        List<ByteString> list = this.message.getByteStringList(this.m_filterRuleValOffset);
        if (list == null || list.size() == 0 || list.size() < 3) {
            return null;
        }
        ByteString traceId = list.get(2);
        return traceId == null ? null : traceId.toString();
    }

    @Override
    public String getThreadId() throws IOException {
        long threadId = 0L;
        List list = this.message.getArray((int)this.m_tailOffset);
        if (list == null || list.size() == 0) {
            return null;
        }
        threadId += (long)((Integer)list.get(0)).intValue();
        threadId += (long)((Integer)list.get(1)).intValue() << 8;
        threadId += (long)((Integer)list.get(2)).intValue() << 16;
        return String.valueOf(threadId += (long)((Integer)list.get(3)).intValue() << 24);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.parse(new DataInputStream(in));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("type:" + (Object)((Object)this.getOpt())).append(SEP);
        builder.append("record_id:" + this.getId()).append(SEP);
        builder.append("db:" + this.getDbname()).append(SEP);
        builder.append("tb:" + this.getTablename()).append(SEP);
        builder.append("serverId:" + this.getServerId()).append(SEP);
        builder.append("checkpoint:" + this.getCheckpoint()).append(SEP);
        builder.append("primary_value:" + this.getPrimaryKeys()).append(SEP);
        builder.append("unique_keys:" + this.getUniqueColNames()).append(SEP);
        builder.append(SEP);
        this.getFieldList();
        for (DataMessage.Record.Field field : this.fields) {
            builder.append(field.toString());
        }
        builder.append(SEP);
        return builder.toString();
    }
}

