/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message.drcmessage;

import com.aliyun.drc.client.message.ByteString;
import com.aliyun.drc.client.message.drcmessage.CIOUtil;
import com.aliyun.drc.client.message.drcmessage.VarAreaHeader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class VarAreaMessage {
    private boolean parsedOK = false;
    private VarAreaHeader header = null;
    private byte[] data = null;
    private int previousBytesLength = 0;
    private int len = 0;
    private static final long MAX_LONG = -1L;
    private static final int MESSAGE_LENGTH_THRESHOLD = 0x6400000;

    public byte[] getRawData() {
        return this.data;
    }

    public void parse(DataInputStream is) throws IOException {
        this.header = new VarAreaHeader();
        this.header.parseFrom(is);
        this.len = (int)this.header.getMsgHeader().getMessageSize();
        if (this.len <= 4 || this.len > 0x6400000) {
            throw new IOException("Header shows message size " + this.len + " less than 4 or bigger then 100m");
        }
        this.len -= 4;
        this.previousBytesLength = this.header.getRawData().length;
        this.data = new byte[this.len + this.previousBytesLength];
        for (int i = 0; i < this.previousBytesLength; ++i) {
            this.data[i] = this.header.getRawData()[i];
        }
        is.readFully(this.data, this.previousBytesLength, this.len);
        this.parsedOK = true;
    }

    public DataInputStream getDataInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("data[] in VarAreaMessage is null");
        }
        return new DataInputStream(new ByteArrayInputStream(this.data, this.previousBytesLength, this.len));
    }

    public String getString(int offset, String encoding) throws IOException {
        if (!this.parsedOK) {
            throw new IOException("Message not parsed");
        }
        if (offset < 0) {
            throw new IOException("String offset is negative " + offset);
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(this.data, offset + this.previousBytesLength, this.data.length - offset - this.previousBytesLength));
        byte t = is.readByte();
        if ((t & 0x10) != 0) {
            throw new IOException("Get string failed, message data category array");
        }
        if ((t & 0x20) != 0) {
            return null;
        }
        return CIOUtil.readString(is, encoding);
    }

    public ByteString getByteString(int offset) throws IOException {
        if (!this.parsedOK) {
            throw new IOException("Message not parsed");
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(this.data, offset + this.previousBytesLength, this.data.length - offset - this.previousBytesLength));
        byte t = is.readByte();
        if ((t & 0x10) != 0) {
            throw new IOException("Get string failed, message data category array");
        }
        if ((t & 0x20) != 0) {
            return null;
        }
        return CIOUtil.readByteString(is);
    }

    public List<ByteString> getByteStringList(long offset) throws IOException {
        if (!this.parsedOK) {
            throw new IOException("Message not parsed");
        }
        if (offset == -1L) {
            return null;
        }
        if (offset < 0L || offset > (long)(this.data.length - this.previousBytesLength)) {
            throw new IOException("Binary message error: data length: " + this.data.length + " previous length: " + this.previousBytesLength + " offset: " + offset);
        }
        int readBytes = 0;
        ByteArrayInputStream bis = new ByteArrayInputStream(this.data, (int)offset + this.previousBytesLength, this.data.length - (int)offset - this.previousBytesLength);
        DataInputStream is = new DataInputStream(bis);
        byte t = is.readByte();
        ++readBytes;
        if ((t & 0x10) == 0 || (t & 0xF) != 11) {
            throw new IOException("Data type not array or not string");
        }
        long count = CIOUtil.readUnsignedInt(is);
        if (count == 0L) {
            return null;
        }
        readBytes += 4;
        long[] offsets = new long[(int)count + 1];
        for (int i = 0; i < (int)count + 1; ++i) {
            offsets[i] = CIOUtil.readUnsignedInt(is);
            readBytes += 4;
        }
        ArrayList<ByteString> lists = new ArrayList<ByteString>();
        for (int i = 0; i < (int)count; ++i) {
            if ((int)offsets[i + 1] == (int)offsets[i]) {
                lists.add(null);
                continue;
            }
            lists.add(new ByteString(this.data, this.previousBytesLength + (int)offsets[i] + readBytes + (int)offset, (int)offsets[i + 1] - (int)offsets[i] - 1));
        }
        return lists;
    }

    List getArray(int offset) throws IOException {
        if (!this.parsedOK) {
            throw new IOException("Message not parsed");
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(this.data, this.previousBytesLength + offset, this.data.length - offset - this.previousBytesLength));
        byte t = is.readByte();
        if ((t & 0x10) == 0) {
            throw new IOException("Data type not array or not string");
        }
        long count = CIOUtil.readUnsignedInt(is);
        if (count == 0L) {
            return null;
        }
        ArrayList<Number> lists = null;
        int elementSize = 0;
        Class typeClass = null;
        switch (t & 0xF) {
            case 1: {
                elementSize = 1;
                typeClass = Byte.class;
                lists = new ArrayList<Number>();
                break;
            }
            case 2: {
                elementSize = 1;
                typeClass = Integer.class;
                lists = new ArrayList();
                break;
            }
            case 3: {
                elementSize = 2;
                typeClass = Short.class;
                lists = new ArrayList();
                break;
            }
            case 4: {
                elementSize = 2;
                typeClass = Integer.class;
                lists = new ArrayList();
                break;
            }
            case 5: {
                elementSize = 4;
                typeClass = Integer.class;
                lists = new ArrayList();
                break;
            }
            case 6: {
                elementSize = 4;
                typeClass = Long.class;
                lists = new ArrayList();
                break;
            }
            case 7: {
                elementSize = 8;
                typeClass = Long.class;
                lists = new ArrayList();
                break;
            }
            case 8: {
                elementSize = 8;
                typeClass = BigInteger.class;
                lists = new ArrayList();
                break;
            }
            default: {
                throw new IOException("Unkown type " + t);
            }
        }
        block16: for (int i = 0; i < (int)count; ++i) {
            switch (elementSize) {
                case 1: {
                    if (typeClass == Byte.class) {
                        lists.add(is.readByte());
                        continue block16;
                    }
                    if (typeClass != Integer.class) continue block16;
                    lists.add(is.readUnsignedByte());
                    continue block16;
                }
                case 2: {
                    if (typeClass == Short.class) {
                        lists.add(CIOUtil.readShort(is));
                        continue block16;
                    }
                    if (typeClass != Integer.class) continue block16;
                    lists.add(CIOUtil.readUnsignedShort(is));
                    continue block16;
                }
                case 4: {
                    if (typeClass == Integer.class) {
                        lists.add(CIOUtil.readInt(is));
                        continue block16;
                    }
                    if (typeClass != Long.class) continue block16;
                    lists.add(CIOUtil.readUnsignedInt(is));
                    continue block16;
                }
                case 8: {
                    if (typeClass == Long.class) {
                        lists.add(CIOUtil.readLong(is));
                        continue block16;
                    }
                    if (typeClass != BigInteger.class) continue block16;
                    throw new IOException("Unsupported unsigned long");
                }
            }
        }
        return lists;
    }
}

