/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.clusterclient.partition;

import com.aliyun.drc.client.message.DataMessage;
import org.apache.commons.lang3.StringUtils;

public class Checkpoint {
    private static final int IP = 0;
    private static final int PORT = 1;
    private static final int FILE = 2;
    private static final int OFF = 3;
    private static final int TMSP = 4;
    private static final int ID = 5;
    private String[] list = new String[6];

    public Checkpoint(String checkpoint) {
        this.setCheckpoint(checkpoint);
    }

    public Checkpoint(DataMessage.Record record) {
        this.setCheckpoint(record);
    }

    public void setCheckpoint(String checkpoint) {
        String[] splitted = checkpoint.split(":");
        for (int i = 0; i < splitted.length; ++i) {
            if (splitted[i] == null || splitted[i].isEmpty()) continue;
            this.list[i] = splitted[i];
        }
    }

    public final String getIp() {
        return this.list[0];
    }

    public final String getPort() {
        return this.list[1];
    }

    public final String getInstance() {
        if (this.list[0] != null && this.list[1] != null) {
            return this.list[0] + "-" + this.list[1];
        }
        return null;
    }

    public void setInstance(String instance) {
        String[] ins = StringUtils.split((String)instance, (char)'-');
        this.list[0] = ins[0];
        this.list[1] = ins[1];
    }

    public final String getFile() {
        return this.list[2];
    }

    public final String getFileOffset() {
        return this.list[3];
    }

    public final String getFilePosition() {
        if (this.list[3] != null && this.list[2] != null) {
            return this.list[3] + "@" + this.list[2];
        }
        return null;
    }

    public void setFilePosition(String pos) {
        if (pos == null) {
            return;
        }
        String[] filePosition = StringUtils.split((String)pos, (char)'@');
        this.list[2] = filePosition[1];
        this.list[3] = filePosition[0];
    }

    public final String getTimestamp() {
        return this.list[4];
    }

    public void setTimestamp(String timestamp) {
        this.list[4] = timestamp;
    }

    public final String getId() {
        return this.list[5];
    }

    public void setId(String id) {
        this.list[5] = id;
    }

    public void setCheckpoint(DataMessage.Record record) {
        if (record.getServerId() == null) {
            this.setInstance("16843009-1");
        } else {
            this.setInstance(record.getServerId());
        }
        this.setFilePosition(record.getCheckpoint());
        this.setTimestamp(record.getTimestamp());
        this.setId(record.getId());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.list.length; ++i) {
            builder.append(this.list[i]);
            if (i == this.list.length - 1) continue;
            builder.append(':');
        }
        return builder.toString();
    }
}

