/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.httpclient;

import com.aliyun.drc.httpclient.HttpResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public class HttpClient {
    private static final String DefaultEncoding = "UTF-8";
    private static final int DefaultConnectionTimeout = 60000;
    private static final int DefaultSocketTimeout = 60000;
    private static final int DefaultMaxPerRoute = 20;
    private static final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).setConnectionRequestTimeout(60000).build();
    private static final org.apache.http.client.HttpClient client;

    public HttpResponse get(String path) throws IOException {
        HttpGet method = new HttpGet(path);
        method.setConfig(requestConfig);
        org.apache.http.HttpResponse response = client.execute((HttpUriRequest)method);
        HttpResponse resp = new HttpResponse(response);
        method.releaseConnection();
        if (resp.getCode() != 200) {
            throw new IllegalStateException("Register to " + path + " failed: " + resp);
        }
        return resp;
    }

    public HttpResponse post(String url, Map<String, String> posts) throws IllegalStateException, IOException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> pair : posts.entrySet()) {
            parameters.add(new BasicNameValuePair(pair.getKey(), pair.getValue()));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters, DefaultEncoding);
        HttpPost method = new HttpPost(url);
        method.setEntity((HttpEntity)entity);
        method.setConfig(requestConfig);
        HttpResponse resp = new HttpResponse(client.execute((HttpUriRequest)method));
        method.releaseConnection();
        if (resp.getCode() != 200) {
            throw new IllegalStateException("Register to " + url + " failed: " + resp);
        }
        return resp;
    }

    static {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(20);
        manager.setDefaultMaxPerRoute(20);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
    }
}

