/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.regionmanager;

import com.aliyun.drc.clusterclient.RegionContext;
import com.aliyun.drc.pop.drcGuidRouteApiRequest;
import com.aliyun.drc.pop.drcGuidRouteApiResponse;
import com.aliyun.drc.regionmanager.RegionRouterInfo;
import com.aliyun.drc.util.CipherUtils;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionRouter {
    private static Logger logger = LoggerFactory.getLogger(RegionRouter.class);
    private static final int TOKEN_EXPIRE_SECOND = 600;
    private RegionContext context;

    public RegionRouter(RegionContext regionContext) {
        this.context = regionContext;
    }

    public RegionRouterInfo getRegionRouterInfo(String guid) throws Exception {
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.context.getAccessKey(), (String)this.context.getSecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        drcGuidRouteApiRequest request = new drcGuidRouteApiRequest();
        request.setguid(guid);
        drcGuidRouteApiResponse response = (drcGuidRouteApiResponse)client.getAcsResponse((AcsRequest)request);
        if (response.getSuccess() == null || !response.getSuccess().booleanValue()) {
            logger.error("get guid info failed, server response: " + response.getdata());
            throw new Exception("get guid info failed");
        }
        String decryptResponse = CipherUtils.decrypt(response.getdata());
        List list = URLEncodedUtils.parse((String)decryptResponse, (Charset)Charset.defaultCharset());
        if (list.size() != 6) {
            logger.error("decrypted list size from token, expect: 6, actual: " + list.size());
            return null;
        }
        long ts = Long.parseLong(((NameValuePair)list.get(0)).getValue());
        if (ts < System.currentTimeMillis() / 1000L - 600L) {
            logger.error("timestamp expired, server ts:" + ts + ", current client ts:" + String.valueOf(System.currentTimeMillis() / 1000L));
            return null;
        }
        RegionRouterInfo regionRouterInfo = new RegionRouterInfo();
        regionRouterInfo.setConsumerGroup(((NameValuePair)list.get(1)).getValue());
        regionRouterInfo.setClusterUrl(((NameValuePair)list.get(2)).getValue());
        regionRouterInfo.setUsername(((NameValuePair)list.get(3)).getValue());
        regionRouterInfo.setPassword(((NameValuePair)list.get(4)).getValue());
        regionRouterInfo.setDataType(((NameValuePair)list.get(5)).getValue());
        regionRouterInfo.setUsePublicIp(this.context.isUsePublicIp());
        return regionRouterInfo;
    }
}

