/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.apache.api.impl.rocketmq;

import com.aliyun.openservices.apache.api.impl.authority.AuthUtil;
import com.aliyun.openservices.apache.api.impl.authority.SessionCredentials;
import com.aliyun.openservices.apache.api.impl.rocketmq.AbstractRPCHook;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class ClientRPCHook
extends AbstractRPCHook {
    private SessionCredentials sessionCredentials;

    public ClientRPCHook(SessionCredentials sessionCredentials) {
        this.sessionCredentials = sessionCredentials;
    }

    public void doBeforeRequest(String remoteAddr, RemotingCommand request) {
        byte[] total = AuthUtil.combineRequestContent(request, this.parseRequestContent(request, this.sessionCredentials.getAccessKey(), this.sessionCredentials.getSecurityToken(), this.sessionCredentials.getOnsChannel().name()));
        String signature = AuthUtil.calSignature(total, this.sessionCredentials.getSecretKey());
        request.addExtField("Signature", signature);
        request.addExtField("AccessKey", this.sessionCredentials.getAccessKey());
        request.addExtField("OnsChannel", this.sessionCredentials.getOnsChannel().name());
        if (this.sessionCredentials.getSecurityToken() != null) {
            request.addExtField("SecurityToken", this.sessionCredentials.getSecurityToken());
        }
    }

    public void doAfterResponse(String remoteAddr, RemotingCommand request, RemotingCommand response) {
    }
}

