/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.Logs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LogGroupData
implements Serializable {
    private static final long serialVersionUID = -7939302281903476332L;
    protected String mReserved = "";
    protected String mTopic = "";
    protected String mSource = "";
    protected String mMachineUUID = "";
    protected ArrayList<LogItem> mLogs;
    protected Logs.LogGroup mLogGroup;

    public LogGroupData() {
    }

    public LogGroupData(Logs.LogGroup logGroup) {
        this.mLogGroup = logGroup;
    }

    public Logs.LogGroup GetLogGroup() {
        return this.mLogGroup;
    }

    public void SetLogGroup(Logs.LogGroup mLogGroup) {
        this.mLogGroup = mLogGroup;
    }

    public LogGroupData(LogGroupData logGroup) {
        this.mReserved = logGroup.GetReserved();
        this.mTopic = logGroup.GetTopic();
        this.mSource = logGroup.GetSource();
        this.mMachineUUID = logGroup.GetMachineUUID();
        this.mLogs = logGroup.mLogs;
        this.mLogGroup = logGroup.mLogGroup;
    }

    @Deprecated
    public LogGroupData(String reserved, String topic, String source, String mMachineUUID, ArrayList<LogItem> logs) {
        this.mReserved = reserved;
        this.mTopic = topic;
        this.mSource = source;
        this.SetAllLogs(logs);
    }

    protected void AutoDeserilize() {
        if (this.mLogs != null) {
            return;
        }
        if (this.mLogGroup.hasCategory()) {
            this.SetReserved(this.mLogGroup.getCategory());
        }
        if (this.mLogGroup.hasTopic()) {
            this.SetTopic(this.mLogGroup.getTopic());
        }
        if (this.mLogGroup.hasSource()) {
            this.SetSource(this.mLogGroup.getSource());
        }
        if (this.mLogGroup.hasMachineUUID()) {
            this.SetMachineUUID(this.mLogGroup.getMachineUUID());
        }
        List<Logs.Log> logs = this.mLogGroup.getLogsList();
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        for (Logs.Log log : logs) {
            ArrayList<LogContent> logContents = new ArrayList<LogContent>();
            for (Logs.Log.Content content : log.getContentsList()) {
                logContents.add(new LogContent(content.getKey(), content.getValue()));
            }
            logItems.add(new LogItem(log.getTime(), logContents));
        }
        this.SetAllLogs(logItems);
    }

    @Deprecated
    public ArrayList<LogItem> GetAllLogs() {
        this.AutoDeserilize();
        return this.mLogs;
    }

    @Deprecated
    public LogItem GetLogByIndex(int index) {
        this.AutoDeserilize();
        return this.mLogs.get(index);
    }

    @Deprecated
    public void SetAllLogs(ArrayList<LogItem> logs) {
        this.mLogs = logs;
    }

    @Deprecated
    public String GetReserved() {
        return this.mReserved;
    }

    @Deprecated
    public void SetReserved(String reserved) {
        this.mReserved = reserved;
    }

    public String GetTopic() {
        return this.mLogGroup.getTopic();
    }

    @Deprecated
    public void SetTopic(String topic) {
        this.mTopic = topic;
    }

    public String GetSource() {
        return this.mLogGroup.getSource();
    }

    @Deprecated
    public void SetSource(String source) {
        this.mSource = source;
    }

    public String GetMachineUUID() {
        return this.mLogGroup.getMachineUUID();
    }

    @Deprecated
    public void SetMachineUUID(String machineUUID) {
        this.mMachineUUID = machineUUID;
    }
}

