/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.response;

import com.aliyun.openservices.log.common.LZ4Encoder;
import com.aliyun.openservices.log.common.LogGroupData;
import com.aliyun.openservices.log.common.Logs;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.response.Response;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BatchGetLogResponse
extends Response {
    private static final long serialVersionUID = 1682292008312952493L;
    protected List<LogGroupData> mLogGroups = new ArrayList<LogGroupData>();
    protected int mRawSize;

    public int GetRawSize() {
        return this.mRawSize;
    }

    public BatchGetLogResponse(Map<String, String> headers, byte[] rawData) throws LogException {
        super(headers);
        try {
            this.mRawSize = Integer.parseInt(headers.get("x-log-bodyrawsize"));
            if (this.mRawSize > 0) {
                byte[] uncompressedData = LZ4Encoder.decompressFromLhLz4Chunk(rawData, this.mRawSize);
                Logs.LogGroupList logGroupList = Logs.LogGroupList.parseFrom(uncompressedData);
                for (Logs.LogGroup logGroup : logGroupList.getLogGroupListList()) {
                    this.mLogGroups.add(new LogGroupData(logGroup));
                }
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new LogException("InitLogGroupsError", e.getMessage(), e, this.GetRequestId());
        }
        catch (NumberFormatException e) {
            throw new LogException("ParseLogGroupListRawSizeError", e.getMessage(), e, this.GetRequestId());
        }
        if (this.mLogGroups.size() != this.GetCount()) {
            throw new LogException("LogGroupCountNotMatch", "Loggroup count does match with the count in header message", this.GetRequestId());
        }
    }

    public String GetNextCursor() {
        return this.GetHeader("x-log-cursor");
    }

    public int GetCount() {
        return Integer.parseInt(this.GetHeader("x-log-count"));
    }

    public LogGroupData GetLogGroup(int index) throws LogException {
        if (this.GetCount() <= 0) {
            throw new LogException("GetLogGroupError", "No LogGroups in response", this.GetRequestId());
        }
        if (index >= 0 && index < this.GetCount()) {
            return this.mLogGroups.get(index);
        }
        throw new LogException("GetLogGroupError", "Invalid index", this.GetRequestId());
    }

    public List<LogGroupData> GetLogGroups(int offset) throws LogException {
        if (this.GetCount() <= 0) {
            throw new LogException("GetLogGroupError", "No LogGroups in response", this.GetRequestId());
        }
        if (offset < 0 || offset >= this.GetCount()) {
            throw new LogException("GetLogGroupError", "Invalid offset", this.GetRequestId());
        }
        return this.mLogGroups.subList(offset, this.GetCount());
    }

    public List<LogGroupData> GetLogGroups() throws LogException {
        return this.mLogGroups;
    }
}

