/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.commons.beanutils;

import com.aliyun.log.thirdparty.org.apache.commons.beanutils.DynaBean;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.DynaClass;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.DynaProperty;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.MutableDynaClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DynaBeanMapDecorator
implements Map {
    private DynaBean dynaBean;
    private boolean readOnly;
    private transient Set keySet;

    public DynaBeanMapDecorator(DynaBean dynaBean) {
        this(dynaBean, true);
    }

    public DynaBeanMapDecorator(DynaBean dynaBean, boolean readOnly) {
        if (dynaBean == null) {
            throw new IllegalArgumentException("DynaBean is null");
        }
        this.dynaBean = dynaBean;
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key) {
        DynaClass dynaClass = this.getDynaBean().getDynaClass();
        DynaProperty dynaProperty = dynaClass.getDynaProperty(this.toString(key));
        return dynaProperty != null;
    }

    public boolean containsValue(Object value) {
        DynaProperty[] properties = this.getDynaProperties();
        for (int i = 0; i < properties.length; ++i) {
            String key = properties[i].getName();
            Object prop = this.getDynaBean().get(key);
            if (!(value == null ? prop == null : value.equals(prop))) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        DynaProperty[] properties = this.getDynaProperties();
        HashSet<MapEntry> set = new HashSet<MapEntry>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            String key = properties[i].getName();
            Object value = this.getDynaBean().get(key);
            set.add(new MapEntry(key, value));
        }
        return Collections.unmodifiableSet(set);
    }

    public Object get(Object key) {
        return this.getDynaBean().get(this.toString(key));
    }

    public boolean isEmpty() {
        return this.getDynaProperties().length == 0;
    }

    public Set keySet() {
        if (this.keySet != null) {
            return this.keySet;
        }
        DynaProperty[] properties = this.getDynaProperties();
        Set<String> set = new HashSet<String>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            set.add(properties[i].getName());
        }
        set = Collections.unmodifiableSet(set);
        DynaClass dynaClass = this.getDynaBean().getDynaClass();
        if (!(dynaClass instanceof MutableDynaClass)) {
            this.keySet = set;
        }
        return set;
    }

    public Object put(Object key, Object value) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Map is read only");
        }
        String property = this.toString(key);
        Object previous = this.getDynaBean().get(property);
        this.getDynaBean().set(property, value);
        return previous;
    }

    public void putAll(Map map) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Map is read only");
        }
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            this.put(key, map.get(key));
        }
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.getDynaProperties().length;
    }

    public Collection values() {
        DynaProperty[] properties = this.getDynaProperties();
        ArrayList<Object> values = new ArrayList<Object>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            String key = properties[i].getName();
            Object value = this.getDynaBean().get(key);
            values.add(value);
        }
        return Collections.unmodifiableList(values);
    }

    public DynaBean getDynaBean() {
        return this.dynaBean;
    }

    private DynaProperty[] getDynaProperties() {
        return this.getDynaBean().getDynaClass().getDynaProperties();
    }

    private String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    private static class MapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        MapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key.equals(e.getKey()) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            return this.key.hashCode() + (this.value == null ? 0 : this.value.hashCode());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

