/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.ACLPrivileges;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class ACL
implements Serializable {
    private static final long serialVersionUID = -4828970701559782547L;
    protected Consts.ACLAction action;
    protected String principle = "";
    protected ACLPrivileges privilege = new ACLPrivileges();
    protected int lastModifyTime = -1;
    protected int createTime = -1;

    public ACL() {
    }

    public ACL(String principle, ACLPrivileges privilege, Consts.ACLAction action) {
        this.principle = principle;
        this.privilege = new ACLPrivileges(privilege);
        this.action = action;
    }

    public ACL(ACL acl) {
        this.action = acl.GetAction();
        this.principle = acl.GetPrinciple();
        this.SetPrivilege(acl.GetPrivilege());
        this.lastModifyTime = acl.GetLastModifyTime();
        this.createTime = acl.GetCreateTime();
    }

    public Consts.ACLAction GetAction() {
        return this.action;
    }

    public String GetPrinciple() {
        return this.principle;
    }

    public ACLPrivileges GetPrivilege() {
        return this.privilege;
    }

    public int GetLastModifyTime() {
        return this.lastModifyTime;
    }

    public int GetCreateTime() {
        return this.createTime;
    }

    public void SetAction(Consts.ACLAction action) {
        this.action = action;
    }

    public void SetPrinciple(String principle) {
        this.principle = principle;
    }

    public void SetPrivilege(ACLPrivileges privileges) {
        this.privilege = new ACLPrivileges(privileges);
    }

    public void SetLastModifyTime(int lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public void SetCreateTime(int createTime) {
        this.createTime = createTime;
    }

    public JSONObject ToRequestJson() throws LogException {
        if (this.GetPrivilege().ToJsonArray().size() == 0) {
            throw new LogException("BadResponse", "ACL privilege must have at least one value", "");
        }
        JSONObject aclDict = new JSONObject();
        aclDict.put("action", this.GetAction().toString());
        aclDict.put("principle", this.GetPrinciple());
        aclDict.put("privilege", this.GetPrivilege().ToJsonArray());
        return aclDict;
    }

    public String ToRequestString() throws LogException {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() throws LogException {
        if (this.GetPrivilege().ToJsonArray().size() == 0) {
            throw new LogException("BadResponse", "ACL privilege must have at least one value", "");
        }
        JSONObject aclDict = new JSONObject();
        aclDict.put("principle", this.GetPrinciple());
        aclDict.put("privilege", this.GetPrivilege().ToJsonArray());
        aclDict.put("createTime", (Object)this.GetCreateTime());
        aclDict.put("lastModifyTime", (Object)this.GetLastModifyTime());
        return aclDict;
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            String principle = dict.getString("principle");
            JSONArray privilege = dict.getJSONArray("privilege");
            ACLPrivileges privileges = new ACLPrivileges();
            privileges.FromJsonArray(privilege);
            this.SetPrinciple(principle);
            this.SetPrivilege(privileges);
            if (dict.containsKey("action")) {
                String action_value = dict.getString("action");
                if (action_value.toLowerCase().equals("grant")) {
                    this.SetAction(Consts.ACLAction.GRANT);
                } else {
                    this.SetAction(Consts.ACLAction.REVOKE);
                }
            }
            if (dict.containsKey("createTime")) {
                this.createTime = dict.getInt("createTime");
            }
            if (dict.containsKey("lastModifyTime")) {
                this.lastModifyTime = dict.getInt("lastModifyTime");
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateACL", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String aclString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject(aclString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateACL", e.getMessage(), e, "");
        }
    }
}

