/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.log.common.DingTalkNotification;
import com.aliyun.openservices.log.common.EmailNotification;
import com.aliyun.openservices.log.common.JobConfiguration;
import com.aliyun.openservices.log.common.MessageCenterNotification;
import com.aliyun.openservices.log.common.Notification;
import com.aliyun.openservices.log.common.NotificationType;
import com.aliyun.openservices.log.common.Query;
import com.aliyun.openservices.log.common.SmsNotification;
import com.aliyun.openservices.log.common.WebhookNotification;
import com.aliyun.openservices.log.internal.Unmarshaller;
import com.aliyun.openservices.log.util.Args;
import com.aliyun.openservices.log.util.JsonUtils;
import com.aliyun.openservices.log.util.Utils;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class AlertConfiguration
extends JobConfiguration {
    @JSONField
    private String condition;
    @JSONField
    private String dashboard;
    @JSONField
    private List<Query> queryList;
    @JSONField
    private List<Notification> notificationList;
    @JSONField
    private Date muteUntil;
    @JSONField
    private Integer notifyThreshold = 1;
    @JSONField
    private String throttling;

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(String dashboard) {
        this.dashboard = dashboard;
    }

    public List<Query> getQueryList() {
        return this.queryList;
    }

    public void setQueryList(List<Query> queryList) {
        this.queryList = queryList;
    }

    public List<Notification> getNotificationList() {
        return this.notificationList;
    }

    public void setNotificationList(List<Notification> notificationList) {
        this.notificationList = notificationList;
    }

    public Date getMuteUntil() {
        return this.muteUntil;
    }

    public void setMuteUntil(Date muteUntil) {
        this.muteUntil = muteUntil;
    }

    public int getNotifyThreshold() {
        return this.notifyThreshold;
    }

    public void setNotifyThreshold(int notifyThreshold) {
        this.notifyThreshold = notifyThreshold;
    }

    public String getThrottling() {
        return this.throttling;
    }

    public void setThrottling(String throttling) {
        Args.checkDuration(throttling);
        this.throttling = throttling;
    }

    @Override
    public void deserialize(JSONObject value) {
        this.condition = value.getString("condition");
        this.dashboard = value.getString("dashboard");
        this.queryList = JsonUtils.readList(value, "queryList", new Unmarshaller<Query>(){

            @Override
            public Query unmarshal(JSONArray value, int index) {
                Query query = new Query();
                query.deserialize(value.getJSONObject(index));
                return query;
            }
        });
        this.notificationList = JsonUtils.readList(value, "notificationList", new Unmarshaller<Notification>(){

            @Override
            public Notification unmarshal(JSONArray value, int index) {
                JSONObject item = value.getJSONObject(index);
                NotificationType notificationType = NotificationType.fromString(item.getString("type"));
                Notification notification = AlertConfiguration.createNotification(notificationType);
                notification.deserialize(item);
                return notification;
            }
        });
        if (value.has("muteUntil")) {
            this.muteUntil = Utils.timestampToDate(value.getLong("muteUntil"));
        }
        if (value.has("notifyThreshold")) {
            this.notifyThreshold = value.getInt("notifyThreshold");
        }
        if (value.has("throttling")) {
            this.throttling = value.getString("throttling");
        }
    }

    private static Notification createNotification(NotificationType type) {
        switch (type) {
            case DING_TALK: {
                return new DingTalkNotification();
            }
            case EMAIL: {
                return new EmailNotification();
            }
            case MESSAGE_CENTER: {
                return new MessageCenterNotification();
            }
            case SMS: {
                return new SmsNotification();
            }
            case WEBHOOK: {
                return new WebhookNotification();
            }
        }
        throw new IllegalArgumentException("Unimplemented notification type: " + (Object)((Object)type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertConfiguration that = (AlertConfiguration)o;
        if (this.getNotifyThreshold() != that.getNotifyThreshold()) {
            return false;
        }
        if (this.getCondition() != null ? !this.getCondition().equals(that.getCondition()) : that.getCondition() != null) {
            return false;
        }
        if (this.getDashboard() != null ? !this.getDashboard().equals(that.getDashboard()) : that.getDashboard() != null) {
            return false;
        }
        if (this.getQueryList() != null ? !this.getQueryList().equals(that.getQueryList()) : that.getQueryList() != null) {
            return false;
        }
        if (this.getNotificationList() != null ? !this.getNotificationList().equals(that.getNotificationList()) : that.getNotificationList() != null) {
            return false;
        }
        if (this.getMuteUntil() != null ? !this.getMuteUntil().equals(that.getMuteUntil()) : that.getMuteUntil() != null) {
            return false;
        }
        return this.getThrottling() != null ? this.getThrottling().equals(that.getThrottling()) : that.getThrottling() == null;
    }

    public int hashCode() {
        int result = this.getCondition() != null ? this.getCondition().hashCode() : 0;
        result = 31 * result + (this.getDashboard() != null ? this.getDashboard().hashCode() : 0);
        result = 31 * result + (this.getQueryList() != null ? this.getQueryList().hashCode() : 0);
        result = 31 * result + (this.getNotificationList() != null ? this.getNotificationList().hashCode() : 0);
        result = 31 * result + (this.getMuteUntil() != null ? this.getMuteUntil().hashCode() : 0);
        result = 31 * result + this.getNotifyThreshold();
        result = 31 * result + (this.getThrottling() != null ? this.getThrottling().hashCode() : 0);
        return result;
    }
}

