/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class Chart
implements Serializable {
    private static final long serialVersionUID = 7056271803253344862L;
    private String title = "";
    private String type = "";
    private String logstore = "";
    private String topic = "";
    private String query = "";
    private String start = "";
    private String end = "";
    private ArrayList<String> xAxisKeys = new ArrayList();
    private ArrayList<String> yAxisKeys = new ArrayList();
    private long xPosition = 0L;
    private long yPosition = 0L;
    private long width = 0L;
    private long height = 0L;
    private String displayName = "";
    private String rawSearchAttr = "";
    private String rawDisplayAttr = "";
    private String rawActionAttr = "";

    public String getRawSearchAttr() {
        return this.rawSearchAttr;
    }

    public void setRawSearchAttr(String rawSearchAttr) {
        this.rawSearchAttr = rawSearchAttr;
    }

    public String getRawActionAttr() {
        return this.rawActionAttr;
    }

    public void setRawActionAttr(String rawActionAttr) {
        this.rawActionAttr = rawActionAttr;
    }

    public String getRawDisplayAttr() {
        return this.rawDisplayAttr;
    }

    public void setRawDisplayAttr(String rawDisplayAttr) {
        this.rawDisplayAttr = rawDisplayAttr;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLogstore() {
        return this.logstore;
    }

    public void setLogstore(String logstore) {
        this.logstore = logstore;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public ArrayList<String> getxAxisKeys() {
        return this.xAxisKeys;
    }

    public void setxAxisKeys(ArrayList<String> xAxisKeys) {
        this.xAxisKeys = new ArrayList();
        for (String keyName : xAxisKeys) {
            this.xAxisKeys.add(keyName);
        }
    }

    public ArrayList<String> getyAxisKeys() {
        return this.yAxisKeys;
    }

    public void setyAxisKeys(ArrayList<String> yAxisKeys) {
        this.yAxisKeys = new ArrayList();
        for (String keyName : yAxisKeys) {
            this.yAxisKeys.add(keyName);
        }
    }

    public long getxPosition() {
        return this.xPosition;
    }

    public void setxPosition(long xPosition) {
        this.xPosition = xPosition;
    }

    public long getyPosition() {
        return this.yPosition;
    }

    public void setyPosition(long yPosition) {
        this.yPosition = yPosition;
    }

    public long getWidth() {
        return this.width;
    }

    public void setWidth(long width) {
        this.width = width;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Chart() {
    }

    public Chart(String title, String type, String logstore, String topic, String query, String start, String end, ArrayList<String> xAxisKeys, ArrayList<String> yAxisKeys, long xPosition, long yPosition, long width, long height, String displayName) {
        this.title = title;
        this.type = type;
        this.logstore = logstore;
        this.topic = topic;
        this.query = query;
        this.start = start;
        this.end = end;
        this.setxAxisKeys(xAxisKeys);
        this.setyAxisKeys(yAxisKeys);
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.displayName = displayName;
    }

    public JSONObject RawDisplayToJsonObject() {
        JSONObject displayJson = new JSONObject();
        displayJson.put("xPos", (Object)this.getxPosition());
        displayJson.put("yPos", (Object)this.getyPosition());
        displayJson.put("width", (Object)this.getWidth());
        displayJson.put("height", (Object)this.getHeight());
        displayJson.put("displayName", this.getDisplayName());
        JSONArray xAxisArray = new JSONArray();
        for (String keyName : this.getxAxisKeys()) {
            xAxisArray.add(keyName);
        }
        displayJson.put("xAxis", xAxisArray);
        JSONArray yAxisArray = new JSONArray();
        for (String keyName : this.getyAxisKeys()) {
            yAxisArray.add(keyName);
        }
        if (yAxisArray.size() == 0 && xAxisArray.size() > 0) {
            yAxisArray.add(xAxisArray);
        }
        displayJson.put("yAxis", yAxisArray);
        if (this.getRawDisplayAttr().length() > 0) {
            displayJson = JSONObject.fromObject(this.getRawDisplayAttr());
        }
        return displayJson;
    }

    public JSONObject ToJsonObject() {
        JSONObject chartJson = new JSONObject();
        chartJson.put("title", this.getTitle());
        chartJson.put("type", this.getType());
        JSONObject searchJson = new JSONObject();
        if (this.getRawSearchAttr().length() > 0) {
            searchJson = JSONObject.fromObject(this.getRawSearchAttr());
        }
        searchJson.put("logstore", this.getLogstore());
        searchJson.put("topic", this.getTopic());
        searchJson.put("query", this.getQuery());
        searchJson.put("start", this.getStart());
        searchJson.put("end", this.getEnd());
        chartJson.put("search", searchJson);
        chartJson.put("display", this.RawDisplayToJsonObject());
        if (this.getRawActionAttr().length() > 0) {
            chartJson.put("action", JSONObject.fromObject(this.getRawActionAttr()));
        } else {
            chartJson.put("action", JSONObject.fromObject("{}"));
        }
        return chartJson;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            int index;
            this.setTitle(dict.getString("title"));
            this.setType(dict.getString("type"));
            JSONObject searchJson = dict.getJSONObject("search");
            this.setRawSearchAttr(searchJson.toString());
            this.setLogstore(searchJson.getString("logstore"));
            this.setTopic(searchJson.getString("topic"));
            this.setQuery(searchJson.getString("query"));
            this.setStart(searchJson.getString("start"));
            this.setEnd(searchJson.getString("end"));
            JSONObject displayJson = dict.getJSONObject("display");
            this.setRawDisplayAttr(displayJson.toString());
            this.setxPosition(displayJson.getLong("xPos"));
            this.setyPosition(displayJson.getLong("yPos"));
            this.setWidth(displayJson.getLong("width"));
            this.setHeight(displayJson.getLong("height"));
            this.setDisplayName(displayJson.getString("displayName"));
            if (dict.containsKey("action")) {
                JSONObject actionJson = dict.getJSONObject("action");
                this.setRawActionAttr(actionJson.toString());
            }
            if (displayJson.containsKey("xAxis")) {
                JSONArray xAxisArray = displayJson.getJSONArray("xAxis");
                ArrayList<String> xAxisArrayList = new ArrayList<String>();
                for (index = 0; index != xAxisArray.size(); ++index) {
                    xAxisArrayList.add(xAxisArray.getString(index));
                }
                this.setxAxisKeys(xAxisArrayList);
            }
            if (displayJson.containsKey("yAxis")) {
                ArrayList<String> yAxisArrayList = new ArrayList<String>();
                JSONArray yAxisArray = displayJson.getJSONArray("yAxis");
                for (index = 0; index != yAxisArray.size(); ++index) {
                    yAxisArrayList.add(yAxisArray.getString(index));
                }
                this.setyAxisKeys(yAxisArrayList);
            }
        }
        catch (JSONException e) {
            throw new LogException("FailedToGenerateChart", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String chartString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject(chartString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateChart", e.getMessage(), e, "");
        }
    }
}

