/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.log.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import com.aliyun.openservices.log.common.LZ4Encoder;
import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogGroupData;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.Logs;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CompressedLogGroupData
implements Serializable {
    private static final long serialVersionUID = 5482386722654903391L;
    protected int mUncompressedSize;
    protected byte[] mCompressedData = null;

    public CompressedLogGroupData() {
        this.mUncompressedSize = 0;
        this.mCompressedData = null;
    }

    public CompressedLogGroupData(int uncompressedSize, byte[] compressedData) {
        this.mUncompressedSize = uncompressedSize;
        this.mCompressedData = (byte[])compressedData.clone();
    }

    public CompressedLogGroupData(CompressedLogGroupData compressedLogDataInfo) {
        this.mUncompressedSize = compressedLogDataInfo.GetUncompressedSize();
        this.mCompressedData = (byte[])compressedLogDataInfo.GetCompressedData().clone();
    }

    public int GetUncompressedSize() {
        return this.mUncompressedSize;
    }

    public void SetUncompressedSize(int uncompressedSize) {
        this.mUncompressedSize = uncompressedSize;
    }

    public byte[] GetCompressedData() {
        return this.mCompressedData;
    }

    public void SetCompressedData(byte[] compressedData) {
        this.mCompressedData = compressedData;
    }

    public LogGroupData DecompressLogGroup() throws LogException {
        byte[] result = LZ4Encoder.decompressFromLhLz4Chunk(this.mCompressedData, this.mUncompressedSize);
        LogGroupData data = new LogGroupData();
        try {
            Logs.LogGroup logGroup = Logs.LogGroup.parseFrom(result);
            if (logGroup.hasTopic()) {
                data.SetTopic(logGroup.getTopic());
            }
            if (logGroup.hasSource()) {
                data.SetSource(logGroup.getSource());
            }
            List<Logs.Log> logs = logGroup.getLogsList();
            ArrayList<LogItem> logItems = new ArrayList<LogItem>();
            for (Logs.Log log : logs) {
                ArrayList<LogContent> logContents = new ArrayList<LogContent>();
                for (Logs.Log.Content content : log.getContentsList()) {
                    logContents.add(new LogContent(content.getKey(), content.getValue()));
                }
                logItems.add(new LogItem(log.getTime(), logContents));
            }
            data.SetAllLogs(logItems);
        }
        catch (InvalidProtocolBufferException e) {
            throw new LogException("InitLogGroupsError", e.getMessage(), e, "");
        }
        return data;
    }
}

