/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.LogStore;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class InternalLogStore
extends LogStore
implements Serializable {
    private static final long serialVersionUID = -3083306672673249080L;
    private ArrayList<String> operatingAccount = new ArrayList();
    private ArrayList<String> restrictedAction = new ArrayList();
    private String paidAccount = "";
    private boolean allFree = false;
    private Long readCount = 0L;
    private Long writeCount = 0L;
    private Long inflowSize = 0L;
    private Long outflowSize = 0L;
    private Long indexSize = 0L;
    private Long shardSize = 0L;
    private Long freeTtl = 0L;

    public Long getFreeTtl() {
        return this.freeTtl;
    }

    public void setFreeTtl(Long freeTtl) {
        this.freeTtl = freeTtl;
    }

    public ArrayList<String> getOperatingAccount() {
        return this.operatingAccount;
    }

    public void setOperatingAccount(ArrayList<String> operatingAccount) {
        this.operatingAccount = operatingAccount;
    }

    public ArrayList<String> getRestrictedAction() {
        return this.restrictedAction;
    }

    public void setRestrictedAction(ArrayList<String> restrictedAction) {
        this.restrictedAction = restrictedAction;
    }

    public boolean isAllFree() {
        return this.allFree;
    }

    public void setAllFree(boolean allFree) {
        this.allFree = allFree;
    }

    public Long getReadCount() {
        return this.readCount;
    }

    public void setReadCount(Long readCount) {
        this.readCount = readCount;
    }

    public Long getWriteCount() {
        return this.writeCount;
    }

    public void setWriteCount(Long writeCount) {
        this.writeCount = writeCount;
    }

    public Long getInflowSize() {
        return this.inflowSize;
    }

    public void setInflowSize(Long inflowSize) {
        this.inflowSize = inflowSize;
    }

    public Long getOutflowSize() {
        return this.outflowSize;
    }

    public void setOutflowSize(Long outflowSize) {
        this.outflowSize = outflowSize;
    }

    public Long getIndexSize() {
        return this.indexSize;
    }

    public void setIndexSize(Long indexSize) {
        this.indexSize = indexSize;
    }

    public Long getShardSize() {
        return this.shardSize;
    }

    public void setShardSize(Long shardSize) {
        this.shardSize = shardSize;
    }

    public String getPaidAccount() {
        return this.paidAccount;
    }

    public void setPaidAccount(String paidAccount) {
        this.paidAccount = paidAccount;
    }

    @Override
    public JSONObject ToJsonObject() {
        JSONObject jsonObj = new JSONObject();
        jsonObj = this.ToRequestJson();
        JSONArray operatingAccountJson = new JSONArray();
        for (String string : this.operatingAccount) {
            operatingAccountJson.add(string);
        }
        jsonObj.put("operatingAccount", operatingAccountJson);
        JSONArray restrictedActionJson = new JSONArray();
        for (String action : this.restrictedAction) {
            restrictedActionJson.add(action);
        }
        jsonObj.put("restrictedAction", restrictedActionJson);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("paidAccount", this.getPaidAccount());
        jSONObject.put("allFree", (Object)this.isAllFree());
        jSONObject.put("readCount", this.getReadCount());
        jSONObject.put("writeCount", this.getWriteCount());
        jSONObject.put("inflowSize", this.getInflowSize());
        jSONObject.put("outflowSize", this.getOutflowSize());
        jSONObject.put("indexSize", this.getIndexSize());
        jSONObject.put("shardSize", this.getShardSize());
        jSONObject.put("ttl", this.getFreeTtl());
        jsonObj.put("freeCredit", jSONObject);
        return jsonObj;
    }

    @Override
    public String ToRequestString() {
        return this.ToJsonObject().toString();
    }

    @Override
    public void FromJsonString(String logStoreString) throws LogException {
        try {
            int index;
            JSONObject dict = JSONObject.fromObject(logStoreString);
            this.FromJsonObject(dict);
            if (dict.has("freeCredit")) {
                JSONObject freeCredit = dict.getJSONObject("freeCredit");
                if (freeCredit.has("paidAccount")) {
                    this.setPaidAccount(freeCredit.getString("paidAccount"));
                }
                if (freeCredit.has("allFree")) {
                    this.setAllFree(freeCredit.getBoolean("allFree"));
                }
                if (freeCredit.has("readCount")) {
                    this.setReadCount(freeCredit.getLong("readCount"));
                }
                if (freeCredit.has("writeCount")) {
                    this.setWriteCount(freeCredit.getLong("writeCount"));
                }
                if (freeCredit.has("inflowSize")) {
                    this.setInflowSize(freeCredit.getLong("inflowSize"));
                }
                if (freeCredit.has("outflowSize")) {
                    this.setOutflowSize(freeCredit.getLong("outflowSize"));
                }
                if (freeCredit.has("indexSize")) {
                    this.setIndexSize(freeCredit.getLong("indexSize"));
                }
                if (freeCredit.has("shardSize")) {
                    this.setShardSize(freeCredit.getLong("shardSize"));
                }
                if (freeCredit.has("ttl")) {
                    this.setFreeTtl(freeCredit.getLong("ttl"));
                }
            }
            if (dict.has("restrictedAction")) {
                JSONArray restrictedActionArray = dict.getJSONArray("restrictedAction");
                for (index = 0; index < restrictedActionArray.size(); ++index) {
                    this.restrictedAction.add(restrictedActionArray.getString(index));
                }
            }
            if (dict.has("operatingAccount")) {
                JSONArray operatingAccountArray = dict.getJSONArray("operatingAccount");
                for (index = 0; index < operatingAccountArray.size(); ++index) {
                    this.operatingAccount.add(operatingAccountArray.getString(index));
                }
            }
        }
        catch (LogException e) {
            throw new LogException("FailToGenerateInternalLogStore", e.getMessage(), e, "");
        }
    }
}

