/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class MachineStatus
implements Serializable {
    private static final long serialVersionUID = 5680708662484604126L;
    protected String binaryCurVersion = "";
    protected String binaryDeployVersion = "";

    public MachineStatus() {
    }

    public MachineStatus(String binaryCurVersion, String binaryDeployVersion) {
        this.binaryCurVersion = binaryCurVersion;
        this.binaryDeployVersion = binaryDeployVersion;
    }

    public MachineStatus(MachineStatus status) {
        this.binaryCurVersion = status.GetBinaryCurVersion();
        this.binaryDeployVersion = status.GetBinaryDeployVersion();
    }

    public String GetBinaryCurVersion() {
        return this.binaryCurVersion;
    }

    public void SetBinaryCurVersion(String binaryCurVersion) {
        this.binaryCurVersion = binaryCurVersion;
    }

    public String GetBinaryDeployVersion() {
        return this.binaryDeployVersion;
    }

    public void SetBinaryDeployVersion(String binaryDeployVersion) {
        this.binaryDeployVersion = binaryDeployVersion;
    }

    public JSONObject ToJsonObject() {
        JSONObject object = new JSONObject();
        object.put("binaryCurVersion", this.binaryCurVersion);
        object.put("binaryDeployVersion", this.binaryDeployVersion);
        return object;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject statusDict) throws LogException {
        try {
            this.binaryCurVersion = statusDict.getString("binaryCurVersion");
            this.binaryDeployVersion = statusDict.getString("binaryDeployVersion");
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateMachineStatus", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String machineStatusString) throws LogException {
        try {
            JSONObject statusDict = JSONObject.fromObject(machineStatusString);
            this.FromJsonObject(statusDict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateMachineStatus", e.getMessage(), e, "");
        }
    }
}

