/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.OssShipperCsvStorageDetail;
import com.aliyun.openservices.log.common.OssShipperJsonStorageDetail;
import com.aliyun.openservices.log.common.OssShipperParquetStorageDetail;
import com.aliyun.openservices.log.common.OssShipperStorageDetail;
import com.aliyun.openservices.log.common.ShipperConfig;
import com.aliyun.openservices.log.exception.LogException;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class OssShipperConfig
implements ShipperConfig {
    private String mOssBucket;
    private String mOssPrefix;
    private String mRoleArn;
    private int mBufferInterval;
    private int mBufferMb;
    private String mCompressType;
    private String mPathFormat;
    private OssShipperStorageDetail storageDetail;

    public OssShipperConfig(String ossBucket, String ossPrefix, String roleArn, int bufferInterval, int bufferMb) {
        this(ossBucket, ossPrefix, roleArn, bufferInterval, bufferMb, "snappy");
    }

    public OssShipperConfig(String ossBucket, String ossPrefix, String roleArn, int bufferInterval, int bufferMb, String compressType) {
        this(ossBucket, ossPrefix, roleArn, bufferInterval, bufferMb, compressType, "%Y/%m/%d/%H/%M", "json");
    }

    public OssShipperConfig(String ossBucket, String ossPrefix, String roleArn, int bufferInterval, int bufferMb, String compressType, String pathFormat) {
        this(ossBucket, ossPrefix, roleArn, bufferInterval, bufferMb, compressType, pathFormat, "json");
    }

    public OssShipperConfig(String ossBucket, String ossPrefix, String roleArn, int bufferInteval, int bufferMb, String compressType, String pathFormat, String storageFormat) {
        this.mOssBucket = ossBucket;
        this.mOssPrefix = ossPrefix;
        this.mRoleArn = roleArn;
        this.mBufferInterval = bufferInteval;
        this.mBufferMb = bufferMb;
        this.mCompressType = compressType;
        this.mPathFormat = pathFormat;
        this.storageDetail = storageFormat.equals("parquet") ? new OssShipperParquetStorageDetail() : (storageFormat.equals("csv") ? new OssShipperCsvStorageDetail() : new OssShipperJsonStorageDetail());
    }

    public OssShipperConfig() {
    }

    @Override
    public void FromJsonObj(JSONObject obj) throws LogException {
        try {
            this.mOssBucket = obj.getString("ossBucket");
            this.mOssPrefix = obj.getString("ossPrefix");
            this.mRoleArn = obj.getString("roleArn");
            this.mBufferInterval = obj.getInt("bufferInterval");
            this.mBufferMb = obj.getInt("bufferSize");
            this.mCompressType = obj.getString("compressType");
            this.mPathFormat = obj.getString("pathFormat");
            JSONObject storage = obj.getJSONObject("storage");
            String storageFormat = storage.getString("format");
            this.storageDetail = storageFormat.equals("parquet") ? new OssShipperParquetStorageDetail() : (storageFormat.equals("csv") ? new OssShipperCsvStorageDetail() : new OssShipperJsonStorageDetail());
            this.storageDetail.FromJsonObject(obj);
        }
        catch (JSONException e) {
            throw new LogException("FailToParseOssShipperConfig", e.getMessage(), e, "");
        }
    }

    public OssShipperStorageDetail GetStorageDetail() {
        return this.storageDetail;
    }

    public String GetPathFormat() {
        return this.mPathFormat;
    }

    public String GetOssBucket() {
        return this.mOssBucket;
    }

    public String GetOssPrefix() {
        return this.mOssPrefix;
    }

    public String GetRoleArm() {
        return this.mRoleArn;
    }

    public int GetBufferInterval() {
        return this.mBufferInterval;
    }

    public int GetBufferMb() {
        return this.mBufferMb;
    }

    public String GetCompressType() {
        return this.mCompressType;
    }

    public void setOssBucket(String ossBucket) {
        this.mOssBucket = ossBucket;
    }

    public void setOssPrefix(String ossPrefix) {
        this.mOssPrefix = ossPrefix;
    }

    public void setRoleArn(String roleArn) {
        this.mRoleArn = roleArn;
    }

    public void setBufferInterval(int bufferInterval) {
        this.mBufferInterval = bufferInterval;
    }

    public void setBufferMb(int bufferMb) {
        this.mBufferMb = bufferMb;
    }

    public void setCompressType(String compressType) {
        this.mCompressType = compressType;
    }

    public void setPathFormat(String pathFormat) {
        this.mPathFormat = pathFormat;
    }

    public void setStorageDetail(OssShipperStorageDetail storageDetail) {
        this.storageDetail = storageDetail;
    }

    @Override
    public String GetShipperType() {
        return "oss";
    }

    @Override
    public JSONObject GetJsonObj() {
        JSONObject obj = this.storageDetail.ToJsonObject();
        obj.put("ossBucket", this.mOssBucket);
        obj.put("ossPrefix", this.mOssPrefix);
        obj.put("roleArn", this.mRoleArn);
        obj.put("bufferInterval", (Object)this.mBufferInterval);
        obj.put("bufferSize", (Object)this.mBufferMb);
        obj.put("compressType", this.mCompressType);
        obj.put("pathFormat", this.mPathFormat);
        return obj;
    }
}

