/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.CommonConfigInputDetail;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public abstract class LocalFileConfigInputDetail
extends CommonConfigInputDetail
implements Serializable {
    private static final long serialVersionUID = -5807698217939352222L;
    protected String logPath = "";
    protected String logType = "";
    protected String filePattern = "";
    protected String timeFormat = "";
    protected String topicFormat = "none";
    protected boolean preserve = true;
    protected Integer preserveDepth = 0;
    protected String fileEncoding = "utf8";
    protected boolean discardUnmatch = true;
    protected Integer maxDepth = 1000;
    protected boolean tailExisted = false;
    protected boolean discardNonUtf8 = false;
    protected boolean isDockerFile = false;
    protected Map<String, String> dockerIncludeLabel = new HashMap<String, String>();
    protected Map<String, String> dockerExcludeLabel = new HashMap<String, String>();
    protected Map<String, String> dockerIncludeEnv = new HashMap<String, String>();
    protected Map<String, String> dockerExcludeEnv = new HashMap<String, String>();
    protected long delaySkipBytes = 0L;

    public long getDelaySkipBytes() {
        return this.delaySkipBytes;
    }

    public void setDelaySkipBytes(long delaySkipBytes) {
        this.delaySkipBytes = delaySkipBytes;
    }

    public Map<String, String> getDockerIncludeEnv() {
        return this.dockerIncludeEnv;
    }

    public void setDockerIncludeEnv(Map<String, String> dockerIncludeEnv) {
        this.dockerIncludeEnv = dockerIncludeEnv;
    }

    public Map<String, String> getDockerExcludeEnv() {
        return this.dockerExcludeEnv;
    }

    public void setDockerExcludeEnv(Map<String, String> dockerExcludeEnv) {
        this.dockerExcludeEnv = dockerExcludeEnv;
    }

    public Map<String, String> getDockerIncludeLabel() {
        return this.dockerIncludeLabel;
    }

    public void setDockerIncludeLabel(Map<String, String> dockerIncludeLabel) {
        this.dockerIncludeLabel = dockerIncludeLabel;
    }

    public Map<String, String> getDockerExcludeLabel() {
        return this.dockerExcludeLabel;
    }

    public void setDockerExcludeLabel(Map<String, String> dockerExcludeLabel) {
        this.dockerExcludeLabel = dockerExcludeLabel;
    }

    public boolean isDockerFile() {
        return this.isDockerFile;
    }

    public void setDockerFile(boolean isDockerFile) {
        this.isDockerFile = isDockerFile;
    }

    public boolean GetTailExisted() {
        return this.tailExisted;
    }

    public void SetTailExisted(boolean tailExisted) {
        this.tailExisted = tailExisted;
    }

    public boolean GetDiscardNonUtf8() {
        return this.discardNonUtf8;
    }

    public void SetDiscardNonUtf8(boolean discardNonUtf8) {
        this.discardNonUtf8 = discardNonUtf8;
    }

    public String GetLogType() {
        return this.logType;
    }

    public void SetLogType(String logType) {
        this.logType = logType;
    }

    public Integer GetMaxDepth() {
        return this.maxDepth;
    }

    public void SetMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public boolean GetDiscardUnmatch() {
        return this.discardUnmatch;
    }

    public void SetDiscardUnmatch(boolean discardUnmatch) {
        this.discardUnmatch = discardUnmatch;
    }

    public String GetFileEncoding() {
        return this.fileEncoding;
    }

    public void SetFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public boolean GetPreserve() {
        return this.preserve;
    }

    public void SetPreserve(boolean preserve) {
        this.preserve = preserve;
    }

    public Integer GetPreserveDepth() {
        return this.preserveDepth;
    }

    public void SetPreserveDepth(Integer preserveDepth) {
        this.preserveDepth = preserveDepth;
    }

    public String GetLogPath() {
        return this.logPath;
    }

    public void SetLogPath(String logPath) {
        this.logPath = logPath;
    }

    public String GetFilePattern() {
        return this.filePattern;
    }

    public void SetFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String GetTimeFormat() {
        return this.timeFormat;
    }

    public void SetTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String GetTopicFormat() {
        return this.topicFormat;
    }

    public void SetTopicFormat(String topicFormat) {
        this.topicFormat = topicFormat;
    }

    protected void LocalFileConfigToJsonObject(JSONObject jsonObj) {
        this.CommonConfigToJsonObject(jsonObj);
        jsonObj.put((Object)"logPath", (Object)this.logPath);
        jsonObj.put((Object)"filePattern", (Object)this.filePattern);
        jsonObj.put((Object)"logType", (Object)this.logType);
        jsonObj.put((Object)"timeFormat", (Object)this.timeFormat);
        jsonObj.put((Object)"fileEncoding", (Object)this.fileEncoding);
        jsonObj.put((Object)"preserve", (Object)this.preserve);
        jsonObj.put((Object)"preserveDepth", (Object)this.preserveDepth);
        jsonObj.put((Object)"topicFormat", (Object)this.topicFormat);
        jsonObj.put((Object)"maxDepth", (Object)this.maxDepth);
        jsonObj.put((Object)"discardNonUtf8", (Object)this.discardNonUtf8);
        jsonObj.put((Object)"tailExisted", (Object)this.tailExisted);
        jsonObj.put((Object)"dockerFile", (Object)this.isDockerFile);
        jsonObj.put((Object)"delaySkipBytes", (Object)this.delaySkipBytes);
        jsonObj.put((Object)"discardUnmatch", (Object)this.discardUnmatch);
        JSONObject dockerIncludeEnvJson = new JSONObject();
        for (Map.Entry<String, String> entry : this.dockerIncludeEnv.entrySet()) {
            dockerIncludeEnvJson.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        jsonObj.put((Object)"dockerIncludeEnv", (Object)dockerIncludeEnvJson);
        JSONObject dockerExcludeEnvJson = new JSONObject();
        for (Map.Entry<String, String> entry : this.dockerExcludeEnv.entrySet()) {
            dockerExcludeEnvJson.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        jsonObj.put((Object)"dockerExcludeEnv", (Object)dockerExcludeEnvJson);
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, String> entry : this.dockerIncludeLabel.entrySet()) {
            jSONObject.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        jsonObj.put((Object)"dockerIncludeLabel", (Object)jSONObject);
        JSONObject jSONObject2 = new JSONObject();
        for (Map.Entry<String, String> entry : this.dockerExcludeLabel.entrySet()) {
            jSONObject2.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        jsonObj.put((Object)"dockerExcludeLabel", (Object)jSONObject2);
    }

    protected void LocalFileConfigFromJsonObject(JSONObject inputDetail) throws LogException {
        try {
            String key;
            Iterator sIterator;
            this.CommonConfigFromJsonObject(inputDetail);
            this.logPath = inputDetail.getString("logPath");
            this.filePattern = inputDetail.getString("filePattern");
            this.logType = inputDetail.getString("logType");
            this.timeFormat = inputDetail.has("timeFormat") ? inputDetail.getString("timeFormat") : "";
            this.fileEncoding = inputDetail.has("fileEncoding") ? inputDetail.getString("fileEncoding") : "utf8";
            this.preserve = inputDetail.has("preserve") ? inputDetail.getBoolean("preserve") : true;
            this.preserveDepth = inputDetail.has("preserveDepth") ? Integer.valueOf(inputDetail.getInt("preserveDepth")) : Integer.valueOf(0);
            this.discardUnmatch = inputDetail.has("discardUnmatch") ? inputDetail.getBoolean("discardUnmatch") : true;
            this.maxDepth = inputDetail.has("maxDepth") ? Integer.valueOf(inputDetail.getInt("maxDepth")) : Integer.valueOf(1000);
            this.topicFormat = inputDetail.has("topicFormat") ? inputDetail.getString("topicFormat") : "none";
            this.discardNonUtf8 = inputDetail.has("discardNonUtf8") ? inputDetail.getBoolean("discardNonUtf8") : false;
            this.tailExisted = inputDetail.has("tailExisted") ? inputDetail.getBoolean("tailExisted") : false;
            this.isDockerFile = inputDetail.has("dockerFile") ? inputDetail.getBoolean("dockerFile") : false;
            this.delaySkipBytes = inputDetail.has("delaySkipBytes") ? inputDetail.getLong("delaySkipBytes") : 0L;
            if (inputDetail.has("dockerIncludeEnv")) {
                JSONObject dockerIncludeEnvJson = inputDetail.getJSONObject("dockerIncludeEnv");
                sIterator = dockerIncludeEnvJson.keys();
                while (sIterator.hasNext()) {
                    key = sIterator.next().toString();
                    this.dockerIncludeEnv.put(key, dockerIncludeEnvJson.getString(key));
                }
            }
            if (inputDetail.has("dockerExcludeEnv")) {
                JSONObject dockerExcludeEnvJson = inputDetail.getJSONObject("dockerExcludeEnv");
                sIterator = dockerExcludeEnvJson.keys();
                while (sIterator.hasNext()) {
                    key = sIterator.next().toString();
                    this.dockerExcludeEnv.put(key, dockerExcludeEnvJson.getString(key));
                }
            }
            if (inputDetail.has("dockerIncludeLabel")) {
                JSONObject dockerIncludeLabelJson = inputDetail.getJSONObject("dockerIncludeLabel");
                sIterator = dockerIncludeLabelJson.keys();
                while (sIterator.hasNext()) {
                    key = sIterator.next().toString();
                    this.dockerIncludeLabel.put(key, dockerIncludeLabelJson.getString(key));
                }
            }
            if (inputDetail.has("dockerExcludeLabel")) {
                JSONObject dockerExcludeLabelJson = inputDetail.getJSONObject("dockerExcludeLabel");
                sIterator = dockerExcludeLabelJson.keys();
                while (sIterator.hasNext()) {
                    key = sIterator.next().toString();
                    this.dockerExcludeLabel.put(key, dockerExcludeLabelJson.getString(key));
                }
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }
}

