/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.log.internal.Unmarshaller;
import com.aliyun.openservices.log.util.Utils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public final class JsonUtils {
    private static final SerializeConfig SERIALIZE_CONFIG = new SerializeConfig();

    private JsonUtils() {
    }

    public static String serialize(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)SERIALIZE_CONFIG, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static <T> List<T> readList(JSONObject value, String key, Unmarshaller<T> unmarshaller) {
        return JsonUtils.readList(value.getJSONArray(key), unmarshaller);
    }

    public static <T> List<T> readList(JSONArray list, Unmarshaller<T> unmarshaller) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> values = new ArrayList<T>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            values.add(unmarshaller.unmarshal(list, i));
        }
        return values;
    }

    public static List<String> readOptionalStrings(JSONObject object, String key) {
        if (!object.has(key)) {
            return Collections.emptyList();
        }
        try {
            return JsonUtils.readStringList(object, key);
        }
        catch (JSONException ex) {
            return Collections.emptyList();
        }
    }

    public static List<String> readStringList(JSONObject object, String key) {
        return JsonUtils.readList(object, key, new Unmarshaller<String>(){

            @Override
            public String unmarshal(JSONArray value, int index) {
                return value.getString(index);
            }
        });
    }

    public static String readOptionalString(JSONObject object, String key) {
        return object.has(key) ? object.getString(key) : null;
    }

    public static boolean readBool(JSONObject object, String key, boolean defaultValue) {
        return object.has(key) ? object.getBoolean(key) : defaultValue;
    }

    public static Integer readOptionalInt(JSONObject object, String key) {
        return object.has(key) ? Integer.valueOf(object.getInt(key)) : null;
    }

    static {
        SERIALIZE_CONFIG.put(Date.class, (ObjectSerializer)new DateToUnixTimestampSerializer());
    }

    private static class DateToUnixTimestampSerializer
    implements ObjectSerializer {
        private DateToUnixTimestampSerializer() {
        }

        public void write(JSONSerializer serializer, Object date, Object fieldName, Type fieldType, int features) {
            if (date != null) {
                serializer.write((Object)Utils.dateToTimestamp((Date)date));
            }
        }
    }
}

