/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;

public class Resource
implements Serializable {
    private static final long serialVersionUID = 8648928694568240078L;
    private String name = "";
    private String type = "";
    private String schema = null;
    private String acl = null;
    private String description = null;
    private String extInfo = null;
    private long createTime = 0L;
    private long lastModifyTime = 0L;

    public long getCreateTime() {
        return this.createTime;
    }

    public long getLastModifyTime() {
        return this.lastModifyTime;
    }

    public Resource(String name, String type, String schema, String acl, String description, String extInfo) {
        this.name = name;
        this.type = type;
        this.schema = schema;
        this.acl = acl;
        this.description = description;
        this.extInfo = extInfo;
    }

    public Resource(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public Resource() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getAcl() {
        return this.acl;
    }

    public void setAcl(String acl) {
        this.acl = acl;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExtInfo() {
        return this.extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public JSONObject ToJsonObject() throws LogException {
        JSONObject result = new JSONObject();
        result.put("name", (Object)this.getName());
        result.put("type", (Object)this.getType());
        if (this.schema != null) {
            result.put("schema", (Object)this.getSchema());
        }
        if (this.description != null) {
            result.put("description", (Object)this.getDescription());
        }
        if (this.extInfo != null) {
            result.put("extInfo", (Object)this.getExtInfo());
        }
        if (this.acl != null) {
            result.put("acl", (Object)this.getAcl());
        }
        return result;
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        this.setName(dict.getString("name"));
        this.setType(dict.getString("type"));
        if (dict.containsKey((Object)"description")) {
            this.setDescription(dict.getString("description"));
        }
        if (dict.containsKey((Object)"schema")) {
            this.setSchema(dict.getString("schema"));
            try {
                JSONObject.parseObject((String)dict.getString("schema"));
            }
            catch (JSONException e) {
                throw new LogException("BadResponse", "response resource schema is not valid json", e, e.getMessage());
            }
        }
        if (dict.containsKey((Object)"acl")) {
            this.setAcl(dict.getString("acl"));
            try {
                JSONObject.parseObject((String)dict.getString("acl"));
            }
            catch (JSONException e) {
                throw new LogException("BadResponse", "response resource acl is not valid json", e, e.getMessage());
            }
        }
        if (dict.containsKey((Object)"extInfo")) {
            this.setExtInfo(dict.getString("extInfo"));
        }
        if (dict.containsKey((Object)"createTime")) {
            this.createTime = dict.getIntValue("createTime");
        }
        if (dict.containsKey((Object)"lastModifyTime")) {
            this.lastModifyTime = dict.getIntValue("lastModifyTime");
        }
    }

    public void FromJsonString(String content) throws LogException {
        JSONObject dict = JSONObject.parseObject((String)content);
        this.FromJsonObject(dict);
    }

    public void checkForCreate() throws IllegalArgumentException {
        if (this.name == null || this.type == null || this.name.isEmpty() || this.type.isEmpty()) {
            throw new IllegalArgumentException("name/type/owner is null/empty");
        }
        if (this.schema != null) {
            try {
                JSONObject.parseObject((String)this.schema);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("resource schema not valid json");
            }
        }
        if (this.acl != null) {
            try {
                JSONObject.parseObject((String)this.acl);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("resource acl not valid json");
            }
        }
    }

    public void checkForUpsert() throws IllegalArgumentException {
        this.checkForCreate();
    }

    public void checkForUpdate() throws IllegalArgumentException {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("name is null/empty");
        }
        if (this.schema != null) {
            try {
                JSONObject.parseObject((String)this.schema);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("resource schema not valid json");
            }
        }
        if (this.acl != null) {
            try {
                JSONObject.parseObject((String)this.acl);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("resource acl not valid json");
            }
        }
    }
}

