/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.log.common.AlertConfiguration;
import com.aliyun.openservices.log.common.AuditJobConfiguration;
import com.aliyun.openservices.log.common.ETLConfiguration;
import com.aliyun.openservices.log.common.ExportConfiguration;
import com.aliyun.openservices.log.common.IngestionConfiguration;
import com.aliyun.openservices.log.common.JobConfiguration;
import com.aliyun.openservices.log.common.JobSchedule;
import com.aliyun.openservices.log.common.JobState;
import com.aliyun.openservices.log.common.JobType;
import com.aliyun.openservices.log.common.RebuildIndexConfiguration;
import com.aliyun.openservices.log.common.ReportConfiguration;
import com.aliyun.openservices.log.util.JsonUtils;
import com.aliyun.openservices.log.util.Utils;
import java.io.Serializable;
import java.util.Date;

public class Job
implements Serializable {
    private static final long serialVersionUID = 6457720937101208563L;
    @JSONField
    private String name;
    @JSONField
    private String displayName;
    @JSONField
    private JobType type;
    @JSONField
    private String description;
    private Date createTime;
    private Date lastModifiedTime;
    @JSONField
    private JobSchedule schedule;
    @JSONField
    private JobState state;
    @JSONField
    private JobConfiguration configuration;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public JobType getType() {
        return this.type;
    }

    public void setType(JobType type) {
        this.type = type;
    }

    public JobSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(JobSchedule schedule) {
        this.schedule = schedule;
    }

    public JobState getState() {
        return this.state;
    }

    public void setState(JobState state) {
        this.state = state;
    }

    public JobConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JobConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    private static JobConfiguration createConfiguration(JobType type) {
        switch (type) {
            case ALERT: {
                return new AlertConfiguration();
            }
            case REPORT: {
                return new ReportConfiguration();
            }
            case ETL: {
                return new ETLConfiguration();
            }
            case EXPORT: {
                return new ExportConfiguration();
            }
            case AUDIT_JOB: {
                return new AuditJobConfiguration();
            }
            case INGESTION: {
                return new IngestionConfiguration();
            }
            case REBUILD_INDEX: {
                return new RebuildIndexConfiguration();
            }
        }
        return null;
    }

    public void deserialize(JSONObject value) {
        this.name = value.getString("name");
        this.displayName = JsonUtils.readOptionalString(value, "displayName");
        this.type = JobType.fromString(value.getString("type"));
        if (value.containsKey((Object)"state")) {
            this.state = JobState.fromString(value.getString("state"));
        }
        this.description = JsonUtils.readOptionalString(value, "description");
        if (value.containsKey((Object)"createTime")) {
            this.createTime = Utils.timestampToDate(value.getLong("createTime"));
        }
        if (value.containsKey((Object)"lastModifiedTime")) {
            this.lastModifiedTime = Utils.timestampToDate(value.getLong("lastModifiedTime"));
        }
        this.schedule = new JobSchedule();
        this.schedule.deserialize(value.getJSONObject("schedule"));
        this.configuration = Job.createConfiguration(this.type);
        if (this.configuration != null) {
            this.configuration.deserialize(value.getJSONObject("configuration"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        if (this.getName() != null ? !this.getName().equals(job.getName()) : job.getName() != null) {
            return false;
        }
        if (this.getDisplayName() != null ? !this.getDisplayName().equals(job.getDisplayName()) : job.getDisplayName() != null) {
            return false;
        }
        if (this.getType() != job.getType()) {
            return false;
        }
        if (this.getDescription() != null ? !this.getDescription().equals(job.getDescription()) : job.getDescription() != null) {
            return false;
        }
        if (this.getCreateTime() != null ? !this.getCreateTime().equals(job.getCreateTime()) : job.getCreateTime() != null) {
            return false;
        }
        if (this.getLastModifiedTime() != null ? !this.getLastModifiedTime().equals(job.getLastModifiedTime()) : job.getLastModifiedTime() != null) {
            return false;
        }
        if (this.getSchedule() != null ? !this.getSchedule().equals(job.getSchedule()) : job.getSchedule() != null) {
            return false;
        }
        if (this.getState() != job.getState()) {
            return false;
        }
        return this.getConfiguration() != null ? this.getConfiguration().equals(job.getConfiguration()) : job.getConfiguration() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + (this.getDisplayName() != null ? this.getDisplayName().hashCode() : 0);
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        result = 31 * result + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
        result = 31 * result + (this.getCreateTime() != null ? this.getCreateTime().hashCode() : 0);
        result = 31 * result + (this.getLastModifiedTime() != null ? this.getLastModifiedTime().hashCode() : 0);
        result = 31 * result + (this.getSchedule() != null ? this.getSchedule().hashCode() : 0);
        result = 31 * result + (this.getState() != null ? this.getState().hashCode() : 0);
        result = 31 * result + (this.getConfiguration() != null ? this.getConfiguration().hashCode() : 0);
        return result;
    }
}

